-- Consolidated stats gather procedure for Oracle Primavera P6 8.x and beyond
-- Brian Diehl, April 2013

/* 

Versions
1.0 - 4/2013 Target version 8.x Non-Histogram for most tables. Fixed stats for dynamic. PROJ_NODE_FLAG Freq-histogram

This script is meant to stabilize the stats gathering process for P6. It is not necessary
to run this process unless there has been a significant change in the contents of the
database. The process will create a backup of existing statistics before the run. 

This process will do default statistics for tables not explicitly noted.

*/
set verify off

variable v_def_estimate_percent varchar2(100)
exec :v_def_estimate_percent := 'DBMS_STATS.AUTO_SAMPLE_SIZE'
variable v_def_degree varchar2(100)
exec :v_def_degree := 'DBMS_STATS.AUTO_DEGREE'
variable v_def_method_opt varchar2(100)
--exec :v_def_method_opt := 'for all indexed columns size skewonly'
exec :v_def_method_opt := 'for all columns size 1' 
variable vstat_table_name varchar2(30)
exec :vstat_table_name := 'PM_8X_STATS'

DEFINE vwrk_table='tmp_stats_wrk_table'

variable v_excluded_tables varchar2(4000)
exec :v_excluded_tables := '''USESSION'',''PROJSHAR'',''REFRDEL'',''UPKLIST'',''PKXREF'''

set linesize 132

declare
  vcnt number;
begin
  select count(*) into vcnt
  from user_tables
  where table_name = upper('&vwrk_table');
  if vcnt > 0 then
    execute immediate 'drop table &vwrk_table purge';
  end if;
  execute immediate 'create table &vwrk_table as '
               || ' select table_name, ''Y'' default_stats from user_tables';

  execute immediate 'update &vwrk_table set default_stats = ''N'' '
              || ' where table_name in (' || :v_excluded_tables || ')';
              
  commit;
  
end;
/


set serveroutput on size 1000000

-- Create Stats Table
declare
  vcnt number;
  vstats_name varchar2(100) := 'BACKUP_PRE_' || to_char(sysdate,'yyyymmddhh24mi');
begin
  select count(*) into vcnt
  from user_tables
  where table_name = upper(:vstat_table_name);
  if vcnt = 0 then
    dbms_stats.create_stat_table(ownname=>user, stattab=>:vstat_table_name);
  end if;
  
  dbms_output.put_line('Saving stats in ' || :vstat_table_name || ' StatId=' || vstats_name);
  
  dbms_stats.export_schema_stats(ownname=>user
                                , stattab=>:vstat_table_name
                                , statid=>vstats_name);
  dbms_stats.export_system_stats(stattab=>:vstat_table_name
                                , statid=>vstats_name);
  
end;
/

set feed off timing off
spool tmp_pm_gather.tmp
-- Gather default stats
set termout off
declare
  vstat_sql varchar2(1000);
  vlock_stat_sql varchar2(1000);
  vstats_name varchar2(100) := 'NEW_STATS_' || to_char(sysdate,'yyyymmdd');
  vtotal number;
  vcnt number;
begin
  vstat_sql := 'begin ' 
     ||   chr(10) ||' dbms_stats.gather_table_stats('
     ||  chr(10) || '    ownname=>user' 
    ||   chr(10) || '   ,tabname=>:tab_name'
    ||   chr(10) || '   ,estimate_percent=>' || trim(:v_def_estimate_percent) || ''
    ||   chr(10) || '   ,method_opt=>''' || :v_def_method_opt || ''''
    ||   chr(10) || '   ,degree=>' || trim(:v_def_degree) || ''
    ||   chr(10) || '   ,cascade=>true'
    ||   chr(10) || '   ,stattab=>''' || :vstat_table_name || ''''
    ||   chr(10) || '   ,statid=>''' || vstats_name || ''''
    ||   chr(10) || '   ,force=>true'    
    ||   chr(10) || '   );'
    ||    chr(10) || 'end;';

  vlock_stat_sql := 'begin ' 
     ||   chr(10) ||' dbms_stats.lock_table_stats('
     ||  chr(10) || '    ownname=>user' 
    ||   chr(10) || '   ,tabname=>:tab_name'
    ||   chr(10) || '   );'
    ||    chr(10) || 'end;';
  
  select count(*) into vtotal 
  from &vwrk_table 
  where default_stats = 'Y' -- and rownum <=20
  ;
  
  dbms_output.put_line('variable tab_name varchar2(30)');
  vcnt := 0;
  for trec in (select t.*
               from  &vwrk_table t
               where default_stats = 'Y' --and rownum <=20
               order by table_name) loop
    vcnt := vcnt + 1;
    dbms_output.put_line('prompt Default collecting for ' || trec.table_name || ' ' || vcnt || ' of ' || vtotal );
    dbms_output.put_line('exec :tab_name := ''' || trec.table_name || '''');
               
    dbms_output.put_line(vstat_sql);
    dbms_output.put_line('/');
    
    dbms_output.put_line(vlock_stat_sql);
    dbms_output.put_line('/');
    --execute immediate vstat_sql using trec.table_name;
    
    --execute immediate vlock_stat_sql using trec.table_name;
  end loop;
  
end;
/
spool off 

set termout on

spool orpm_stats_gather.log

@@tmp_pm_gather.tmp
set feed on
@@orpm_stats_gather_b
@@orpm_stats_gather_c

spool off

/* Recommended Actions

alter system flush shared_pool;

*/

/*
 -- OLD Stats can be restored using 
 -- 
 exec dbms_stats.import_schema_stats(user,'PM_8X_STATS','&name_of_stats');
*/
