
--METADATA NAME:ACCOUNT TYPE:TABLE CHANGE:CREATE
CREATE TABLE ACCOUNT(
  ACCT_ID  INTEGER NOT NULL,
  ACCT_SEQ_NUM  INTEGER NOT NULL,
  ACCT_SHORT_NAME  VARCHAR2(40) NOT NULL,
  ACCT_NAME  VARCHAR2(100) NOT NULL,
  PARENT_ACCT_ID  INTEGER NULL,
  ACCT_DESCR  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_account PRIMARY KEY (acct_id))
/

--METADATA NAME:ACTVCODE TYPE:TABLE CHANGE:CREATE
CREATE TABLE ACTVCODE(
  ACTV_CODE_ID  INTEGER NOT NULL,
  ACTV_CODE_TYPE_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  SHORT_NAME  VARCHAR2(60) NOT NULL,
  PARENT_ACTV_CODE_ID  INTEGER NULL,
  ACTV_CODE_NAME  VARCHAR2(120) NULL,
  COLOR  VARCHAR2(6) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_actvcode PRIMARY KEY (actv_code_id) ,CONSTRAINT fk_actvcode_actvtype FOREIGN KEY (actv_code_type_id)
REFERENCES ACTVTYPE (actv_code_type_id) 
)
/

--METADATA NAME:ACTVTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE ACTVTYPE(
  ACTV_CODE_TYPE_ID  INTEGER NOT NULL,
  ACTV_SHORT_LEN  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  ACTV_CODE_TYPE  VARCHAR2(40) NOT NULL,
  ACTV_CODE_TYPE_SCOPE  VARCHAR2(10) NOT NULL,
  PROJ_ID  INTEGER NULL,
  SUPER_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_actvtype PRIMARY KEY (actv_code_type_id) ,CONSTRAINT fk_actvtype_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
)
/

--METADATA NAME:ADMIN_CONFIG TYPE:TABLE CHANGE:CREATE
CREATE TABLE ADMIN_CONFIG(
  CONFIG_NAME  VARCHAR2(255) NOT NULL,
  CONFIG_TYPE  VARCHAR2(10) NULL,
  FACTORY_VERSION  VARCHAR2(10) NULL,
  LAST_CHANGE_DATE  DATETIME DEFAULT sysdate NOT NULL,
  CONFIG_VALUE  VARCHAR2(255) NULL,
  CONFIG_DATA  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_admin_config PRIMARY KEY (config_name))
/

--METADATA NAME:ASGNMNTACAT TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTACAT(
  TASKRSRC_ID  INTEGER NOT NULL,
  ASGNMNT_CATG_TYPE_ID  INTEGER NOT NULL,
  ASGNMNT_CATG_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_asgnmntacat PRIMARY KEY (taskrsrc_id,asgnmnt_catg_type_id) ,CONSTRAINT fk_asgnmntacat_asgnmntcattype FOREIGN KEY (asgnmnt_catg_type_id)
REFERENCES ASGNMNTCATTYPE (asgnmnt_catg_type_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_asgnmntacat_asgnmntcatval FOREIGN KEY (asgnmnt_catg_id)
REFERENCES ASGNMNTCATVAL (asgnmnt_catg_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_asgnmntacat_taskrsrc FOREIGN KEY (taskrsrc_id)
REFERENCES TASKRSRC (taskrsrc_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_asgnmntacat_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:ASGNMNTCATTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTCATTYPE(
  ASGNMNT_CATG_TYPE_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  ASGNMNT_CATG_SHORT_LEN  INTEGER NOT NULL,
  ASGNMNT_CATG_TYPE  VARCHAR2(60) NOT NULL,
  SUPER_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_asgnmntcattype PRIMARY KEY (asgnmnt_catg_type_id))
/

--METADATA NAME:ASGNMNTCATVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTCATVAL(
  ASGNMNT_CATG_ID  INTEGER NOT NULL,
  ASGNMNT_CATG_TYPE_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  ASGNMNT_CATG_SHORT_NAME  VARCHAR2(60) NOT NULL,
  ASGNMNT_CATG_NAME  VARCHAR2(100) NULL,
  PARENT_ASGNMNT_CATG_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_asgnmntcatval PRIMARY KEY (asgnmnt_catg_id) ,CONSTRAINT fk_asgncatval_asgnmntcattype FOREIGN KEY (asgnmnt_catg_type_id)
REFERENCES ASGNMNTCATTYPE (asgnmnt_catg_type_id) 
)
/

--METADATA NAME:BASETYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE BASETYPE(
  BASE_TYPE_ID  INTEGER NOT NULL,
  BASE_TYPE_SEQ_NUM  INTEGER NOT NULL,
  BASE_TYPE  VARCHAR2(40) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_basetype PRIMARY KEY (base_type_id))
/

--METADATA NAME:BGPLOG TYPE:TABLE CHANGE:CREATE
CREATE TABLE BGPLOG(
  LOG_TIME  DATETIME DEFAULT sysdate NULL,
  SOURCE  VARCHAR2(255) NULL,
  TYPE  VARCHAR2(255) NULL,
  DESCRIPTION  VARCHAR2(4000) NULL
)
/

--METADATA NAME:BRE_REGISTRY TYPE:TABLE CHANGE:CREATE
CREATE TABLE BRE_REGISTRY(
  BRE_REGISTRY_ID  VARCHAR2(50) NOT NULL,
  IP_ADDRESS  VARCHAR2(30) NOT NULL,
  START_TIME  DATETIME NOT NULL,
  LAST_TIME  DATETIME NULL,
  STATUS_CODE  CHAR(1) NOT NULL,
  TORCHED_TIME  DATETIME NULL,
  CONFIG_NAME  VARCHAR2(30) NOT NULL,
  CONFIG_CHANGED_FLAG  CHAR(1) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_bre_registry PRIMARY KEY (bre_registry_id))
/

--METADATA NAME:BUDGCHNG TYPE:TABLE CHANGE:CREATE
CREATE TABLE BUDGCHNG(
  BUDG_CHNG_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  WBS_ID  INTEGER NOT NULL,
  CHNG_DATE  DATETIME NOT NULL,
  CHNG_SHORT_NAME  VARCHAR2(32) NOT NULL,
  CHNG_COST  REAL NULL,
  CHNG_BY_NAME  VARCHAR2(255) NULL,
  STATUS_CODE  VARCHAR2(30) NULL,
  CHNG_DESCR  VARCHAR2(130) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_budgchng PRIMARY KEY (budg_chng_id) ,CONSTRAINT fk_budgchng_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_budgchng_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
)
/

--METADATA NAME:CALENDAR TYPE:TABLE CHANGE:CREATE
CREATE TABLE CALENDAR(
  CLNDR_ID  INTEGER NOT NULL,
  DEFAULT_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  RSRC_PRIVATE  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  CLNDR_NAME  VARCHAR2(255) NOT NULL,
  PROJ_ID  INTEGER NULL,
  BASE_CLNDR_ID  INTEGER NULL,
  LAST_CHNG_DATE  DATETIME NULL,
  CLNDR_TYPE  VARCHAR2(16) NULL,
  CLNDR_DATA  BLOB NULL,
  DAY_HR_CNT  REAL NULL,
  WEEK_HR_CNT  REAL NULL,
  YEAR_HR_CNT  REAL NULL,
  MONTH_HR_CNT  REAL NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_calendar PRIMARY KEY (clndr_id) ,CONSTRAINT fk_calendar_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
)
/

--METADATA NAME:COSTTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE COSTTYPE(
  COST_TYPE_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  COST_TYPE  VARCHAR2(36) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_costtype PRIMARY KEY (cost_type_id))
/

--METADATA NAME:CURRTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE CURRTYPE(
  CURR_ID  INTEGER NOT NULL,
  DECIMAL_DIGIT_CNT  INTEGER NOT NULL,
  CURR_SYMBOL  VARCHAR2(6) NOT NULL,
  DECIMAL_SYMBOL  VARCHAR2(6) NOT NULL,
  DIGIT_GROUP_SYMBOL  VARCHAR2(6) NOT NULL,
  POS_CURR_FMT_TYPE  VARCHAR2(20) NOT NULL,
  NEG_CURR_FMT_TYPE  VARCHAR2(20) NOT NULL,
  CURR_TYPE  VARCHAR2(40) NOT NULL,
  CURR_SHORT_NAME  VARCHAR2(6) NOT NULL,
  GROUP_DIGIT_CNT  INTEGER DEFAULT 3 NOT NULL,
  BASE_EXCH_RATE  REAL NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_currtype PRIMARY KEY (curr_id))
/

--METADATA NAME:DASHBOARD TYPE:TABLE CHANGE:CREATE
CREATE TABLE DASHBOARD(
  DASHBOARD_ID  INTEGER NOT NULL,
  DASHBOARD_NAME  VARCHAR2(255) NOT NULL,
  USER_ID  INTEGER NULL,
  TABLE_NAME  VARCHAR2(30) NULL,
  FK_ID  INTEGER NULL,
  LOCK_FILTER_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  MAX_ROWS_PER_PORTLET  INTEGER NULL,
  DASHBOARD_LAYOUT_DATA  VARCHAR2(4000) NULL,
  PORTLET_SETTINGS_DATA  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_dashboard PRIMARY KEY (dashboard_id) ,CONSTRAINT fk_dashboard_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:DASHUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE DASHUSER(
  DASHBOARD_ID  INTEGER NOT NULL,
  USER_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_dashuser PRIMARY KEY (dashboard_id,user_id) ,CONSTRAINT fk_dashuser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_dashuser_dashboard FOREIGN KEY (dashboard_id)
REFERENCES DASHBOARD (dashboard_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:DISCUSSION TYPE:TABLE CHANGE:CREATE
CREATE TABLE DISCUSSION(
  DISCUSSION_ID  INTEGER NOT NULL,
  TASK_ID  INTEGER NOT NULL,
  DISCUSSION_VALUE  VARCHAR2(4000) NULL,
  DISCUSSION_DATE  DATETIME NULL,
  USER_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_discussion PRIMARY KEY (discussion_id) ,CONSTRAINT fk_discussion_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:DISCUSSION_READ TYPE:TABLE CHANGE:CREATE
CREATE TABLE DISCUSSION_READ(
  DISCUSSION_ID  INTEGER NOT NULL,
  USER_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_discussion_read PRIMARY KEY (discussion_id,user_id) ,CONSTRAINT fk_discussion_read_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
 ,CONSTRAINT fk_discussion_read_discussion FOREIGN KEY (discussion_id)
REFERENCES DISCUSSION (discussion_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:DLTACCT TYPE:TABLE CHANGE:CREATE
CREATE TABLE DLTACCT(
  SESSION_ID  INTEGER NOT NULL,
  ACCT_ID  INTEGER NOT NULL
)
/

--METADATA NAME:DLTACTV TYPE:TABLE CHANGE:CREATE
CREATE TABLE DLTACTV(
  SESSION_ID  INTEGER NOT NULL,
  ACTV_CODE_ID  INTEGER NOT NULL,
  PARENT_ACTV_CODE_ID  INTEGER NULL
)
/

--METADATA NAME:DLTOBS TYPE:TABLE CHANGE:CREATE
CREATE TABLE DLTOBS(
  SESSION_ID  INTEGER NOT NULL,
  OBS_ID  INTEGER NOT NULL
)
/

--METADATA NAME:DLTROLE TYPE:TABLE CHANGE:CREATE
CREATE TABLE DLTROLE(
  SESSION_ID  INTEGER NOT NULL,
  ROLE_ID  INTEGER NOT NULL
)
/

--METADATA NAME:DLTRSRC TYPE:TABLE CHANGE:CREATE
CREATE TABLE DLTRSRC(
  SESSION_ID  INTEGER NOT NULL,
  RSRC_ID  INTEGER NOT NULL
)
/

--METADATA NAME:DLTRSRL TYPE:TABLE CHANGE:CREATE
CREATE TABLE DLTRSRL(
  SESSION_ID  INTEGER NOT NULL,
  RSRC_ID  INTEGER NOT NULL,
  ROLE_ID  INTEGER NOT NULL
)
/

--METADATA NAME:DLTUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE DLTUSER(
  SESSION_ID  INTEGER NOT NULL,
  USER_ID  INTEGER NOT NULL
)
/

--METADATA NAME:DOCCATG TYPE:TABLE CHANGE:CREATE
CREATE TABLE DOCCATG(
  DOC_CATG_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  DOC_CATG_NAME  VARCHAR2(100) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_doccatg PRIMARY KEY (doc_catg_id))
/

--METADATA NAME:DOCREVIEW TYPE:TABLE CHANGE:CREATE
CREATE TABLE DOCREVIEW(
  DOC_REVIEW_ID  INTEGER NOT NULL,
  DOC_ID  INTEGER NOT NULL,
  USER_ID  INTEGER NULL,
  REVIEW_NAME  VARCHAR2(255) NULL,
  REVIEW_DESCR  VARCHAR2(255) NULL,
  REVIEW_TYPE  VARCHAR2(15) NULL,
  DUE_DATE  DATETIME NULL,
  STATUS  VARCHAR2(15) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_docreview PRIMARY KEY (doc_review_id) ,CONSTRAINT fk_docreview_document FOREIGN KEY (doc_id)
REFERENCES DOCUMENT (doc_id) 
 ,CONSTRAINT fk_docreview_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:DOCREVIEWTASK TYPE:TABLE CHANGE:CREATE
CREATE TABLE DOCREVIEWTASK(
  REVIEW_TASK_ID  INTEGER NOT NULL,
  DOC_REVIEW_ID  INTEGER NOT NULL,
  USER_ID  INTEGER NULL,
  REVIEW_DATE  DATETIME NULL,
  COMMENTS  VARCHAR2(4000) NULL,
  PRIORITY  INTEGER NULL,
  STATUS  VARCHAR2(15) NULL,
  ATTACHMENT_UUID  VARCHAR2(4000) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_docreviewtask PRIMARY KEY (review_task_id) ,CONSTRAINT fk_docreviewtask_docreview FOREIGN KEY (doc_review_id)
REFERENCES DOCREVIEW (doc_review_id) 
 ,CONSTRAINT fk_docreviewtask_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:DOCSTAT TYPE:TABLE CHANGE:CREATE
CREATE TABLE DOCSTAT(
  DOC_STATUS_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  DOC_STATUS_CODE  VARCHAR2(36) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_docstat PRIMARY KEY (doc_status_id))
/

--METADATA NAME:DOCUMENT TYPE:TABLE CHANGE:CREATE
CREATE TABLE DOCUMENT(
  DOC_ID  INTEGER NOT NULL,
  DOC_SEQ_NUM  INTEGER NOT NULL,
  DELIV_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  DOC_NAME  VARCHAR2(120) NOT NULL,
  PARENT_DOC_ID  INTEGER NULL,
  PROJ_ID  INTEGER NULL,
  DOC_STATUS_ID  INTEGER NULL,
  DOC_CATG_ID  INTEGER NULL,
  DOC_DATE  DATETIME NULL,
  VERSION_NAME  VARCHAR2(20) DEFAULT '1' NOT NULL,
  GUID  VARCHAR2(22) NULL,
  TMPL_GUID  VARCHAR2(22) NULL,
  DOC_SHORT_NAME  VARCHAR2(32) NULL,
  AUTHOR_NAME  VARCHAR2(255) NULL,
  PRIVATE_LOC  VARCHAR2(4000) NULL,
  PUBLIC_LOC  VARCHAR2(4000) NULL,
  DOC_CONTENT  BLOB NULL,
  RSRC_ID  INTEGER NULL,
  DOC_MGMT_TYPE  VARCHAR2(10) DEFAULT 'DM_Local' NOT NULL,
  EXTERNAL_DOC_KEY  VARCHAR2(4000) NULL,
  CR_EXTERNAL_DOC_KEY  VARCHAR2(4000) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_document PRIMARY KEY (doc_id) ,CONSTRAINT fk_document_doccatg FOREIGN KEY (doc_catg_id)
REFERENCES DOCCATG (doc_catg_id) 
 ,CONSTRAINT fk_document_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_document_docstat FOREIGN KEY (doc_status_id)
REFERENCES DOCSTAT (doc_status_id) 
 ,CONSTRAINT fk_document_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
)
/

--METADATA NAME:EXPPROJ TYPE:TABLE CHANGE:CREATE
CREATE TABLE EXPPROJ(
  PROJ_ID  INTEGER NOT NULL,
  EXP_GROUP  VARCHAR2(255) NOT NULL,
  EXP_PROJ_NAME  VARCHAR2(24) NOT NULL,
  LOGIN_SUPPLIED_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  EXP_USER_NAME  VARCHAR2(40) NULL,
  EXP_PASSWD  VARCHAR2(60) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_expproj PRIMARY KEY (proj_id) ,CONSTRAINT fk_expproj_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:EXTAPP TYPE:TABLE CHANGE:CREATE
CREATE TABLE EXTAPP(
  APP_ID  INTEGER NOT NULL,
  LOGIN_SUPPLY_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  APP_NAME  VARCHAR2(100) NOT NULL,
  APP_EXE_NAME  VARCHAR2(100) NOT NULL,
  PROJ_ID  INTEGER NULL,
  APP_USER_NAME  VARCHAR2(40) NULL,
  APP_PASSWD  VARCHAR2(100) NULL,
  APP_DATA_NAME  VARCHAR2(100) NULL,
  APP_PARM_STRING  VARCHAR2(255) NULL,
  APP_DATA_LOC  VARCHAR2(255) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_extapp PRIMARY KEY (app_id) ,CONSTRAINT fk_extapp_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
)
/

--METADATA NAME:FACTOR TYPE:TABLE CHANGE:CREATE
CREATE TABLE FACTOR(
  FACT_ID  INTEGER NOT NULL,
  FACT_SEQ_NUM  INTEGER NOT NULL,
  FACT_TYPE  VARCHAR2(20) NOT NULL,
  FACT_NAME  VARCHAR2(100) NOT NULL,
  DEF_FACT_VAL_ID  INTEGER NULL,
  FACT_DESCR  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_factor PRIMARY KEY (fact_id))
/

--METADATA NAME:FACTVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE FACTVAL(
  FACT_VAL_ID  INTEGER NOT NULL,
  FACT_ID  INTEGER NOT NULL,
  FACT_VALUE  VARCHAR2(24) NOT NULL,
  FACT_VALUE_DESCR  VARCHAR2(255) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_factval PRIMARY KEY (fact_val_id) ,CONSTRAINT fk_factval_factor FOREIGN KEY (fact_id)
REFERENCES FACTOR (fact_id) 
)
/

--METADATA NAME:FILTPROP TYPE:TABLE CHANGE:CREATE
CREATE TABLE FILTPROP(
  FILTER_ID  INTEGER NOT NULL,
  TABLE_NAME  VARCHAR2(16) NOT NULL,
  FILTER_TYPE  VARCHAR2(20) NOT NULL,
  FILTER_NAME  VARCHAR2(40) NOT NULL,
  USER_ID  INTEGER NULL,
  FILTER_DATA  BLOB NULL,
  RPT_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_filtprop PRIMARY KEY (filter_id) ,CONSTRAINT fk_filtprop_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
 ,CONSTRAINT fk_filtprop_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id) 
)
/

--METADATA NAME:FINDATES TYPE:TABLE CHANGE:CREATE
CREATE TABLE FINDATES(
  FIN_DATES_ID  INTEGER NOT NULL,
  FIN_DATES_NAME  VARCHAR2(60) NOT NULL,
  START_DATE  DATETIME NOT NULL,
  END_DATE  DATETIME NOT NULL,
  FINTMPL_ID  INTEGER DEFAULT 1 NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_findates PRIMARY KEY (fin_dates_id) ,CONSTRAINT fk_findates_fintmpl FOREIGN KEY (fintmpl_id)
REFERENCES FINTMPL (fintmpl_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:FINTMPL TYPE:TABLE CHANGE:CREATE
CREATE TABLE FINTMPL(
  FINTMPL_ID  INTEGER NOT NULL,
  FINTMPL_NAME  VARCHAR2(255) NOT NULL,
  DEFAULT_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) DEFAULT 'NotPrmUser' NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) DEFAULT 'NotPrmUser' NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_fintmpl PRIMARY KEY (fintmpl_id))
/

--METADATA NAME:FORMCATG TYPE:TABLE CHANGE:CREATE
CREATE TABLE FORMCATG(
  FORM_CATG_ID  INTEGER NOT NULL,
  FORM_CATG_NAME  VARCHAR2(255) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_formcatg PRIMARY KEY (form_catg_id))
/

--METADATA NAME:FORMPROJ TYPE:TABLE CHANGE:CREATE
CREATE TABLE FORMPROJ(
  FORM_TMPL_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_formproj PRIMARY KEY (form_tmpl_id,proj_id) ,CONSTRAINT fk_formproj_formtmpl FOREIGN KEY (form_tmpl_id)
REFERENCES FORMTMPL (form_tmpl_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_formproj_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:FORMTMPL TYPE:TABLE CHANGE:CREATE
CREATE TABLE FORMTMPL(
  FORM_TMPL_ID  INTEGER NOT NULL,
  FORM_TMPL_NAME  VARCHAR2(255) NOT NULL,
  FORM_TMPL_DESC  VARCHAR2(4000) NULL,
  FORM_CATG_ID  INTEGER NULL,
  FORM_TMPL_DATA  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_formtmpl PRIMARY KEY (form_tmpl_id) ,CONSTRAINT fk_formtmpl_formcatg FOREIGN KEY (form_catg_id)
REFERENCES FORMCATG (form_catg_id) 
)
/

--METADATA NAME:FUNDSRC TYPE:TABLE CHANGE:CREATE
CREATE TABLE FUNDSRC(
  FUND_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  FUND_NAME  VARCHAR2(100) NOT NULL,
  PARENT_FUND_ID  INTEGER NULL,
  FUND_DESCR  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_fundsrc PRIMARY KEY (fund_id))
/

--METADATA NAME:GCHANGE TYPE:TABLE CHANGE:CREATE
CREATE TABLE GCHANGE(
  GCHANGE_ID  INTEGER NOT NULL,
  GCHANGE_NAME  VARCHAR2(40) NOT NULL,
  GCHANGE_DATA  BLOB NULL,
  USER_ID  INTEGER NULL,
  TABLE_NAME  VARCHAR2(20) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_gchange_id PRIMARY KEY (gchange_id) ,CONSTRAINT fk_gchange_user FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:HQDATA TYPE:TABLE CHANGE:CREATE
CREATE TABLE HQDATA(
  SESSION_ID  INTEGER NOT NULL,
  CONTEXT_ID  INTEGER NOT NULL,
  FK_ID  INTEGER NOT NULL,
  VALUE  INTEGER NOT NULL
,CONSTRAINT pk_hqdata PRIMARY KEY (session_id,context_id,fk_id,value) ,CONSTRAINT fk_hqdata_usession FOREIGN KEY (session_id)
REFERENCES USESSION (session_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:HQUERY TYPE:TABLE CHANGE:CREATE
CREATE TABLE HQUERY(
  SESSION_ID  INTEGER NOT NULL,
  CONTEXT_ID  INTEGER NOT NULL,
  FK_ID  INTEGER NOT NULL,
  ORDER_VALUE  VARCHAR2(4000) NULL,
  ORDER_IDS  VARCHAR2(4000) NULL
,CONSTRAINT pk_hquery PRIMARY KEY (session_id,context_id,fk_id) ,CONSTRAINT fk_hquery_usession FOREIGN KEY (session_id)
REFERENCES USESSION (session_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:IMAGEDATA TYPE:TABLE CHANGE:CREATE
CREATE TABLE IMAGEDATA(
  IMAGE_ID  INTEGER NOT NULL,
  IMAGE_NAME  VARCHAR2(120) NULL,
  IMAGE_DATA  NO VALID DATA TYPE NOT NULL,
  IMAGE_THUMBNAIL  NO VALID DATA TYPE NOT NULL,
  IMAGE_EXTENSION  VARCHAR2(20) DEFAULT 'png' NOT NULL,
  DEFAULT_FLAG  VARCHAR2(1) NOT NULL,
  IMAGE_PURPOSE  VARCHAR2(50) NOT NULL,
  IMAGE_DESCRIPTION  VARCHAR2(250) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_imagedata PRIMARY KEY (image_id))
/

--METADATA NAME:ISSUHIST TYPE:TABLE CHANGE:CREATE
CREATE TABLE ISSUHIST(
  ISSUE_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  ISSUE_HISTORY  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_issuhist PRIMARY KEY (issue_id) ,CONSTRAINT fk_issuhist_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_issuhist_projissu FOREIGN KEY (issue_id)
REFERENCES PROJISSU (issue_id) 
)
/

--METADATA NAME:ITERATION TYPE:TABLE CHANGE:CREATE
CREATE TABLE ITERATION(
  ITERATION_ID  INTEGER NOT NULL,
  RELEASE_ID  INTEGER NOT NULL,
  ITERATION_NAME  VARCHAR2(50) NOT NULL,
  START_DATE  DATETIME NULL,
  END_DATE  DATETIME NULL,
  TERMINATION_DATE  DATETIME NULL,
  CAPACITY_PCT  REAL DEFAULT 0 NULL,
  REMAIN_QTY  REAL NULL,
  UPDATE_DATE  DATETIME DEFAULT sysdate NULL,
  UPDATE_USER  VARCHAR2(255) DEFAULT 'SYSTEM' NULL,
  CREATE_DATE  DATETIME DEFAULT sysdate NULL,
  CREATE_USER  VARCHAR2(255) DEFAULT 'SYSTEM' NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_iteration PRIMARY KEY (iteration_id) ,CONSTRAINT fk_iteration_release FOREIGN KEY (release_id)
REFERENCES RELEASE (release_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:ITERDAYS TYPE:TABLE CHANGE:CREATE
CREATE TABLE ITERDAYS(
  TASK_ID  INTEGER NOT NULL,
  DAY_NUMBER  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  ITERATION_ID  INTEGER NOT NULL,
  ACT_WORK_QTY  REAL NULL,
  REMAIN_WORK_QTY  REAL NULL,
  UPDATE_DATE  DATETIME DEFAULT sysdate NULL,
  UPDATE_USER  VARCHAR2(255) DEFAULT 'SYSTEM' NULL,
  CREATE_DATE  DATETIME DEFAULT sysdate NULL,
  CREATE_USER  VARCHAR2(255) DEFAULT 'SYSTEM' NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_iterdays PRIMARY KEY (task_id,day_number) ,CONSTRAINT fk_iterdays_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_iterdays_iteration FOREIGN KEY (iteration_id)
REFERENCES ITERATION (iteration_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_iterdays_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:ITERGOAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE ITERGOAL(
  ITER_GOAL_ID  INTEGER NOT NULL,
  ITERATION_ID  INTEGER NOT NULL,
  GOAL_NAME  VARCHAR2(255) NOT NULL,
  GOAL_DESCR  VARCHAR2(4000) NOT NULL,
  STATUS_CODE  VARCHAR2(12) DEFAULT 'IG_NotStart' NOT NULL,
  RFOLIO_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_itergoal PRIMARY KEY (iter_goal_id) ,CONSTRAINT fk_itergoal_iteration FOREIGN KEY (iteration_id)
REFERENCES ITERATION (iteration_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_itergoal_rfolio FOREIGN KEY (rfolio_id)
REFERENCES RFOLIO (rfolio_id) 
)
/

--METADATA NAME:JOBLOG TYPE:TABLE CHANGE:CREATE
CREATE TABLE JOBLOG(
  JOB_ID  INTEGER NOT NULL,
  JOB_LOG_DATA  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_joblog PRIMARY KEY (job_id) ,CONSTRAINT fk_joblog_jobsvc FOREIGN KEY (job_id)
REFERENCES JOBSVC (job_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:JOBRPT TYPE:TABLE CHANGE:CREATE
CREATE TABLE JOBRPT(
  JOB_ID  INTEGER NOT NULL,
  RPT_ID  INTEGER NOT NULL,
  TABLE_NAME  VARCHAR2(20) NULL,
  FK_ID  INTEGER NULL,
  JOBRPT_DATA  BLOB NULL,
  PERSONAL_PORTAL_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_jobrpt PRIMARY KEY (job_id,rpt_id) ,CONSTRAINT fk_jobrpt_jobsvc FOREIGN KEY (job_id)
REFERENCES JOBSVC (job_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_jobrpt_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:JOBSVC TYPE:TABLE CHANGE:CREATE
CREATE TABLE JOBSVC(
  JOB_ID  INTEGER NOT NULL,
  PARENT_JOB_ID  INTEGER NULL,
  SEQ_NUM  INTEGER NOT NULL,
  AUDIT_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  JOB_TYPE  VARCHAR2(20) NOT NULL,
  JOB_NAME  VARCHAR2(255) NOT NULL,
  USER_ID  INTEGER NOT NULL,
  LAST_RUN_DATE  DATETIME NULL,
  STATUS_CODE  VARCHAR2(20) NOT NULL,
  RECUR_DATA  VARCHAR2(255) NULL,
  RECUR_TYPE  VARCHAR2(20) NULL,
  SUBMITTED_DATE  DATETIME NULL,
  LAST_ERROR_DESCR  VARCHAR2(255) NULL,
  AUDIT_FILE_PATH  VARCHAR2(255) NULL,
  JOB_DATA  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_jobsvc PRIMARY KEY (job_id) ,CONSTRAINT fk_jobsvc_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:LOCATION TYPE:TABLE CHANGE:CREATE
CREATE TABLE LOCATION(
  LOCATION_ID  INTEGER NOT NULL,
  LOCATION_NAME  VARCHAR2(255) NOT NULL,
  LOCATION_TYPE  VARCHAR2(24) NULL,
  ADDRESS_LINE1  VARCHAR2(200) NULL,
  ADDRESS_LINE2  VARCHAR2(200) NULL,
  ADDRESS_LINE3  VARCHAR2(200) NULL,
  CITY_NAME  VARCHAR2(200) NULL,
  MUNICIPALITY_NAME  VARCHAR2(200) NULL,
  STATE_NAME  VARCHAR2(200) NULL,
  STATE_CODE  VARCHAR2(2) NULL,
  COUNTRY_NAME  VARCHAR2(200) NULL,
  COUNTRY_CODE  VARCHAR2(3) NULL,
  POSTAL_CODE  VARCHAR2(20) NULL,
  LONGITUDE  REAL NULL,
  LATITUDE  REAL NULL,
  GEO_LOCATION  SDO_GEOMETRY NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_location PRIMARY KEY (location_id))
/

--METADATA NAME:MEMOTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE MEMOTYPE(
  MEMO_TYPE_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  EPS_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  PROJ_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  WBS_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  TASK_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  MEMO_TYPE  VARCHAR2(40) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_memotype PRIMARY KEY (memo_type_id))
/

--METADATA NAME:NEXTKEY TYPE:TABLE CHANGE:CREATE
CREATE TABLE NEXTKEY(
  KEY_NAME  VARCHAR2(60) NOT NULL,
  KEY_SEQ_NUM  INTEGER NOT NULL
,CONSTRAINT pk_nextkey PRIMARY KEY (key_name))
/

--METADATA NAME:NONWORK TYPE:TABLE CHANGE:CREATE
CREATE TABLE NONWORK(
  NONWORK_TYPE_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  NONWORK_CODE  VARCHAR2(32) NOT NULL,
  NONWORK_TYPE  VARCHAR2(40) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_nonwork PRIMARY KEY (nonwork_type_id))
/

--METADATA NAME:NOTE TYPE:TABLE CHANGE:CREATE
CREATE TABLE NOTE(
  NOTE_ID  INTEGER NOT NULL,
  TABLE_NAME  VARCHAR2(30) NOT NULL,
  TYPE_NAME  VARCHAR2(30) NOT NULL,
  FK_ID  INTEGER NOT NULL,
  NOTE_DATE  DATETIME NOT NULL,
  NOTE_VALUE  VARCHAR2(4000) NULL,
  USER_NAME  VARCHAR2(255) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_note PRIMARY KEY (note_id))
/

--METADATA NAME:OBS TYPE:TABLE CHANGE:CREATE
CREATE TABLE OBS(
  OBS_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  OBS_NAME  VARCHAR2(100) NOT NULL,
  PARENT_OBS_ID  INTEGER NULL,
  GUID  VARCHAR2(22) NULL,
  OBS_DESCR  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_obs PRIMARY KEY (obs_id))
/

--METADATA NAME:OBSPROJ TYPE:TABLE CHANGE:CREATE
CREATE TABLE OBSPROJ(
  OBS_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  WBS_ID  INTEGER NOT NULL
,CONSTRAINT pk_obsproj PRIMARY KEY (obs_id,proj_id,wbs_id) ,CONSTRAINT fk_obsproj_obs FOREIGN KEY (obs_id)
REFERENCES OBS (obs_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_obsproj_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:PCATTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE PCATTYPE(
  PROJ_CATG_TYPE_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  PROJ_CATG_SHORT_LEN  INTEGER NOT NULL,
  PROJ_CATG_TYPE  VARCHAR2(60) NOT NULL,
  SUPER_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  PROJ_CATG_TYPE_WT  REAL DEFAULT 0 NULL,
  MAX_PROJ_CATG_WT  REAL DEFAULT 0 NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_pcattype PRIMARY KEY (proj_catg_type_id))
/

--METADATA NAME:PCATUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE PCATUSER(
  PROJ_CATG_ID  INTEGER NOT NULL,
  USER_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_pcatuser PRIMARY KEY (proj_catg_id,user_id) ,CONSTRAINT fk_pcatuser_user FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
 ,CONSTRAINT fk_pcatuser_pcatval FOREIGN KEY (proj_catg_id)
REFERENCES PCATVAL (proj_catg_id) 
)
/

--METADATA NAME:PCATVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE PCATVAL(
  PROJ_CATG_ID  INTEGER NOT NULL,
  PROJ_CATG_TYPE_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  PROJ_CATG_SHORT_NAME  VARCHAR2(60) NOT NULL,
  PARENT_PROJ_CATG_ID  INTEGER NULL,
  PROJ_CATG_NAME  VARCHAR2(100) NULL,
  PROJ_CATG_WT  REAL DEFAULT 0 NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_pcatval PRIMARY KEY (proj_catg_id) ,CONSTRAINT fk_pcatval_pcattype FOREIGN KEY (proj_catg_type_id)
REFERENCES PCATTYPE (proj_catg_type_id) 
)
/

--METADATA NAME:PFOLIO TYPE:TABLE CHANGE:CREATE
CREATE TABLE PFOLIO(
  PFOLIO_ID  INTEGER NOT NULL,
  CLOSED_PROJ_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  WHATIF_PROJ_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  PFOLIO_TYPE  VARCHAR2(20) NOT NULL,
  PFOLIO_NAME  VARCHAR2(40) NOT NULL,
  USER_ID  INTEGER NULL,
  PFOLIO_DESCR  VARCHAR2(255) NULL,
  LAST_REFRESH_DATE  DATETIME NULL,
  PFOLIO_DATA  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_pfolio PRIMARY KEY (pfolio_id) ,CONSTRAINT fk_pfolio_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:PFOLIOUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE PFOLIOUSER(
  PFOLIO_ID  INTEGER NOT NULL,
  USER_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_pfoliouser PRIMARY KEY (pfolio_id,user_id) ,CONSTRAINT fk_pfoliouser_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
 ,CONSTRAINT fk_pfoliouser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:PHASE TYPE:TABLE CHANGE:CREATE
CREATE TABLE PHASE(
  PHASE_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  PHASE_NAME  VARCHAR2(100) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_phase PRIMARY KEY (phase_id))
/

--METADATA NAME:PKXREF TYPE:TABLE CHANGE:CREATE
CREATE TABLE PKXREF(
  SYSTEM_ID  INTEGER NULL,
  CONTEXT_NAME  VARCHAR2(30) NULL,
  PK1  INTEGER NULL,
  PK2  INTEGER NULL,
  OLD_PK1  INTEGER NULL,
  OLD_PK2  INTEGER NULL,
  OLD_STR  VARCHAR2(40) NULL,
  NEW_STR  VARCHAR2(40) NULL,
  ADD_DATE  DATETIME DEFAULT sysdate NULL
)
/

--METADATA NAME:POBS TYPE:TABLE CHANGE:CREATE
CREATE TABLE POBS(
  POBS_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  POBS_NAME  VARCHAR2(255) NOT NULL,
  POBS_PARENT_ID  INTEGER NULL,
  POBS_DESCR  VARCHAR2(255) NULL,
  POBS_MANAGER  VARCHAR2(255) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_pobs PRIMARY KEY (pobs_id))
/

--METADATA NAME:PREFER TYPE:TABLE CHANGE:CREATE
CREATE TABLE PREFER(
  PREFER_ID  INTEGER NOT NULL,
  HR_DECIMAL_CNT  INTEGER NOT NULL,
  XFER_COMPLETE_DAY_CNT  INTEGER NOT NULL,
  XFER_NOTSTART_DAY_CNT  INTEGER NOT NULL,
  MAX_WBS_LEVEL_CNT  INTEGER NOT NULL,
  MAX_RSRC_LEVEL_CNT  INTEGER NOT NULL,
  MAX_ACCT_LEVEL_CNT  INTEGER NOT NULL,
  MAX_TASK_ACTV_TYPE_CNT  INTEGER NOT NULL,
  FUTURE_TS_CNT  INTEGER NOT NULL,
  MAX_OBS_LEVEL_CNT  INTEGER NOT NULL,
  WEEK_START_DAY_NUM  INTEGER NOT NULL,
  TS_APPROVAL_LEVEL  INTEGER NOT NULL,
  TASK_CODE_LEN  INTEGER NOT NULL,
  PROJ_SHORT_LEN  INTEGER NOT NULL,
  WBS_SHORT_LEN  INTEGER NOT NULL,
  RSRC_SHORT_LEN  INTEGER NOT NULL,
  ACCT_SHORT_LEN  INTEGER NOT NULL,
  ROLE_SHORT_LEN  INTEGER NOT NULL,
  MAX_BASE_CNT  INTEGER NOT NULL,
  DEF_TARGET_DRTN_HR_CNT  REAL NOT NULL,
  DAY_HR_CNT  REAL NOT NULL,
  WEEK_HR_CNT  REAL NOT NULL,
  YEAR_HR_CNT  REAL NOT NULL,
  MONTH_HR_CNT  REAL NOT NULL,
  MAX_ACTV_LEVEL_CNT  INTEGER NOT NULL,
  MAX_EPS_LEVEL_CNT  INTEGER NOT NULL,
  MAX_PCAT_LEVEL_CNT  INTEGER NOT NULL,
  MAX_RCAT_LEVEL_CNT  INTEGER NOT NULL,
  COMPLETE_TASK_HRS_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  DEFAULT_TIMESHEET_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  FUTURE_TS_HRS_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  EV_FIX_COST_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  TS_DAILY_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  NOTSTART_TASK_HRS_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  PRESTART_TASK_HRS_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  POSTEND_TASK_HRS_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  ERMM_ENABLED_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  NAME_SEP_CHAR  VARCHAR2(2) NOT NULL,
  YEAR_CHAR  VARCHAR2(4) NOT NULL,
  MONTH_CHAR  VARCHAR2(4) NOT NULL,
  WEEK_CHAR  VARCHAR2(4) NOT NULL,
  DAY_CHAR  VARCHAR2(4) NOT NULL,
  HOUR_CHAR  VARCHAR2(4) NOT NULL,
  MINUTE_CHAR  VARCHAR2(4) NOT NULL,
  TS_APPROVAL_TYPE  VARCHAR2(20) DEFAULT 'AT_PM_RM' NOT NULL,
  DB_NAME  VARCHAR2(20) NOT NULL,
  TASKSUM_PERIOD_TYPE  VARCHAR2(20) NOT NULL,
  TRSRCSUM_PERIOD_TYPE  VARCHAR2(20) NOT NULL,
  DATABASE_VERSION  VARCHAR2(30) NOT NULL,
  MIN_PRO_VERSION  VARCHAR2(10) NULL,
  PHASE_LABEL  VARCHAR2(40) NOT NULL,
  TS_APPROVE_USER_ID  INTEGER NULL,
  CURR_ID  INTEGER DEFAULT 1 NOT NULL,
  EV_USER_PCT  INTEGER NULL,
  EV_ETC_USER_VALUE  REAL NULL,
  EV_COMPUTE_TYPE  VARCHAR2(20) NULL,
  EV_ETC_COMPUTE_TYPE  VARCHAR2(20) NULL,
  RPT_HEADER_1  VARCHAR2(255) NULL,
  RPT_HEADER_2  VARCHAR2(255) NULL,
  RPT_HEADER_3  VARCHAR2(255) NULL,
  RPT_FOOTER_1  VARCHAR2(255) NULL,
  RPT_FOOTER_2  VARCHAR2(255) NULL,
  RPT_FOOTER_3  VARCHAR2(255) NULL,
  RPT_USER_1  VARCHAR2(255) NULL,
  RPT_USER_2  VARCHAR2(255) NULL,
  RPT_USER_3  VARCHAR2(255) NULL,
  LICENSE_DATA  BLOB NULL,
  MAX_ROLE_LEVEL_CNT  INTEGER NOT NULL,
  PAST_TS_CNT  INTEGER DEFAULT 4 NOT NULL,
  PROJINIT_ADMIN_USER_ID  INTEGER NOT NULL,
  DEFAULT_RSRC_SEC_ID  INTEGER NULL,
  ALLOW_USER_TIME_PERIOD_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  EXP_ROOT_URL  VARCHAR2(255) NULL,
  TS_RSRC_DEF_ASGN_ACTV_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  TS_RSRC_DEF_ASGN_OUT_ACTV_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_prefer PRIMARY KEY (prefer_id) ,CONSTRAINT fk_prefer_currtype FOREIGN KEY (curr_id)
REFERENCES CURRTYPE (curr_id) 
 ,CONSTRAINT fk_prefer_users FOREIGN KEY (ts_approve_user_id)
REFERENCES USERS (user_id) 
 ,CONSTRAINT fk_prefer_rsrc FOREIGN KEY (default_rsrc_sec_id)
REFERENCES RSRC (rsrc_id) 
)
/

--METADATA NAME:PRMAUDIT TYPE:TABLE CHANGE:CREATE
CREATE TABLE PRMAUDIT(
  AUDIT_DATE  DATETIME NULL,
  TABLE_NAME  VARCHAR2(30) NULL,
  PK1  VARCHAR2(255) NULL,
  PK2  VARCHAR2(255) NULL,
  PK3  VARCHAR2(255) NULL,
  PK4  VARCHAR2(255) NULL,
  OPER  VARCHAR2(1) NULL,
  PRM_USER_NAME  VARCHAR2(255) NULL,
  AUDIT_INFO  VARCHAR2(4000) NULL,
  AUDIT_INFO_EXTENDED  BLOB NULL,
  LOGICAL_DELETE_FLAG  VARCHAR2(1) NULL,
  RDBMS_USER_NAME  VARCHAR2(255) NULL,
  OS_USER_NAME  VARCHAR2(255) NULL,
  PROGRAM  VARCHAR2(255) NULL,
  HOST_NAME  VARCHAR2(255) NULL,
  APP_NAME  VARCHAR2(25) NULL,
  NETADDRESS  VARCHAR2(64) NULL
)
/

--METADATA NAME:PRMQUEUE TYPE:TABLE CHANGE:CREATE
CREATE TABLE PRMQUEUE(
  QUEUE_NAME  VARCHAR2(30) NOT NULL,
  MSG_KEY  VARCHAR2(32) NOT NULL,
  ENQUEUE_DATE  DATETIME NOT NULL,
  ENQUEUE_USER  VARCHAR2(255) NULL,
  STATUS_CODE  VARCHAR2(10) NULL,
  PRIORITY  INTEGER NULL,
  SENDER_NAME  VARCHAR2(255) NULL,
  DEQUEUE_DATE  DATETIME NULL,
  DEQUEUE_USER  VARCHAR2(255) NULL,
  RETRY_COUNT  INTEGER NULL,
  MSG_TYPE  VARCHAR2(255) NULL,
  MSG_SUB_TYPE  VARCHAR2(255) NULL,
  KEY1  VARCHAR2(255) NULL,
  KEY2  VARCHAR2(255) NULL,
  ERR_MSG  VARCHAR2(4000) NULL,
  QUEUE_PAYLOAD  VARCHAR2(4000) NULL,
  QUEUE_PAYLOAD_EXTENDED  BLOB NULL
,CONSTRAINT pk_prmqueue PRIMARY KEY (queue_name,msg_key,enqueue_date))
/

--METADATA NAME:PROCGROUP TYPE:TABLE CHANGE:CREATE
CREATE TABLE PROCGROUP(
  PROC_GROUP_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  PROC_GROUP_NAME  VARCHAR2(120) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_procgroup PRIMARY KEY (proc_group_id))
/

--METADATA NAME:PROCITEM TYPE:TABLE CHANGE:CREATE
CREATE TABLE PROCITEM(
  PROC_ITEM_ID  INTEGER NOT NULL,
  PROC_GROUP_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  PROC_NAME  VARCHAR2(120) NOT NULL,
  PROC_WT  REAL NULL,
  PROC_DESCR  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_procitem PRIMARY KEY (proc_item_id) ,CONSTRAINT fk_procitem_procgroup FOREIGN KEY (proc_group_id)
REFERENCES PROCGROUP (proc_group_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:PROFILE TYPE:TABLE CHANGE:CREATE
CREATE TABLE PROFILE(
  PROF_ID  INTEGER NOT NULL,
  DEFAULT_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  SUPERUSER_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  SCOPE_TYPE  VARCHAR2(12) NOT NULL,
  PROF_NAME  VARCHAR2(100) NOT NULL,
  PROF_DESCR  VARCHAR2(255) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_profile PRIMARY KEY (prof_id))
/

--METADATA NAME:PROFPRIV TYPE:TABLE CHANGE:CREATE
CREATE TABLE PROFPRIV(
  PROF_ID  INTEGER NOT NULL,
  PRIV_NUM  INTEGER NOT NULL,
  ALLOW_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_profpriv PRIMARY KEY (prof_id,priv_num) ,CONSTRAINT fk_profpriv_profile FOREIGN KEY (prof_id)
REFERENCES PROFILE (prof_id) 
)
/

--METADATA NAME:PROJCOST TYPE:TABLE CHANGE:CREATE
CREATE TABLE PROJCOST(
  COST_ITEM_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  TASK_ID  INTEGER NOT NULL,
  AUTO_COMPUTE_ACT_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  COST_LOAD_TYPE  VARCHAR2(12) NOT NULL,
  ACCT_ID  INTEGER NULL,
  COST_TYPE_ID  INTEGER NULL,
  TARGET_COST  REAL NULL,
  ACT_COST  REAL NULL,
  REMAIN_COST  REAL NULL,
  QTY_NAME  VARCHAR2(30) NULL,
  TARGET_QTY  REAL NOT NULL,
  COST_PER_QTY  REAL NOT NULL,
  PO_NUMBER  VARCHAR2(32) NULL,
  VENDOR_NAME  VARCHAR2(100) NULL,
  COST_NAME  VARCHAR2(120) NULL,
  COST_DESCR  BLOB NULL,
  POBS_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_projcost PRIMARY KEY (cost_item_id) ,CONSTRAINT fk_projcost_account FOREIGN KEY (acct_id)
REFERENCES ACCOUNT (acct_id) 
 ,CONSTRAINT fk_projcost_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_projcost_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ,CONSTRAINT fk_projcost_costtype FOREIGN KEY (cost_type_id)
REFERENCES COSTTYPE (cost_type_id) 
 ,CONSTRAINT fk_projcost_pobs FOREIGN KEY (pobs_id)
REFERENCES POBS (pobs_id) 
)
/

--METADATA NAME:PROJECT TYPE:TABLE CHANGE:CREATE
CREATE TABLE PROJECT(
  PROJ_ID  INTEGER NOT NULL,
  FY_START_MONTH_NUM  INTEGER NOT NULL,
  CHNG_EFF_CMP_PCT_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  RSRC_SELF_ADD_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  RSRC_ROLE_MATCH_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  ALLOW_COMPLETE_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  RSRC_MULTI_ASSIGN_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  CHECKOUT_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  PROJECT_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  STEP_COMPLETE_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  COST_QTY_RECALC_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  SUM_ONLY_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  BATCH_SUM_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  NAME_SEP_CHAR  VARCHAR2(2) NOT NULL,
  DEF_COMPLETE_PCT_TYPE  VARCHAR2(10) DEFAULT 'CP_Drtn' NOT NULL,
  PROJ_SHORT_NAME  VARCHAR2(40) NOT NULL,
  ACCT_ID  INTEGER NULL,
  ORIG_PROJ_ID  INTEGER NULL,
  SOURCE_PROJ_ID  INTEGER NULL,
  BASE_TYPE_ID  INTEGER NULL,
  CLNDR_ID  INTEGER NULL,
  SUM_BASE_PROJ_ID  INTEGER NULL,
  TASK_CODE_BASE  INTEGER NULL,
  TASK_CODE_STEP  INTEGER NULL,
  PRIORITY_NUM  INTEGER NULL,
  WBS_MAX_SUM_LEVEL  INTEGER NULL,
  RISK_LEVEL  INTEGER NULL,
  STRGY_PRIORITY_NUM  INTEGER NULL,
  LAST_CHECKSUM  INTEGER NULL,
  CRITICAL_DRTN_HR_CNT  REAL NULL,
  DEF_COST_PER_QTY  REAL NULL,
  LAST_RECALC_DATE  DATETIME NULL,
  PLAN_START_DATE  DATETIME NULL,
  PLAN_END_DATE  DATETIME NULL,
  SCD_END_DATE  DATETIME NULL,
  ADD_DATE  DATETIME DEFAULT sysdate NOT NULL,
  SUM_DATA_DATE  DATETIME NULL,
  LAST_TASKSUM_DATE  DATETIME NULL,
  FCST_START_DATE  DATETIME NULL,
  DEF_DURATION_TYPE  VARCHAR2(12) NULL,
  TASK_CODE_PREFIX  VARCHAR2(20) NULL,
  GUID  VARCHAR2(22) NULL,
  DEF_QTY_TYPE  VARCHAR2(24) NULL,
  ADD_BY_NAME  VARCHAR2(255) NULL,
  WEB_LOCAL_ROOT_PATH  VARCHAR2(120) NULL,
  PROJ_URL  VARCHAR2(200) NULL,
  DEF_RATE_TYPE  VARCHAR2(14) NULL,
  ACT_THIS_PER_LINK_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  DEF_TASK_TYPE  VARCHAR2(12) DEFAULT 'TT_Task' NOT NULL,
  ACT_PCT_LINK_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  ADD_ACT_REMAIN_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  CRITICAL_PATH_TYPE  VARCHAR2(12) DEFAULT 'CT_TotFloat' NOT NULL,
  TASK_CODE_PREFIX_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  DEF_ROLLUP_DATES_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  REM_TARGET_LINK_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  RESET_PLANNED_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  ALLOW_NEG_ACT_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  RSRC_ID  INTEGER NULL,
  MSP_MANAGED_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  MSP_UPDATE_ACTUALS_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  CHECKOUT_DATE  DATETIME NULL,
  CHECKOUT_USER_ID  INTEGER NULL,
  SUM_ASSIGN_LEVEL  VARCHAR2(12) DEFAULT 'SL_Taskrsrc' NULL,
  LAST_FIN_DATES_ID  INTEGER NULL,
  USE_PROJECT_BASELINE_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  LAST_BASELINE_UPDATE_DATE  DATETIME NULL,
  TS_RSRC_VW_COMPL_ASGN_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  TS_RSRC_MARK_ACT_FINISH_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  TS_RSRC_VW_INACT_ACTV_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  CR_EXTERNAL_KEY  VARCHAR2(4000) NULL,
  APPLY_ACTUALS_DATE  DATETIME NULL,
  DESCRIPTION  VARCHAR2(500) NULL,
  INTG_PROJ_TYPE  VARCHAR2(7) NULL,
  MATRIX_ID  INTEGER NULL,
  LOCATION_ID  INTEGER NULL,
  LAST_SCHEDULE_DATE  DATETIME NULL,
  CONTROL_UPDATES_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  HIST_INTERVAL  VARCHAR2(25) DEFAULT 'Month' NOT NULL,
  HIST_LEVEL  VARCHAR2(10) DEFAULT 'HL_None' NOT NULL,
  FINTMPL_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_project PRIMARY KEY (proj_id) ,CONSTRAINT fk_project_account FOREIGN KEY (acct_id)
REFERENCES ACCOUNT (acct_id) 
 ,CONSTRAINT fk_project_basetype FOREIGN KEY (base_type_id)
REFERENCES BASETYPE (base_type_id) 
 ,CONSTRAINT fk_project_findates FOREIGN KEY (last_fin_dates_id)
REFERENCES FINDATES (fin_dates_id) 
 ,CONSTRAINT fk_project_users FOREIGN KEY (checkout_user_id)
REFERENCES USERS (user_id) 
 ,CONSTRAINT fk_project_fintmpl FOREIGN KEY (fintmpl_id)
REFERENCES FINTMPL (fintmpl_id) 
)
/

--METADATA NAME:PROJEST TYPE:TABLE CHANGE:CREATE
CREATE TABLE PROJEST(
  PROJ_EST_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  WBS_ID  INTEGER NOT NULL,
  APPLIED_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  RSRC_TYPE  VARCHAR2(10) DEFAULT 'RT_Labor' NOT NULL,
  EST_TYPE  VARCHAR2(20) NOT NULL,
  EST_NAME  VARCHAR2(120) NOT NULL,
  RSRC_ID  INTEGER NULL,
  BU_CMPLX_VALUE  INTEGER NULL,
  ADJ_MULT_PCT  INTEGER NULL,
  FP_CNT  INTEGER NULL,
  FP_CMPLX_VALUE  INTEGER NULL,
  FP_UNADJ_CNT  INTEGER NULL,
  EST_TASK_CNT  INTEGER NULL,
  FP_PROD_AVG_VALUE  REAL NULL,
  EST_QTY  REAL NULL,
  EST_DATE  DATETIME NULL,
  EST_NOTES  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_projest PRIMARY KEY (proj_est_id) ,CONSTRAINT fk_projest_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_projest_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
 ,CONSTRAINT fk_projest_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
)
/

--METADATA NAME:PROJFUND TYPE:TABLE CHANGE:CREATE
CREATE TABLE PROJFUND(
  PROJ_FUND_ID  INTEGER NOT NULL,
  FUND_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  FUND_COST  REAL NULL,
  FUND_WT  REAL NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_projfund PRIMARY KEY (proj_fund_id) ,CONSTRAINT fk_projfund_fundsrc FOREIGN KEY (fund_id)
REFERENCES FUNDSRC (fund_id) 
 ,CONSTRAINT fk_projfund_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
)
/

--METADATA NAME:PROJISSU TYPE:TABLE CHANGE:CREATE
CREATE TABLE PROJISSU(
  ISSUE_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  OBS_ID  INTEGER NOT NULL,
  PRIORITY_TYPE  VARCHAR2(12) NOT NULL,
  STATUS_CODE  VARCHAR2(12) NOT NULL,
  ISSUE_NAME  VARCHAR2(100) NOT NULL,
  THRESH_ID  INTEGER NULL,
  TRACK_VIEW_ID  INTEGER NULL,
  WBS_ID  INTEGER NULL,
  TASK_ID  INTEGER NULL,
  RSRC_ID  INTEGER NULL,
  THRESH_PARM_ID  INTEGER NULL,
  BASE_PROJ_ID  INTEGER NULL,
  WORKSPACE_ID  INTEGER NULL,
  ISSUE_VALUE  REAL NULL,
  LO_PARM_VALUE  REAL NULL,
  HI_PARM_VALUE  REAL NULL,
  ADD_BY_NAME  VARCHAR2(255) NULL,
  RESOLV_DATE  DATETIME NULL,
  ADD_DATE  DATETIME NULL,
  ISSUE_NOTES  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_projissu PRIMARY KEY (issue_id) ,CONSTRAINT fk_projissu_obs FOREIGN KEY (obs_id)
REFERENCES OBS (obs_id) 
 ,CONSTRAINT fk_projissu_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_projissu_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
 ,CONSTRAINT fk_projissu_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ,CONSTRAINT fk_projissu_trakview FOREIGN KEY (track_view_id)
REFERENCES TRAKVIEW (track_view_id) 
 ,CONSTRAINT fk_projissu_thrsparm FOREIGN KEY (thresh_parm_id)
REFERENCES THRSPARM (thresh_parm_id) 
 ,CONSTRAINT fk_projissu_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
 ,CONSTRAINT fk_projissu_projthrs FOREIGN KEY (thresh_id)
REFERENCES PROJTHRS (thresh_id) 
 ,CONSTRAINT fk_projissu_workspace FOREIGN KEY (workspace_id)
REFERENCES WORKSPACE (workspace_id) 
)
/

--METADATA NAME:PROJPCAT TYPE:TABLE CHANGE:CREATE
CREATE TABLE PROJPCAT(
  PROJ_ID  INTEGER NOT NULL,
  PROJ_CATG_TYPE_ID  INTEGER NOT NULL,
  PROJ_CATG_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_projpcat PRIMARY KEY (proj_id,proj_catg_type_id) ,CONSTRAINT fk_projpcat_pcattype FOREIGN KEY (proj_catg_type_id)
REFERENCES PCATTYPE (proj_catg_type_id) 
 ,CONSTRAINT fk_projpcat_pcatval FOREIGN KEY (proj_catg_id)
REFERENCES PCATVAL (proj_catg_id) 
 ,CONSTRAINT fk_projpcat_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
)
/

--METADATA NAME:PROJPROP TYPE:TABLE CHANGE:CREATE
CREATE TABLE PROJPROP(
  PROJ_ID  INTEGER NOT NULL,
  PROP_NAME  VARCHAR2(32) NOT NULL,
  PROP_VALUE  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_projprop PRIMARY KEY (proj_id,prop_name) ,CONSTRAINT fk_projprop_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
)
/

--METADATA NAME:PROJRISK TYPE:TABLE CHANGE:CREATE
CREATE TABLE PROJRISK(
  RISK_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  ADD_DATE  DATETIME NULL,
  STATUS_CODE  VARCHAR2(12) NOT NULL,
  RISK_NAME  VARCHAR2(200) NOT NULL,
  RISK_TYPE_ID  INTEGER NULL,
  RSRC_ID  INTEGER NULL,
  RISK_DESCR  BLOB NULL,
  RISK_TO_TYPE  VARCHAR2(12) DEFAULT 'RT_Threat' NOT NULL,
  IDENTIFIED_BY_ID  INTEGER NULL,
  RESPONSE_TYPE  VARCHAR2(12) NULL,
  RESPONSE_TEXT  VARCHAR2(255) NULL,
  PRE_RSP_PRBLTY  VARCHAR2(2) NULL,
  PRE_RSP_SCHD_PRBLTY  VARCHAR2(2) NULL,
  PRE_RSP_COST_PRBLTY  VARCHAR2(2) NULL,
  POST_RSP_PRBLTY  VARCHAR2(2) NULL,
  POST_RSP_SCHD_PRBLTY  VARCHAR2(2) NULL,
  POST_RSP_COST_PRBLTY  VARCHAR2(2) NULL,
  RISK_CAUSE  VARCHAR2(4000) NULL,
  RISK_EFFECT  VARCHAR2(4000) NULL,
  NOTES  VARCHAR2(4000) NULL,
  RISK_CODE  VARCHAR2(40) DEFAULT 0 NOT NULL,
  RISK_DESC  VARCHAR2(4000) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_projrisk PRIMARY KEY (risk_id))
/

--METADATA NAME:PROJSHAR TYPE:TABLE CHANGE:CREATE
CREATE TABLE PROJSHAR(
  PROJ_ID  INTEGER NOT NULL,
  SESSION_ID  INTEGER NOT NULL,
  ACCESS_LEVEL  INTEGER NOT NULL,
  LOAD_STATUS  CHAR(1) DEFAULT 'L' NOT NULL
,CONSTRAINT pk_projshar PRIMARY KEY (proj_id,session_id) ,CONSTRAINT fk_projshar_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_projshar_usession FOREIGN KEY (session_id)
REFERENCES USESSION (session_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:PROJTHRS TYPE:TABLE CHANGE:CREATE
CREATE TABLE PROJTHRS(
  THRESH_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  OBS_ID  INTEGER NOT NULL,
  THRESH_PARM_ID  INTEGER NOT NULL,
  STATUS_CODE  VARCHAR2(12) NOT NULL,
  PRIORITY_TYPE  VARCHAR2(12) DEFAULT 'PT_Normal' NOT NULL,
  THRESH_TYPE  VARCHAR2(12) DEFAULT 'TM_WBS' NOT NULL,
  WBS_ID  INTEGER NULL,
  TRACK_VIEW_ID  INTEGER NULL,
  LO_PARM_VALUE  REAL NULL,
  HI_PARM_VALUE  REAL NULL,
  WINDOW_START  VARCHAR2(50) NULL,
  WINDOW_END  VARCHAR2(50) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_projthrs PRIMARY KEY (thresh_id) ,CONSTRAINT fk_projthrs_obs FOREIGN KEY (obs_id)
REFERENCES OBS (obs_id) 
 ,CONSTRAINT fk_projthrs_trakview FOREIGN KEY (track_view_id)
REFERENCES TRAKVIEW (track_view_id) 
 ,CONSTRAINT fk_projthrs_thrsparm FOREIGN KEY (thresh_parm_id)
REFERENCES THRSPARM (thresh_parm_id) 
 ,CONSTRAINT fk_projthrs_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_projthrs_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
)
/

--METADATA NAME:PROJWBS TYPE:TABLE CHANGE:CREATE
CREATE TABLE PROJWBS(
  WBS_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  OBS_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  EST_WT  REAL NULL,
  PROJ_NODE_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  SUM_DATA_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  STATUS_CODE  VARCHAR2(20) NOT NULL,
  WBS_SHORT_NAME  VARCHAR2(40) NOT NULL,
  WBS_NAME  VARCHAR2(100) NOT NULL,
  PHASE_ID  INTEGER NULL,
  PARENT_WBS_ID  INTEGER NULL,
  EV_USER_PCT  INTEGER NULL,
  EV_ETC_USER_VALUE  REAL NULL,
  ORIG_COST  REAL NULL,
  INDEP_REMAIN_TOTAL_COST  REAL NULL,
  ANN_DSCNT_RATE_PCT  REAL NULL,
  DSCNT_PERIOD_TYPE  VARCHAR2(20) NULL,
  INDEP_REMAIN_WORK_QTY  REAL NULL,
  ANTICIP_START_DATE  DATETIME NULL,
  ANTICIP_END_DATE  DATETIME NULL,
  EV_COMPUTE_TYPE  VARCHAR2(20) NULL,
  EV_ETC_COMPUTE_TYPE  VARCHAR2(20) NULL,
  RESP_TEAM_ID  INTEGER NULL,
  ITERATION_ID  INTEGER NULL,
  GUID  VARCHAR2(22) NULL,
  TMPL_GUID  VARCHAR2(22) NULL,
  ORIGINAL_QTY  REAL NULL,
  RQMT_REM_QTY  REAL NULL,
  INTG_TYPE  VARCHAR2(100) NULL,
  STATUS_REVIEWER  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_projwbs PRIMARY KEY (wbs_id) ,CONSTRAINT fk_projwbs_obs FOREIGN KEY (obs_id)
REFERENCES OBS (obs_id) 
 ,CONSTRAINT fk_projwbs_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_projwbs_phase FOREIGN KEY (phase_id)
REFERENCES PHASE (phase_id) 
 ,CONSTRAINT fk_projwbs_rfolio_team FOREIGN KEY (resp_team_id)
REFERENCES RFOLIO (rfolio_id) 
 ,CONSTRAINT fk_projwbs_iteration FOREIGN KEY (iteration_id)
REFERENCES ITERATION (iteration_id) 
)
/

--METADATA NAME:PROJWSRPT TYPE:TABLE CHANGE:CREATE
CREATE TABLE PROJWSRPT(
  RPT_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_projwsrpt PRIMARY KEY (rpt_id,proj_id) ,CONSTRAINT fk_projwsrpt_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_projwsrpt_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:PRPFOLIO TYPE:TABLE CHANGE:CREATE
CREATE TABLE PRPFOLIO(
  PFOLIO_ID  INTEGER NOT NULL,
  WBS_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_prpfolio PRIMARY KEY (pfolio_id,wbs_id) ,CONSTRAINT fk_prpfolio_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
 ,CONSTRAINT fk_prpfolio_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
)
/

--METADATA NAME:PUBUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE PUBUSER(
  PUBLIC_GROUP_ID  INTEGER NOT NULL,
  PRIVATE_DB_USER_NAME  VARCHAR2(255) NOT NULL,
  PRIVATE_DB_PASSWD  VARCHAR2(255) NULL
,CONSTRAINT pk_${pm.sl.public_user} PRIMARY KEY (public_group_id))
/

--METADATA NAME:QUERYLIB TYPE:TABLE CHANGE:CREATE
CREATE TABLE QUERYLIB(
  QUERY_LIB_ID  INTEGER NOT NULL,
  APP_NAME  VARCHAR2(25) NOT NULL,
  CORE_FLAG  VARCHAR2(1) NOT NULL,
  MATCH_SQL  VARCHAR2(4000) NOT NULL,
  HINTS  VARCHAR2(4000) NULL,
  REPLACEMENT_SQL  VARCHAR2(4000) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_querylib PRIMARY KEY (query_lib_id))
/

--METADATA NAME:RCATTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE RCATTYPE(
  RSRC_CATG_TYPE_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  RSRC_CATG_SHORT_LEN  INTEGER NOT NULL,
  RSRC_CATG_TYPE  VARCHAR2(40) NOT NULL,
  SUPER_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rcattype PRIMARY KEY (rsrc_catg_type_id))
/

--METADATA NAME:RCATVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE RCATVAL(
  RSRC_CATG_ID  INTEGER NOT NULL,
  RSRC_CATG_TYPE_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  RSRC_CATG_SHORT_NAME  VARCHAR2(32) NOT NULL,
  RSRC_CATG_NAME  VARCHAR2(100) NULL,
  PARENT_RSRC_CATG_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rcatval PRIMARY KEY (rsrc_catg_id) ,CONSTRAINT fk_rcatval_rcattype FOREIGN KEY (rsrc_catg_type_id)
REFERENCES RCATTYPE (rsrc_catg_type_id) 
)
/

--METADATA NAME:REFRDEL TYPE:TABLE CHANGE:CREATE
CREATE TABLE REFRDEL(
  DELETE_DATE  DATETIME DEFAULT sysdate NOT NULL,
  TABLE_NAME  VARCHAR2(30) NOT NULL,
  PK1  VARCHAR2(255) NOT NULL,
  PK2  VARCHAR2(255) NULL,
  PK3  VARCHAR2(255) NULL,
  PK4  VARCHAR2(255) NULL,
  PROJ_ID  INTEGER NULL
)
/

--METADATA NAME:REITTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE REITTYPE(
  RELATED_ITEM_TYPE_ID  INTEGER NOT NULL,
  RELATED_ITEM  VARCHAR2(32) NOT NULL,
  TABLE_NAME  VARCHAR2(30) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_reittype PRIMARY KEY (related_item_type_id))
/

--METADATA NAME:RELEASE TYPE:TABLE CHANGE:CREATE
CREATE TABLE RELEASE(
  RELEASE_ID  INTEGER NOT NULL,
  RFOLIO_ID  INTEGER NULL,
  RELEASE_NAME  VARCHAR2(60) NOT NULL,
  START_DATE  DATETIME NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  RELEASE_THEME  VARCHAR2(255) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_release PRIMARY KEY (release_id) ,CONSTRAINT fk_release_rfolio FOREIGN KEY (rfolio_id)
REFERENCES RFOLIO (rfolio_id) 
 ,CONSTRAINT fk_release_proj_id FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
)
/

--METADATA NAME:RELITEMS TYPE:TABLE CHANGE:CREATE
CREATE TABLE RELITEMS(
  ITEM_TYPE_ID  INTEGER NOT NULL,
  FK_ID  INTEGER NOT NULL,
  RELATED_ITEM_TYPE_ID  INTEGER NOT NULL,
  RELATED_FK_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_relitems PRIMARY KEY (item_type_id,fk_id,related_item_type_id,related_fk_id) ,CONSTRAINT fk_relitems_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_relitems_reittype FOREIGN KEY (item_type_id)
REFERENCES REITTYPE (related_item_type_id) 
 ,CONSTRAINT fk_relitems_reittype_related FOREIGN KEY (related_item_type_id)
REFERENCES REITTYPE (related_item_type_id) 
)
/

--METADATA NAME:RFOLIO TYPE:TABLE CHANGE:CREATE
CREATE TABLE RFOLIO(
  RFOLIO_ID  INTEGER NOT NULL,
  USER_ID  INTEGER NULL,
  RFOLIO_NAME  VARCHAR2(40) NOT NULL,
  RFOLIO_TYPE  VARCHAR2(20) NOT NULL,
  RFOLIO_DESCR  VARCHAR2(255) NULL,
  TEAM_CAPACITY_PCT  REAL NULL,
  PARENT_RFOLIO_ID  INTEGER NULL,
  RFOLIO_DATA  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rfolio PRIMARY KEY (rfolio_id) ,CONSTRAINT fk_rfolio_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:RISKCTRL TYPE:TABLE CHANGE:CREATE
CREATE TABLE RISKCTRL(
  RISK_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  RISK_CONTROL  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_riskctrl PRIMARY KEY (risk_id))
/

--METADATA NAME:RISKTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE RISKTYPE(
  RISK_TYPE_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  RISK_TYPE  VARCHAR2(40) NOT NULL,
  PARENT_RISK_TYPE_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_risktype PRIMARY KEY (risk_type_id))
/

--METADATA NAME:RLFOLIO TYPE:TABLE CHANGE:CREATE
CREATE TABLE RLFOLIO(
  RLFOLIO_ID  INTEGER NOT NULL,
  USER_ID  INTEGER NULL,
  RLFOLIO_NAME  VARCHAR2(40) NOT NULL,
  RLFOLIO_TYPE  VARCHAR2(20) NOT NULL,
  RLFOLIO_DESCR  VARCHAR2(255) NULL,
  RLFOLIO_DATA  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rlfolio_id PRIMARY KEY (rlfolio_id) ,CONSTRAINT fk_rlfolio_user FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:ROLECATTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLECATTYPE(
  ROLE_CATG_TYPE_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  ROLE_CATG_SHORT_LEN  INTEGER NOT NULL,
  ROLE_CATG_TYPE  VARCHAR2(60) NOT NULL,
  SUPER_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rolecattype PRIMARY KEY (role_catg_type_id))
/

--METADATA NAME:ROLECATVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLECATVAL(
  ROLE_CATG_ID  INTEGER NOT NULL,
  ROLE_CATG_TYPE_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  ROLE_CATG_SHORT_NAME  VARCHAR2(60) NOT NULL,
  ROLE_CATG_NAME  VARCHAR2(100) NULL,
  PARENT_ROLE_CATG_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rolecatval PRIMARY KEY (role_catg_id) ,CONSTRAINT fk_rolecatval_rolecattype FOREIGN KEY (role_catg_type_id)
REFERENCES ROLECATTYPE (role_catg_type_id) 
)
/

--METADATA NAME:ROLELIMIT TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLELIMIT(
  ROLELIMIT_ID  INTEGER NOT NULL,
  ROLE_ID  INTEGER NOT NULL,
  START_DATE  DATETIME NOT NULL,
  MAX_QTY_PER_HR  REAL NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rolelimit PRIMARY KEY (rolelimit_id) ,CONSTRAINT fk_rolelimit_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:ROLERATE TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLERATE(
  ROLE_RATE_ID  INTEGER NOT NULL,
  ROLE_ID  INTEGER NOT NULL,
  START_DATE  DATETIME DEFAULT sysdate NOT NULL,
  MAX_QTY_PER_HR  REAL DEFAULT 1 NULL,
  COST_PER_QTY  REAL NULL,
  COST_PER_QTY2  REAL NULL,
  COST_PER_QTY3  REAL NULL,
  COST_PER_QTY4  REAL NULL,
  COST_PER_QTY5  REAL NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rolerate PRIMARY KEY (role_rate_id) ,CONSTRAINT fk_rolerate_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:ROLERCAT TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLERCAT(
  ROLE_ID  INTEGER NOT NULL,
  ROLE_CATG_TYPE_ID  INTEGER NOT NULL,
  ROLE_CATG_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rolercat PRIMARY KEY (role_id,role_catg_type_id) ,CONSTRAINT fk_rolercat_rolecattype FOREIGN KEY (role_catg_type_id)
REFERENCES ROLECATTYPE (role_catg_type_id) 
 ,CONSTRAINT fk_rolercat_rolecatval FOREIGN KEY (role_catg_id)
REFERENCES ROLECATVAL (role_catg_id) 
 ,CONSTRAINT fk_rolercat_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
)
/

--METADATA NAME:ROLES TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLES(
  ROLE_ID  INTEGER NOT NULL,
  ROLE_SHORT_NAME  VARCHAR2(40) NOT NULL,
  ROLE_NAME  VARCHAR2(100) NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  PARENT_ROLE_ID  INTEGER NULL,
  DEF_COST_QTY_LINK_FLAG  VARCHAR2(1) NOT NULL,
  COST_QTY_TYPE  VARCHAR2(24) DEFAULT 'QT_Hour' NOT NULL,
  POBS_ID  INTEGER NULL,
  ROLE_DESCR  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_roles PRIMARY KEY (role_id) ,CONSTRAINT fk_roles_pobs FOREIGN KEY (pobs_id)
REFERENCES POBS (pobs_id) 
)
/

--METADATA NAME:ROLFOLIO TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLFOLIO(
  RLFOLIO_ID  INTEGER NOT NULL,
  ROLE_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rolfolio PRIMARY KEY (rlfolio_id,role_id) ,CONSTRAINT fk_rolfolio_rlfolio FOREIGN KEY (rlfolio_id)
REFERENCES RLFOLIO (rlfolio_id) 
 ,CONSTRAINT fk_rolfolio_role FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
)
/

--METADATA NAME:RPT TYPE:TABLE CHANGE:CREATE
CREATE TABLE RPT(
  RPT_ID  INTEGER NOT NULL,
  GLOBAL_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  RPT_TYPE  VARCHAR2(12) NOT NULL,
  RPT_NAME  VARCHAR2(80) NOT NULL,
  RPT_AREA  VARCHAR2(32) DEFAULT 'Unknown' NOT NULL,
  RPT_GROUP_ID  INTEGER NULL,
  PROJ_ID  INTEGER NULL,
  RPT_STATE  VARCHAR2(10) NULL,
  RPT_DATA  BLOB NULL,
  LAST_RUN_DATE  DATETIME NULL,
  USER_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rpt PRIMARY KEY (rpt_id) ,CONSTRAINT fk_rpt_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_rpt_rptgroup FOREIGN KEY (rpt_group_id)
REFERENCES RPTGROUP (rpt_group_id) 
 ,CONSTRAINT fk_rpt_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:RPTBATCH TYPE:TABLE CHANGE:CREATE
CREATE TABLE RPTBATCH(
  RPT_BATCH_ID  INTEGER NOT NULL,
  RPT_BATCH_NAME  VARCHAR2(80) NOT NULL,
  PROJ_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rptbatch PRIMARY KEY (rpt_batch_id) ,CONSTRAINT fk_rptbatch_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
)
/

--METADATA NAME:RPTGROUP TYPE:TABLE CHANGE:CREATE
CREATE TABLE RPTGROUP(
  RPT_GROUP_ID  INTEGER NOT NULL,
  RPT_GROUP_SEQ_NUM  INTEGER NOT NULL,
  RPT_GROUP_NAME  VARCHAR2(80) NOT NULL,
  PARENT_GROUP_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rptgroup PRIMARY KEY (rpt_group_id))
/

--METADATA NAME:RPTLIST TYPE:TABLE CHANGE:CREATE
CREATE TABLE RPTLIST(
  RPT_BATCH_ID  INTEGER NOT NULL,
  RPT_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rptlist PRIMARY KEY (rpt_batch_id,rpt_id) ,CONSTRAINT fk_rptlist_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id) 
 ,CONSTRAINT fk_rptlist_rptbatch FOREIGN KEY (rpt_batch_id)
REFERENCES RPTBATCH (rpt_batch_id) 
)
/

--METADATA NAME:RSRC TYPE:TABLE CHANGE:CREATE
CREATE TABLE RSRC(
  RSRC_ID  INTEGER NOT NULL,
  CLNDR_ID  INTEGER NOT NULL,
  RSRC_SEQ_NUM  INTEGER NOT NULL,
  TIMESHEET_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  ACTIVE_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  RSRC_TYPE  VARCHAR2(10) DEFAULT 'RT_Labor' NOT NULL,
  AUTO_COMPUTE_ACT_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  OT_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  DEF_COST_QTY_LINK_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  RSRC_SHORT_NAME  VARCHAR2(255) NOT NULL,
  RSRC_NAME  VARCHAR2(255) NOT NULL,
  PARENT_RSRC_ID  INTEGER NULL,
  XFER_COMPLETE_DAY_CNT  INTEGER NULL,
  XFER_NOTSTART_DAY_CNT  INTEGER NULL,
  TS_APPROVE_USER_ID  INTEGER NULL,
  USER_ID  INTEGER NULL,
  ROLE_ID  INTEGER NULL,
  CURR_ID  INTEGER DEFAULT 1 NOT NULL,
  LAST_CHECKSUM  INTEGER NULL,
  SHIFT_ID  INTEGER NULL,
  OT_FACTOR  REAL NULL,
  DEF_QTY_PER_HR  REAL NULL,
  GUID  VARCHAR2(22) NULL,
  COST_QTY_TYPE  VARCHAR2(24) NULL,
  OFFICE_PHONE  VARCHAR2(32) NULL,
  OTHER_PHONE  VARCHAR2(32) NULL,
  EMPLOYEE_CODE  VARCHAR2(40) NULL,
  RSRC_TITLE_NAME  VARCHAR2(100) NULL,
  EMAIL_ADDR  VARCHAR2(120) NULL,
  UNIT_ID  INTEGER NULL,
  POBS_ID  INTEGER NULL,
  RSRC_NOTES  BLOB NULL,
  INTG_TYPE  VARCHAR2(100) NULL,
  UPDATE_DATE  DATETIME NULL,
  LOCATION_ID  INTEGER NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rsrc PRIMARY KEY (rsrc_id) ,CONSTRAINT fk_rsrc_calendar FOREIGN KEY (clndr_id)
REFERENCES CALENDAR (clndr_id) 
 ,CONSTRAINT fk_rsrc_currtype FOREIGN KEY (curr_id)
REFERENCES CURRTYPE (curr_id) 
 ,CONSTRAINT fk_rsrc_shift FOREIGN KEY (shift_id)
REFERENCES SHIFT (shift_id) 
 ,CONSTRAINT fk_rsrc_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
 ,CONSTRAINT fk_rsrc_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
 ,CONSTRAINT fk_rsrc_umeasure FOREIGN KEY (unit_id)
REFERENCES UMEASURE (unit_id) 
 ,CONSTRAINT fk_rsrc_pobs FOREIGN KEY (pobs_id)
REFERENCES POBS (pobs_id) 
)
/

--METADATA NAME:RSRCANDASH TYPE:TABLE CHANGE:CREATE
CREATE TABLE RSRCANDASH(
  DASHBOARD_ID  INTEGER NOT NULL,
  RSRCAN_VIEW_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rsrcandash PRIMARY KEY (dashboard_id,rsrcan_view_id) ,CONSTRAINT fk_rsrcandash_dashboard FOREIGN KEY (dashboard_id)
REFERENCES DASHBOARD (dashboard_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_rsrcandash_rsrcanview FOREIGN KEY (rsrcan_view_id)
REFERENCES RSRCANVIEW (rsrcan_view_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:RSRCANVIEW TYPE:TABLE CHANGE:CREATE
CREATE TABLE RSRCANVIEW(
  RSRCAN_VIEW_ID  INTEGER NOT NULL,
  RSRCAN_VIEW_NAME  VARCHAR2(255) NOT NULL,
  USER_ID  INTEGER NULL,
  RSRCAN_VIEW_TYPE  VARCHAR2(20) NULL,
  RSRCAN_VIEW_DATA  VARCHAR2(4000) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rsrcanview PRIMARY KEY (rsrcan_view_id) ,CONSTRAINT fk_rsrcanview_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:RSRCCURV TYPE:TABLE CHANGE:CREATE
CREATE TABLE RSRCCURV(
  CURV_ID  INTEGER NOT NULL,
  CURV_NAME  VARCHAR2(60) NOT NULL,
  DEFAULT_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  CURV_DATA  BLOB NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rsrccurv PRIMARY KEY (curv_id))
/

--METADATA NAME:RSRCHOUR TYPE:TABLE CHANGE:CREATE
CREATE TABLE RSRCHOUR(
  RSRC_HR_ID  INTEGER NOT NULL,
  RSRC_ID  INTEGER NOT NULL,
  TS_ID  INTEGER NOT NULL,
  TASK_TS_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  TASKRSRC_ID  INTEGER NULL,
  NONWORK_TYPE_ID  INTEGER NULL,
  PROJ_ID  INTEGER NULL,
  PEND_HR_CNT  REAL NULL,
  HR_CNT  REAL NULL,
  PEND_OT_HR_CNT  REAL NULL,
  OT_HR_CNT  REAL NULL,
  WORK_DATE  DATETIME NULL,
  STATUS_CODE  VARCHAR2(20) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rsrchour PRIMARY KEY (rsrc_hr_id) ,CONSTRAINT fk_rsrchour_nonwork FOREIGN KEY (nonwork_type_id)
REFERENCES NONWORK (nonwork_type_id) 
 ,CONSTRAINT fk_rsrchour_taskrsrc FOREIGN KEY (taskrsrc_id)
REFERENCES TASKRSRC (taskrsrc_id) 
 ,CONSTRAINT fk_rsrchour_timesht FOREIGN KEY (ts_id,rsrc_id)
REFERENCES TIMESHT (ts_id,rsrc_id) 
 ,CONSTRAINT fk_rsrchour_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
)
/

--METADATA NAME:RSRCPROP TYPE:TABLE CHANGE:CREATE
CREATE TABLE RSRCPROP(
  RSRC_ID  INTEGER NOT NULL,
  PROP_NAME  VARCHAR2(20) NOT NULL,
  PROP_VALUE  VARCHAR2(255) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rsrcprop PRIMARY KEY (rsrc_id,prop_name) ,CONSTRAINT fk_rsrcprop_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
)
/

--METADATA NAME:RSRCRATE TYPE:TABLE CHANGE:CREATE
CREATE TABLE RSRCRATE(
  RSRC_RATE_ID  INTEGER NOT NULL,
  RSRC_ID  INTEGER NOT NULL,
  START_DATE  DATETIME NOT NULL,
  SHIFT_PERIOD_ID  INTEGER NULL,
  MAX_QTY_PER_HR  REAL NULL,
  COST_PER_QTY  REAL NULL,
  COST_PER_QTY2  REAL NULL,
  COST_PER_QTY3  REAL NULL,
  COST_PER_QTY4  REAL NULL,
  COST_PER_QTY5  REAL NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rsrcrate PRIMARY KEY (rsrc_rate_id) ,CONSTRAINT fk_rsrcrate_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
 ,CONSTRAINT fk_rsrcrate_shiftper FOREIGN KEY (shift_period_id)
REFERENCES SHIFTPER (shift_period_id) 
)
/

--METADATA NAME:RSRCRCAT TYPE:TABLE CHANGE:CREATE
CREATE TABLE RSRCRCAT(
  RSRC_ID  INTEGER NOT NULL,
  RSRC_CATG_TYPE_ID  INTEGER NOT NULL,
  RSRC_CATG_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rsrcrcat PRIMARY KEY (rsrc_id,rsrc_catg_type_id) ,CONSTRAINT fk_rsrcrcat_rcattype FOREIGN KEY (rsrc_catg_type_id)
REFERENCES RCATTYPE (rsrc_catg_type_id) 
 ,CONSTRAINT fk_rsrcrcat_rcatval FOREIGN KEY (rsrc_catg_id)
REFERENCES RCATVAL (rsrc_catg_id) 
 ,CONSTRAINT fk_rsrcrcat_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
)
/

--METADATA NAME:RSRCROLE TYPE:TABLE CHANGE:CREATE
CREATE TABLE RSRCROLE(
  RSRC_ID  INTEGER NOT NULL,
  ROLE_ID  INTEGER NOT NULL,
  SKILL_LEVEL  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rsrcrole PRIMARY KEY (rsrc_id,role_id) ,CONSTRAINT fk_rsrcrole_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
 ,CONSTRAINT fk_rsrcrole_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
)
/

--METADATA NAME:RSRCSEC TYPE:TABLE CHANGE:CREATE
CREATE TABLE RSRCSEC(
  USER_ID  INTEGER NOT NULL,
  RSRC_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rsrcsec PRIMARY KEY (user_id,rsrc_id) ,CONSTRAINT fk_rsrcsec_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_rsrcsec_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:RSRFOLIO TYPE:TABLE CHANGE:CREATE
CREATE TABLE RSRFOLIO(
  RFOLIO_ID  INTEGER NOT NULL,
  RSRC_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_rsrfolio PRIMARY KEY (rfolio_id,rsrc_id) ,CONSTRAINT fk_rsrfolio_rfolio FOREIGN KEY (rfolio_id)
REFERENCES RFOLIO (rfolio_id) 
 ,CONSTRAINT fk_rsrfolio_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
)
/

--METADATA NAME:SCENARIO TYPE:TABLE CHANGE:CREATE
CREATE TABLE SCENARIO(
  SCENARIO_ID  INTEGER NOT NULL,
  SCENARIO_NAME  VARCHAR2(255) NOT NULL,
  USER_ID  INTEGER NULL,
  TABLE_NAME  VARCHAR2(30) NULL,
  FK_ID  INTEGER NULL,
  SCENARIO_TYPE  VARCHAR2(30) NULL,
  VIEW_PREF_ID  INTEGER NULL,
  VIEW_TYPE  VARCHAR2(30) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_scenario PRIMARY KEY (scenario_id) ,CONSTRAINT fk_scenario_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
 ,CONSTRAINT fk_scenario_viewpref FOREIGN KEY (view_pref_id)
REFERENCES VIEWPREF (view_pref_id) 
)
/

--METADATA NAME:SCENPROJ TYPE:TABLE CHANGE:CREATE
CREATE TABLE SCENPROJ(
  SCENARIO_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  SELECTED_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_scenprog PRIMARY KEY (scenario_id,proj_id) ,CONSTRAINT fk_scenproj_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_scenproj_scenario FOREIGN KEY (scenario_id)
REFERENCES SCENARIO (scenario_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:SCENROLE TYPE:TABLE CHANGE:CREATE
CREATE TABLE SCENROLE(
  SCENARIO_ID  INTEGER NOT NULL,
  ROLE_ID  INTEGER NOT NULL,
  SELECTED_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_scenrole PRIMARY KEY (scenario_id,role_id) ,CONSTRAINT fk_scenrole_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_scenrole_scenario FOREIGN KEY (scenario_id)
REFERENCES SCENARIO (scenario_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:SCENUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE SCENUSER(
  SCENARIO_ID  INTEGER NOT NULL,
  USER_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_scenuser PRIMARY KEY (scenario_id,user_id) ,CONSTRAINT fk_scenuser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_scenuser_scenario FOREIGN KEY (scenario_id)
REFERENCES SCENARIO (scenario_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:SETTINGS TYPE:TABLE CHANGE:CREATE
CREATE TABLE SETTINGS(
  NAMESPACE  VARCHAR2(255) NOT NULL,
  SETTING_NAME  VARCHAR2(255) NOT NULL,
  SETTING_VALUE  VARCHAR2(4000) NULL,
  USER_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_settings PRIMARY KEY (namespace,setting_name))
/

--METADATA NAME:SHIFT TYPE:TABLE CHANGE:CREATE
CREATE TABLE SHIFT(
  SHIFT_ID  INTEGER NOT NULL,
  SHIFT_NAME  VARCHAR2(60) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_shift PRIMARY KEY (shift_id))
/

--METADATA NAME:SHIFTPER TYPE:TABLE CHANGE:CREATE
CREATE TABLE SHIFTPER(
  SHIFT_PERIOD_ID  INTEGER NOT NULL,
  SHIFT_ID  INTEGER NOT NULL,
  SHIFT_START_HR_NUM  REAL NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_shiftper PRIMARY KEY (shift_period_id) ,CONSTRAINT fk_shiftper_shift FOREIGN KEY (shift_id)
REFERENCES SHIFT (shift_id) 
)
/

--METADATA NAME:SPIDMAP TYPE:TABLE CHANGE:CREATE
CREATE TABLE SPIDMAP(
  SPID  INTEGER NOT NULL,
  USER_ID  INTEGER NULL,
  USER_NAME  VARCHAR2(255) NULL,
  APP_NAME  VARCHAR2(25) NULL,
  REFRDEL_PROJECT_BYPASS  INTEGER NULL,
  AUDIT_INFO_EXTENDED  BLOB NULL
,CONSTRAINT pk_spidmap PRIMARY KEY (spid))
/

--METADATA NAME:SUMPROJCOST TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMPROJCOST(
  PROJ_ID  INTEGER NOT NULL,
  WBS_ID  INTEGER NOT NULL,
  COST_TYPE_ID  INTEGER NOT NULL,
  START_DATE  DATETIME NULL,
  END_DATE  DATETIME NULL,
  SPREAD_TYPE  VARCHAR2(20) NULL,
  ACT_COST  REAL NULL,
  REMAIN_COST  REAL NULL,
  TARGET_COST  REAL NULL,
  TOTAL_COST  REAL NULL
 ,CONSTRAINT fk_sumprojcost_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_sumprojcost_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_sumprojcost_costtype FOREIGN KEY (cost_type_id)
REFERENCES COSTTYPE (cost_type_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:SUMTASK TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMTASK(
  PROJ_ID  INTEGER NOT NULL,
  WBS_ID  INTEGER NOT NULL,
  BCWP  REAL NULL,
  BCWS  REAL NULL,
  EAC  REAL NULL,
  EAC_WORK_QTY  REAL NULL,
  ETC  REAL NULL,
  ETC_WORK_QTY  REAL NULL,
  PERFM_WORK_QTY  REAL NULL,
  SCHED_WORK_QTY  REAL NULL,
  COMPLETE_CNT  INTEGER NULL,
  ACTIVE_CNT  INTEGER NULL,
  NOTSTARTED_CNT  INTEGER NULL,
  BASE_COMPLETE_CNT  INTEGER NULL,
  BASE_ACTIVE_CNT  INTEGER NULL,
  BASE_NOTSTARTED_CNT  INTEGER NULL,
  ACT_DRTN_HR_CNT  REAL NULL,
  TOTAL_DRTN_HR_CNT  REAL NULL,
  BASE_DRTN_HR_CNT  REAL NULL,
  REMAIN_DRTN_HR_CNT  REAL NULL,
  TOTAL_FLOAT_HR_CNT  REAL NULL,
  ACT_END_DATE  DATETIME NULL,
  ACT_START_DATE  DATETIME NULL,
  BASE_END_DATE  DATETIME NULL,
  BASE_START_DATE  DATETIME NULL,
  REEND_DATE  DATETIME NULL,
  RESTART_DATE  DATETIME NULL,
  ACT_THIS_PER_WORK_COST  REAL NULL,
  ACT_THIS_PER_WORK_QTY  REAL NULL,
  ACT_THIS_PER_EQUIP_COST  REAL NULL,
  ACT_THIS_PER_EQUIP_QTY  REAL NULL,
  ACT_THIS_PER_MAT_COST  REAL NULL,
  ACT_COST  REAL NULL,
  ACT_EQUIP_COST  REAL NULL,
  ACT_EXPENSE_COST  REAL NULL,
  ACT_MAT_COST  REAL NULL,
  ACT_WORK_COST  REAL NULL,
  ACT_EQUIP_QTY  REAL NULL,
  ACT_WORK_QTY  REAL NULL,
  BASE_COST  REAL NULL,
  BASE_EQUIP_COST  REAL NULL,
  BASE_EXPENSE_COST  REAL NULL,
  BASE_MAT_COST  REAL NULL,
  BASE_WORK_COST  REAL NULL,
  BASE_EQUIP_QTY  REAL NULL,
  BASE_WORK_QTY  REAL NULL,
  REMAIN_COST  REAL NULL,
  REMAIN_EQUIP_COST  REAL NULL,
  REMAIN_EXPENSE_COST  REAL NULL,
  REMAIN_MAT_COST  REAL NULL,
  REMAIN_WORK_COST  REAL NULL,
  REMAIN_EQUIP_QTY  REAL NULL,
  REMAIN_WORK_QTY  REAL NULL,
  TARGET_COST  REAL NULL,
  TARGET_EQUIP_COST  REAL NULL,
  TARGET_EXPENSE_COST  REAL NULL,
  TARGET_MAT_COST  REAL NULL,
  TARGET_WORK_COST  REAL NULL,
  TARGET_EQUIP_QTY  REAL NULL,
  TARGET_WORK_QTY  REAL NULL,
  TOTAL_COST  REAL NULL,
  TOTAL_EQUIP_COST  REAL NULL,
  TOTAL_EXPENSE_COST  REAL NULL,
  TOTAL_MAT_COST  REAL NULL,
  TOTAL_WORK_COST  REAL NULL,
  TOTAL_EQUIP_QTY  REAL NULL,
  TOTAL_WORK_QTY  REAL NULL,
  TARGET_START_DATE  DATETIME NULL,
  TARGET_END_DATE  DATETIME NULL,
  TARGET_DRTN_HR_CNT  REAL NULL
 ,CONSTRAINT fk_sumtask_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_sumtask_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:SUMTASKSPREAD TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMTASKSPREAD(
  PROJ_ID  INTEGER NOT NULL,
  WBS_ID  INTEGER NOT NULL,
  START_DATE  DATETIME NOT NULL,
  END_DATE  DATETIME NOT NULL,
  SPREAD_TYPE  VARCHAR2(20) NOT NULL,
  ACT_COST  REAL NULL,
  ACT_EQUIP_COST  REAL NULL,
  ACT_EXPENSE_COST  REAL NULL,
  ACT_MAT_COST  REAL NULL,
  ACT_WORK_COST  REAL NULL,
  ACT_EQUIP_QTY  REAL NULL,
  ACT_WORK_QTY  REAL NULL,
  BASE_COST  REAL NULL,
  BASE_EQUIP_COST  REAL NULL,
  BASE_EXPENSE_COST  REAL NULL,
  BASE_MAT_COST  REAL NULL,
  BASE_WORK_COST  REAL NULL,
  BASE_EQUIP_QTY  REAL NULL,
  BASE_WORK_QTY  REAL NULL,
  LATE_REMAIN_COST  REAL NULL,
  LATE_REMAIN_EQUIP_COST  REAL NULL,
  LATE_REMAIN_EXPENSE_COST  REAL NULL,
  LATE_REMAIN_MAT_COST  REAL NULL,
  LATE_REMAIN_WORK_COST  REAL NULL,
  LATE_REMAIN_EQUIP_QTY  REAL NULL,
  LATE_REMAIN_WORK_QTY  REAL NULL,
  REMAIN_COST  REAL NULL,
  REMAIN_EQUIP_COST  REAL NULL,
  REMAIN_EXPENSE_COST  REAL NULL,
  REMAIN_MAT_COST  REAL NULL,
  REMAIN_WORK_COST  REAL NULL,
  REMAIN_EQUIP_QTY  REAL NULL,
  REMAIN_WORK_QTY  REAL NULL,
  TARGET_COST  REAL NULL,
  TARGET_EQUIP_COST  REAL NULL,
  TARGET_EXPENSE_COST  REAL NULL,
  TARGET_MAT_COST  REAL NULL,
  TARGET_WORK_COST  REAL NULL,
  TARGET_EQUIP_QTY  REAL NULL,
  TARGET_WORK_QTY  REAL NULL,
  TOTAL_COST  REAL NULL,
  TOTAL_EQUIP_COST  REAL NULL,
  TOTAL_EXPENSE_COST  REAL NULL,
  TOTAL_MAT_COST  REAL NULL,
  TOTAL_WORK_COST  REAL NULL,
  TOTAL_EQUIP_QTY  REAL NULL,
  TOTAL_WORK_QTY  REAL NULL,
  BCWP  REAL NULL,
  BCWS  REAL NULL,
  EAC  REAL NULL,
  EAC_WORK_QTY  REAL NULL,
  ETC  REAL NULL,
  ETC_WORK_QTY  REAL NULL,
  PERFM_WORK_QTY  REAL NULL,
  SCHED_WORK_QTY  REAL NULL,
  FIN_PERIOD_ACT_WORK_QTY  REAL NULL,
  FIN_PERIOD_ACT_WORK_COST  REAL NULL,
  FIN_PERIOD_ACT_EQUIP_QTY  REAL NULL,
  FIN_PERIOD_ACT_EQUIP_COST  REAL NULL,
  FIN_PERIOD_ACT_MAT_COST  REAL NULL,
  FIN_PERIOD_ACT_EXPENSE_COST  REAL NULL,
  FIN_PERIOD_TOTAL_WORK_QTY  REAL NULL,
  FIN_PERIOD_TOTAL_WORK_COST  REAL NULL,
  FIN_PERIOD_TOTAL_EQUIP_QTY  REAL NULL,
  FIN_PERIOD_TOTAL_EQUIP_COST  REAL NULL,
  FIN_PERIOD_TOTAL_MAT_COST  REAL NULL,
  FIN_PERIOD_TOTAL_EXPENSE_COST  REAL NULL,
  FIN_PERIOD_TOTAL_COST  REAL NULL,
  FIN_PERIOD_ACT_COST  REAL NULL,
  FIN_PERIOD_BCWP  REAL NULL,
  FIN_PERIOD_PERFM_WORK_QTY  REAL NULL,
  FIN_PERIOD_EAC  REAL NULL,
  FIN_PERIOD_EAC_WORK_QTY  REAL NULL,
  FIN_PERIOD_BCWS  REAL NULL,
  FIN_PERIOD_SCHED_WORK_QTY  REAL NULL
 ,CONSTRAINT fk_sumtaskspread_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_sumtaskspread_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:SUMTRSRC TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMTRSRC(
  SUMTRSRC_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NULL,
  WBS_ID  INTEGER NULL,
  START_DATE  DATETIME NULL,
  END_DATE  DATETIME NULL,
  SPREAD_TYPE  VARCHAR2(20) NULL,
  RSRC_ID  INTEGER NULL,
  ROLE_ID  INTEGER NULL,
  ACT_START_DATE  DATETIME NULL,
  ACT_END_DATE  DATETIME NULL,
  REMAIN_START_DATE  DATETIME NULL,
  REMAIN_END_DATE  DATETIME NULL,
  OVERALLOC_DATE  DATETIME NULL,
  STAFFED_ACT_QTY  REAL NULL,
  UNSTAFFED_ACT_QTY  REAL NULL,
  STAFFED_ACT_COST  REAL NULL,
  UNSTAFFED_ACT_COST  REAL NULL,
  STAFFED_ACT_OT_QTY  REAL NULL,
  UNSTAFFED_ACT_OT_QTY  REAL NULL,
  STAFFED_ACT_OT_COST  REAL NULL,
  UNSTAFFED_ACT_OT_COST  REAL NULL,
  STAFFED_ACT_REG_COST  REAL NULL,
  UNSTAFFED_ACT_REG_COST  REAL NULL,
  STAFFED_ACT_REG_QTY  REAL NULL,
  UNSTAFFED_ACT_REG_QTY  REAL NULL,
  STAFFED_LATE_REMAIN_QTY  REAL NULL,
  UNSTAFFED_LATE_REMAIN_QTY  REAL NULL,
  STAFFED_LATE_REMAIN_COST  REAL NULL,
  UNSTAFFED_LATE_REMAIN_COST  REAL NULL,
  STAFFED_REMAIN_QTY  REAL NULL,
  UNSTAFFED_REMAIN_QTY  REAL NULL,
  STAFFED_REMAIN_COST  REAL NULL,
  UNSTAFFED_REMAIN_COST  REAL NULL,
  STAFFED_TARGET_QTY  REAL NULL,
  UNSTAFFED_TARGET_QTY  REAL NULL,
  STAFFED_TARGET_COST  REAL NULL,
  UNSTAFFED_TARGET_COST  REAL NULL,
  STAFFED_TOTAL_QTY  REAL NULL,
  UNSTAFFED_TOTAL_QTY  REAL NULL,
  STAFFED_TOTAL_COST  REAL NULL,
  UNSTAFFED_TOTAL_COST  REAL NULL,
  FIN_PERIOD_ACT_QTY  REAL NULL,
  FIN_PERIOD_ACT_COST  REAL NULL,
  FIN_PERIOD_TOTAL_QTY  REAL NULL,
  FIN_PERIOD_TOTAL_COST  REAL NULL
,CONSTRAINT pk_sumtrsrc PRIMARY KEY (sumtrsrc_id) ,CONSTRAINT fk_sumtrsrc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_sumtrsrc_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:TASK TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASK(
  TASK_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  WBS_ID  INTEGER NOT NULL,
  CLNDR_ID  INTEGER NOT NULL,
  EST_WT  REAL NULL,
  PHYS_COMPLETE_PCT  REAL DEFAULT 0 NOT NULL,
  REV_FDBK_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  LOCK_PLAN_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  AUTO_COMPUTE_ACT_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  COMPLETE_PCT_TYPE  VARCHAR2(10) DEFAULT 'CP_Drtn' NOT NULL,
  TASK_TYPE  VARCHAR2(10) NOT NULL,
  DURATION_TYPE  VARCHAR2(12) NOT NULL,
  REVIEW_TYPE  VARCHAR2(12) DEFAULT 'RV_OK' NOT NULL,
  STATUS_CODE  VARCHAR2(12) NOT NULL,
  TASK_CODE  VARCHAR2(40) NOT NULL,
  TASK_NAME  VARCHAR2(120) NOT NULL,
  RSRC_ID  INTEGER NULL,
  TOTAL_FLOAT_HR_CNT  REAL NULL,
  FREE_FLOAT_HR_CNT  REAL NULL,
  REMAIN_DRTN_HR_CNT  REAL NULL,
  ACT_WORK_QTY  REAL NULL,
  REMAIN_WORK_QTY  REAL NULL,
  TARGET_WORK_QTY  REAL NULL,
  TARGET_DRTN_HR_CNT  REAL NULL,
  TARGET_EQUIP_QTY  REAL NULL,
  ACT_EQUIP_QTY  REAL NULL,
  REMAIN_EQUIP_QTY  REAL NULL,
  CSTR_DATE  DATETIME NULL,
  ACT_START_DATE  DATETIME NULL,
  ACT_END_DATE  DATETIME NULL,
  LATE_START_DATE  DATETIME NULL,
  LATE_END_DATE  DATETIME NULL,
  EXPECT_END_DATE  DATETIME NULL,
  EARLY_START_DATE  DATETIME NULL,
  EARLY_END_DATE  DATETIME NULL,
  RESTART_DATE  DATETIME NULL,
  REEND_DATE  DATETIME NULL,
  TARGET_START_DATE  DATETIME NULL,
  TARGET_END_DATE  DATETIME NULL,
  REVIEW_END_DATE  DATETIME NULL,
  REM_LATE_START_DATE  DATETIME NULL,
  REM_LATE_END_DATE  DATETIME NULL,
  CSTR_TYPE  VARCHAR2(12) NULL,
  PRIORITY_TYPE  VARCHAR2(12) NULL,
  GUID  VARCHAR2(22) NULL,
  TMPL_GUID  VARCHAR2(22) NULL,
  CSTR_DATE2  DATETIME NULL,
  CSTR_TYPE2  VARCHAR2(12) NULL,
  FLOAT_PATH  INTEGER NULL,
  FLOAT_PATH_ORDER  INTEGER NULL,
  ACT_THIS_PER_WORK_QTY  REAL NULL,
  ACT_THIS_PER_EQUIP_QTY  REAL NULL,
  DRIVING_PATH_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  SUSPEND_DATE  DATETIME NULL,
  RESUME_DATE  DATETIME NULL,
  EXTERNAL_EARLY_START_DATE  DATETIME NULL,
  EXTERNAL_LATE_END_DATE  DATETIME NULL,
  LOCATION_ID  INTEGER NULL,
  CONTROL_UPDATES_FLAG  VARCHAR2(1) DEFAULT 'N' NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_task PRIMARY KEY (task_id) ,CONSTRAINT fk_task_calendar FOREIGN KEY (clndr_id)
REFERENCES CALENDAR (clndr_id) 
 ,CONSTRAINT fk_task_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
 ,CONSTRAINT fk_task_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_task_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
)
/

--METADATA NAME:TASKACTV TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKACTV(
  TASK_ID  INTEGER NOT NULL,
  ACTV_CODE_TYPE_ID  INTEGER NOT NULL,
  ACTV_CODE_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_taskactv PRIMARY KEY (task_id,actv_code_type_id) ,CONSTRAINT fk_taskactv_actvcode FOREIGN KEY (actv_code_id)
REFERENCES ACTVCODE (actv_code_id) 
 ,CONSTRAINT fk_taskactv_actvtype FOREIGN KEY (actv_code_type_id)
REFERENCES ACTVTYPE (actv_code_type_id) 
 ,CONSTRAINT fk_taskactv_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ,CONSTRAINT fk_taskactv_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
)
/

--METADATA NAME:TASKDOC TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKDOC(
  TASKDOC_ID  INTEGER NOT NULL,
  DOC_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  WBS_ID  INTEGER NOT NULL,
  WP_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  TASK_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_taskdoc PRIMARY KEY (taskdoc_id) ,CONSTRAINT fk_taskdoc_document FOREIGN KEY (doc_id)
REFERENCES DOCUMENT (doc_id) 
 ,CONSTRAINT fk_taskdoc_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
 ,CONSTRAINT fk_taskdoc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_taskdoc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
)
/

--METADATA NAME:TASKFDBK TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKFDBK(
  TASK_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  TASK_FDBK  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_taskfdbk PRIMARY KEY (task_id) ,CONSTRAINT fk_taskfdbk_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_taskfdbk_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
)
/

--METADATA NAME:TASKFIN TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKFIN(
  FIN_DATES_ID  INTEGER NOT NULL,
  TASK_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  ACT_WORK_QTY  REAL NULL,
  ACT_WORK_COST  REAL NULL,
  ACT_EQUIP_QTY  REAL NULL,
  ACT_EQUIP_COST  REAL NULL,
  ACT_MAT_COST  REAL NULL,
  ACT_EXPENSE_COST  REAL NULL,
  BCWP  REAL NULL,
  SCHED_WORK_QTY  REAL NULL,
  BCWS  REAL NULL,
  PERFM_WORK_QTY  REAL NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_taskfin PRIMARY KEY (fin_dates_id,task_id) ,CONSTRAINT fk_taskfin_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_taskfin_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_taskfin_findates FOREIGN KEY (fin_dates_id)
REFERENCES FINDATES (fin_dates_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:TASKMEMO TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKMEMO(
  MEMO_ID  INTEGER NOT NULL,
  TASK_ID  INTEGER NOT NULL,
  MEMO_TYPE_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  TASK_MEMO  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_taskmemo PRIMARY KEY (memo_id) ,CONSTRAINT fk_taskmemo_memotype FOREIGN KEY (memo_type_id)
REFERENCES MEMOTYPE (memo_type_id) 
 ,CONSTRAINT fk_taskmemo_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_taskmemo_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
)
/

--METADATA NAME:TASKNOTE TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKNOTE(
  TASK_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  TASK_NOTES  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_tasknote PRIMARY KEY (task_id) ,CONSTRAINT fk_tasknote_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_tasknote_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
)
/

--METADATA NAME:TASKPRED TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKPRED(
  TASK_PRED_ID  INTEGER NOT NULL,
  TASK_ID  INTEGER NOT NULL,
  PRED_TASK_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  PRED_PROJ_ID  INTEGER NOT NULL,
  PRED_TYPE  VARCHAR2(12) NOT NULL,
  LAG_HR_CNT  REAL NULL,
  COMMENTS  VARCHAR2(250) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_taskpred PRIMARY KEY (task_pred_id) ,CONSTRAINT fk_taskpred_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_taskpred_project_2 FOREIGN KEY (pred_proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_taskpred_task_2 FOREIGN KEY (pred_task_id)
REFERENCES TASK (task_id) 
 ,CONSTRAINT fk_taskpred_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
)
/

--METADATA NAME:TASKPROC TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKPROC(
  PROC_ID  INTEGER NOT NULL,
  TASK_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  COMPLETE_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  PROC_NAME  VARCHAR2(120) NOT NULL,
  PROC_WT  REAL NULL,
  COMPLETE_PCT  REAL NULL,
  PROC_DESCR  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_taskproc PRIMARY KEY (proc_id) ,CONSTRAINT fk_taskproc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_taskproc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
)
/

--METADATA NAME:TASKRISK TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKRISK(
  TASK_ID  INTEGER NOT NULL,
  RISK_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_risk_task PRIMARY KEY (risk_id,task_id) ,CONSTRAINT fk_risk_riskid FOREIGN KEY (risk_id)
REFERENCES PROJRISK (risk_id) 
 ,CONSTRAINT fk_risk_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ,CONSTRAINT fk_taskrisk_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:TASKRSRC TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKRSRC(
  TASKRSRC_ID  INTEGER NOT NULL,
  TASK_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  RSRC_TYPE  VARCHAR2(10) DEFAULT 'RT_Labor' NOT NULL,
  COST_QTY_LINK_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  ROLE_ID  INTEGER NULL,
  ACCT_ID  INTEGER NULL,
  RSRC_ID  INTEGER NULL,
  POBS_ID  INTEGER NULL,
  SKILL_LEVEL  INTEGER NULL,
  PEND_COMPLETE_PCT  REAL NULL,
  REMAIN_QTY  REAL NULL,
  PEND_REMAIN_QTY  REAL NULL,
  TARGET_QTY  REAL NULL,
  REMAIN_QTY_PER_HR  REAL NULL,
  PEND_ACT_REG_QTY  REAL NULL,
  TARGET_LAG_DRTN_HR_CNT  REAL NULL,
  TARGET_QTY_PER_HR  REAL NULL,
  ACT_OT_QTY  REAL NULL,
  PEND_ACT_OT_QTY  REAL NULL,
  ACT_REG_QTY  REAL NULL,
  RELAG_DRTN_HR_CNT  REAL NULL,
  OT_FACTOR  REAL NULL,
  COST_PER_QTY  REAL NULL,
  TARGET_COST  REAL NULL,
  ACT_REG_COST  REAL NULL,
  ACT_OT_COST  REAL NULL,
  REMAIN_COST  REAL NULL,
  ACT_START_DATE  DATETIME NULL,
  ACT_END_DATE  DATETIME NULL,
  RESTART_DATE  DATETIME NULL,
  REEND_DATE  DATETIME NULL,
  TARGET_START_DATE  DATETIME NULL,
  TARGET_END_DATE  DATETIME NULL,
  REM_LATE_START_DATE  DATETIME NULL,
  REM_LATE_END_DATE  DATETIME NULL,
  GUID  VARCHAR2(22) NULL,
  RATE_TYPE  VARCHAR2(14) DEFAULT 'COST_PER_QTY' NULL,
  ACT_THIS_PER_COST  REAL NULL,
  ACT_THIS_PER_QTY  REAL NULL,
  CURV_ID  INTEGER NULL,
  ROLLUP_DATES_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  COST_PER_QTY_SOURCE_TYPE  VARCHAR2(24) DEFAULT 'ST_Rsrc' NOT NULL,
  REMAIN_CRV  VARCHAR2(4000) NULL,
  TARGET_CRV  VARCHAR2(4000) NULL,
  ACTUAL_CRV  VARCHAR2(4000) NULL,
  RSRC_REQUEST_DATA  BLOB NULL,
  TS_PEND_ACT_END_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  PRIOR_TS_ACT_REG_QTY  REAL NULL,
  PRIOR_TS_ACT_OT_QTY  REAL NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_taskrsrc PRIMARY KEY (taskrsrc_id) ,CONSTRAINT fk_taskrsrc_account FOREIGN KEY (acct_id)
REFERENCES ACCOUNT (acct_id) 
 ,CONSTRAINT fk_taskrsrc_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
 ,CONSTRAINT fk_taskrsrc_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
 ,CONSTRAINT fk_taskrsrc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_taskrsrc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ,CONSTRAINT fk_taskrsrc_rsrccurv FOREIGN KEY (curv_id)
REFERENCES RSRCCURV (curv_id) 
 ,CONSTRAINT fk_taskrsrc_pobs FOREIGN KEY (pobs_id)
REFERENCES POBS (pobs_id) 
)
/

--METADATA NAME:TASKSUM TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKSUM(
  TASK_SUM_ID  INTEGER NOT NULL,
  WBS_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  COMPLETE_CNT  INTEGER NULL,
  ACTIVE_CNT  INTEGER NULL,
  NOTSTARTED_CNT  INTEGER NULL,
  BASE_COMPLETE_CNT  INTEGER NULL,
  BASE_ACTIVE_CNT  INTEGER NULL,
  BASE_NOTSTARTED_CNT  INTEGER NULL,
  ACT_DRTN_HR_CNT  REAL NULL,
  ACT_EQUIP_QTY  REAL NULL,
  ACT_WORK_QTY  REAL NULL,
  TOTAL_DRTN_HR_CNT  REAL NULL,
  BASE_DRTN_HR_CNT  REAL NULL,
  BASE_WORK_QTY  REAL NULL,
  BASE_EQUIP_QTY  REAL NULL,
  ETC_WORK_QTY  REAL NULL,
  REMAIN_DRTN_HR_CNT  REAL NULL,
  REMAIN_WORK_QTY  REAL NULL,
  REMAIN_EQUIP_QTY  REAL NULL,
  TOTAL_FLOAT_HR_CNT  REAL NULL,
  ACT_EXPENSE_COST  REAL NULL,
  ACT_WORK_COST  REAL NULL,
  ACT_EQUIP_COST  REAL NULL,
  BASE_EXPENSE_COST  REAL NULL,
  BASE_WORK_COST  REAL NULL,
  BASE_EQUIP_COST  REAL NULL,
  BCWP  REAL NULL,
  ETC  REAL NULL,
  BCWS  REAL NULL,
  REMAIN_EXPENSE_COST  REAL NULL,
  REMAIN_WORK_COST  REAL NULL,
  REMAIN_EQUIP_COST  REAL NULL,
  PERFM_WORK_QTY  REAL NULL,
  SCHED_WORK_QTY  REAL NULL,
  ACT_END_DATE  DATETIME NULL,
  ACT_START_DATE  DATETIME NULL,
  BASE_END_DATE  DATETIME NULL,
  BASE_START_DATE  DATETIME NULL,
  REEND_DATE  DATETIME NULL,
  RESTART_DATE  DATETIME NULL,
  ACT_THIS_PER_WORK_COST  REAL NULL,
  ACT_THIS_PER_WORK_QTY  REAL NULL,
  ACT_THIS_PER_EQUIP_COST  REAL NULL,
  ACT_THIS_PER_EQUIP_QTY  REAL NULL,
  BASE_MAT_COST  REAL NULL,
  REMAIN_MAT_COST  REAL NULL,
  ACT_MAT_COST  REAL NULL,
  ACT_THIS_PER_MAT_COST  REAL NULL,
  SPREAD_DATA  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_tasksum PRIMARY KEY (task_sum_id))
/

--METADATA NAME:TASKSUMFIN TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKSUMFIN(
  TASK_SUM_FIN_ID  INTEGER NOT NULL,
  FIN_DATES_ID  INTEGER NOT NULL,
  WBS_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  TASK_SUM_ID  INTEGER NOT NULL,
  ACT_WORK_QTY  REAL NULL,
  ACT_WORK_COST  REAL NULL,
  ACT_EQUIP_QTY  REAL NULL,
  ACT_EQUIP_COST  REAL NULL,
  ACT_MAT_COST  REAL NULL,
  ACT_EXPENSE_COST  REAL NULL,
  TOTAL_WORK_QTY  REAL NULL,
  TOTAL_WORK_COST  REAL NULL,
  TOTAL_EQUIP_QTY  REAL NULL,
  TOTAL_EQUIP_COST  REAL NULL,
  TOTAL_MAT_COST  REAL NULL,
  TOTAL_EXPENSE_COST  REAL NULL,
  TOTAL_COST  REAL NULL,
  ACT_COST  REAL NULL,
  BCWP  REAL NULL,
  PERFM_WORK_QTY  REAL NULL,
  ETC  REAL NULL,
  ETC_WORK_QTY  REAL NULL,
  EAC  REAL NULL,
  EAC_WORK  REAL NULL,
  BCWS  REAL NULL,
  ACWP  REAL NULL,
  SCHED_WORK_QTY  REAL NULL,
  BASE_COST  REAL NULL,
  BASE_WORK_QTY  REAL NULL,
  BASE_WORK_COST  REAL NULL,
  BASE_MAT_COST  REAL NULL,
  BASE_EQUIP_COST  REAL NULL,
  BASE_EQUIP_QTY  REAL NULL,
  BASE_EXPENSE_COST  REAL NULL,
  REMAIN_COST  REAL NULL,
  REMAIN_WORK_QTY  REAL NULL,
  REMAIN_WORK_COST  REAL NULL,
  REMAIN_MAT_COST  REAL NULL,
  REMAIN_EQUIP_COST  REAL NULL,
  REMAIN_EQUIP_QTY  REAL NULL,
  REMAIN_EXPENSE_COST  REAL NULL,
  TARGET_COST  REAL NULL,
  TARGET_EQUIP_COST  REAL NULL,
  TARGET_EQUIP_QTY  REAL NULL,
  TARGET_EXPENSE_COST  REAL NULL,
  TARGET_MAT_COST  REAL NULL,
  TARGET_WORK_COST  REAL NULL,
  TARGET_WORK_QTY  REAL NULL,
  LATE_REMAIN_WORK_QTY  REAL NULL,
  LATE_REMAIN_WORK_COST  REAL NULL,
  LATE_REMAIN_EQUIP_COST  REAL NULL,
  LATE_REMAIN_EQUIP_QTY  REAL NULL,
  LATE_REMAIN_COST  REAL NULL,
  LATE_REMAIN_MAT_COST  REAL NULL,
  LATE_REMAIN_EXPENSE_COST  REAL NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_tasksumfin PRIMARY KEY (task_sum_fin_id))
/

--METADATA NAME:TASKUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKUSER(
  TASK_ID  INTEGER NOT NULL,
  USER_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_taskuser PRIMARY KEY (task_id) ,CONSTRAINT fk_taskuser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_taskuser_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_taskuser_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
)
/

--METADATA NAME:TASKWKSP TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKWKSP(
  WORKSPACE_ID  INTEGER NOT NULL,
  TASK_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  CR_EXTERNAL_KEY  VARCHAR2(4000) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_taskwksp PRIMARY KEY (workspace_id,task_id) ,CONSTRAINT fk_taskwksp_workspace FOREIGN KEY (workspace_id)
REFERENCES WORKSPACE (workspace_id) 
 ,CONSTRAINT fk_taskwksp_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ,CONSTRAINT fk_taskwksp_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
)
/

--METADATA NAME:TEMPKEYS TYPE:TABLE CHANGE:CREATE
CREATE TABLE TEMPKEYS(
  PK1  INTEGER NULL,
  PK2  INTEGER NULL
)
/

--METADATA NAME:THRSPARM TYPE:TABLE CHANGE:CREATE
CREATE TABLE THRSPARM(
  THRESH_PARM_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  WBS_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  TASK_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  RSRC_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  THRESH_PARM_TYPE  VARCHAR2(12) NOT NULL,
  THRESH_PARM_NAME  VARCHAR2(80) NOT NULL,
  THRESH_FIELD_NAME  VARCHAR2(40) NULL,
  THRESH_SHORT_NAME  VARCHAR2(80) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_thrsparm PRIMARY KEY (thresh_parm_id))
/

--METADATA NAME:TIMESHT TYPE:TABLE CHANGE:CREATE
CREATE TABLE TIMESHT(
  TS_ID  INTEGER NOT NULL,
  RSRC_ID  INTEGER NOT NULL,
  DAILY_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  STATUS_CODE  VARCHAR2(20) NOT NULL,
  USER_ID  INTEGER NULL,
  LAST_RECV_DATE  DATETIME NULL,
  STATUS_DATE  DATETIME NULL,
  TS_NOTES  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_timesht PRIMARY KEY (ts_id,rsrc_id))
/

--METADATA NAME:TMPLCATG TYPE:TABLE CHANGE:CREATE
CREATE TABLE TMPLCATG(
  TMPLCATG_CATG_ID  INTEGER NOT NULL,
  CATG_NAME  VARCHAR2(255) NOT NULL,
  PROJECT_FLAG  VARCHAR2(1) NOT NULL,
  PROCESS_FLAG  VARCHAR2(1) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_tmplcatg PRIMARY KEY (tmplcatg_catg_id))
/

--METADATA NAME:TPROJMAP TYPE:TABLE CHANGE:CREATE
CREATE TABLE TPROJMAP(
  SESSION_ID  INTEGER NOT NULL,
  CONTEXT_ID  INTEGER NOT NULL,
  SOURCE_PROJ_ID  INTEGER NOT NULL,
  TARGET_PROJ_ID  INTEGER NOT NULL,
  TARGET_WBS_ID  INTEGER NOT NULL
)
/

--METADATA NAME:TRAKVIEW TYPE:TABLE CHANGE:CREATE
CREATE TABLE TRAKVIEW(
  TRACK_VIEW_ID  INTEGER NOT NULL,
  DISPLAY_TYPE  VARCHAR2(12) NOT NULL,
  TRACK_VIEW_NAME  VARCHAR2(80) NOT NULL,
  WEB_VIEW_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  USER_ID  INTEGER NULL,
  TRACK_VIEW_DATA  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_trakview PRIMARY KEY (track_view_id) ,CONSTRAINT fk_trakview_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:TRSRCFIN TYPE:TABLE CHANGE:CREATE
CREATE TABLE TRSRCFIN(
  FIN_DATES_ID  INTEGER NOT NULL,
  TASKRSRC_ID  INTEGER NOT NULL,
  TASK_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  ACT_QTY  REAL NULL,
  ACT_COST  REAL NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_trsrcfin PRIMARY KEY (fin_dates_id,taskrsrc_id) ,CONSTRAINT fk_trsrcfin_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_trsrcfin_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ,CONSTRAINT fk_trsrcfin_taskrsrc FOREIGN KEY (taskrsrc_id)
REFERENCES TASKRSRC (taskrsrc_id) 
 ,CONSTRAINT fk_trsrcfin_findates FOREIGN KEY (fin_dates_id)
REFERENCES FINDATES (fin_dates_id) 
)
/

--METADATA NAME:TRSRCSUM TYPE:TABLE CHANGE:CREATE
CREATE TABLE TRSRCSUM(
  TASKRSRC_SUM_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NULL,
  RSRC_ID  INTEGER NULL,
  ROLE_ID  INTEGER NULL,
  SKILL_LEVEL  INTEGER NULL,
  OVERALLOC_DATE  DATETIME NULL,
  SPREAD_DATA  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_trsrcsum PRIMARY KEY (taskrsrc_sum_id))
/

--METADATA NAME:TRSRCSUMFN TYPE:TABLE CHANGE:CREATE
CREATE TABLE TRSRCSUMFN(
  TRSRC_SUM_FIN_ID  INTEGER NOT NULL,
  FIN_DATES_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NULL,
  RSRC_ID  INTEGER NULL,
  ROLE_ID  INTEGER NULL,
  TASKRSRC_SUM_ID  INTEGER NOT NULL,
  ACT_QTY  REAL NULL,
  ACT_COST  REAL NULL,
  ACT_OT_QTY  REAL NULL,
  ACT_REG_QTY  REAL NULL,
  ACT_OT_COST  REAL NULL,
  ACT_REG_COST  REAL NULL,
  TOTAL_QTY  REAL NULL,
  TOTAL_COST  REAL NULL,
  REMAIN_QTY  REAL NULL,
  REMAIN_COST  REAL NULL,
  TARGET_QTY  REAL NULL,
  TARGET_COST  REAL NULL,
  STAFFED_REMAIN_QTY  REAL NULL,
  UNSTAFFED_REMAIN_QTY  REAL NULL,
  STAFFED_REMAIN_COST  REAL NULL,
  UNSTAFFED_REMAIN_COST  REAL NULL,
  STAFFED_LATE_REMAIN_QTY  REAL NULL,
  UNSTAFFED_LATE_REMAIN_QTY  REAL NULL,
  STAFFED_LATE_REMAIN_COST  REAL NULL,
  UNSTAFFED_LATE_REMAIN_COST  REAL NULL,
  LATE_REMAIN_QTY  REAL NULL,
  LATE_REMAIN_COST  REAL NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_trsrcsumfn PRIMARY KEY (trsrc_sum_fin_id))
/

--METADATA NAME:TSAUDIT TYPE:TABLE CHANGE:CREATE
CREATE TABLE TSAUDIT(
  TS_AUDIT_ID  INTEGER NOT NULL,
  AUDIT_DATE  DATETIME NULL,
  RSRC_ID  INTEGER NULL,
  RSRC_SHORT_NAME  VARCHAR2(255) NULL,
  RSRC_NAME  VARCHAR2(255) NULL,
  TS_STATUS_CODE  VARCHAR2(20) NULL,
  REG_HRS  REAL NULL,
  REG_OT_HRS  REAL NULL,
  PEND_REG_HRS  REAL NULL,
  PEND_REG_OT_HRS  REAL NULL,
  OH_HRS  REAL NULL,
  OH_OT_HRS  REAL NULL,
  PEND_OH_HRS  REAL NULL,
  PEND_OH_OT_HRS  REAL NULL,
  TS_ID  INTEGER NULL,
  TS_START_DATE  DATETIME NULL,
  TS_END_DATE  DATETIME NULL,
  PROJ_ID  INTEGER NULL,
  PROJ_SHORT_NAME  VARCHAR2(40) NULL,
  TS_TASK_STATUS  VARCHAR2(20) NULL,
  USER_ID  INTEGER NULL,
  USER_NAME  VARCHAR2(255) NULL,
  APPROVING_AS  VARCHAR2(50) NULL
,CONSTRAINT pk_tsaudit PRIMARY KEY (ts_audit_id))
/

--METADATA NAME:TSDATES TYPE:TABLE CHANGE:CREATE
CREATE TABLE TSDATES(
  TS_ID  INTEGER NOT NULL,
  START_DATE  DATETIME NOT NULL,
  END_DATE  DATETIME NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_tsdates PRIMARY KEY (ts_id))
/

--METADATA NAME:TSDELEGATE TYPE:TABLE CHANGE:CREATE
CREATE TABLE TSDELEGATE(
  TS_DELEGATE_ID  INTEGER NOT NULL,
  USER_ID  INTEGER NOT NULL,
  TS_DELEGATE_USER_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NULL,
  ACTIVE_FLAG  VARCHAR2(1) DEFAULT 'N' NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_tsdelegate PRIMARY KEY (ts_delegate_id) ,CONSTRAINT fk_tsdelegate_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
 ,CONSTRAINT fk_tsdelegate_users2 FOREIGN KEY (ts_delegate_user_id)
REFERENCES USERS (user_id) 
 ,CONSTRAINT fk_tsdelegate_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:UACCESS TYPE:TABLE CHANGE:CREATE
CREATE TABLE UACCESS(
  USER_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  ACCESS_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  WBS_ID  INTEGER NULL,
  PARENT_WBS_ID  INTEGER NULL
,CONSTRAINT pk_uaccess PRIMARY KEY (user_id,proj_id) ,CONSTRAINT fk_uaccess_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:UDFCODE TYPE:TABLE CHANGE:CREATE
CREATE TABLE UDFCODE(
  UDF_CODE_ID  INTEGER NOT NULL,
  UDF_TYPE_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  SHORT_NAME  VARCHAR2(60) NOT NULL,
  UDF_CODE_NAME  VARCHAR2(120) NOT NULL,
  PARENT_UDF_CODE_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_udfcode PRIMARY KEY (udf_code_id) ,CONSTRAINT fk_udfcode_udftype FOREIGN KEY (udf_type_id)
REFERENCES UDFTYPE (udf_type_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:UDFTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE UDFTYPE(
  UDF_TYPE_ID  INTEGER NOT NULL,
  TABLE_NAME  VARCHAR2(30) NOT NULL,
  UDF_TYPE_NAME  VARCHAR2(32) NOT NULL,
  UDF_TYPE_LABEL  VARCHAR2(40) NOT NULL,
  LOGICAL_DATA_TYPE  VARCHAR2(20) NOT NULL,
  SUPER_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  UDF_CODE_SHORT_LEN  INTEGER NULL,
  FORMULA  VARCHAR2(4000) NULL,
  INDICATOR_EXPRESSION  VARCHAR2(4000) NULL,
  DISP_DATA_FLAG  VARCHAR2(1) DEFAULT 'Y' NULL,
  DISP_INDICATOR_FLAG  VARCHAR2(1) DEFAULT 'Y' NULL,
  SUMMARY_INDICATOR_EXPRESSION  VARCHAR2(4000) NULL,
  SUMMARY_METHOD  VARCHAR2(20) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_udftype PRIMARY KEY (udf_type_id))
/

--METADATA NAME:UDFVALUE TYPE:TABLE CHANGE:CREATE
CREATE TABLE UDFVALUE(
  UDF_TYPE_ID  INTEGER NOT NULL,
  FK_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NULL,
  UDF_DATE  DATETIME NULL,
  UDF_TEXT  VARCHAR2(255) NULL,
  UDF_NUMBER  REAL NULL,
  UDF_CODE_ID  INTEGER NULL,
  TABLE_NAME  VARCHAR2(30) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_udfvalue PRIMARY KEY (udf_type_id,fk_id) ,CONSTRAINT fk_udfvalue_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_udfvalue_udftype FOREIGN KEY (udf_type_id)
REFERENCES UDFTYPE (udf_type_id) 
 ,CONSTRAINT fk_udfvalue_udfcode FOREIGN KEY (udf_code_id)
REFERENCES UDFCODE (udf_code_id) 
)
/

--METADATA NAME:UEVNTREG TYPE:TABLE CHANGE:CREATE
CREATE TABLE UEVNTREG(
  USER_ID  INTEGER NOT NULL,
  APP_NAME  VARCHAR2(255) NOT NULL,
  OPERATION_NAME  VARCHAR2(255) NOT NULL,
  ACTION_NAME  VARCHAR2(255) NOT NULL,
  ACTION_LEVEL  INTEGER NULL,
  USER_NAME  VARCHAR2(255) NULL,
  EVENT_REG_DATA  VARCHAR2(4000) NULL
,CONSTRAINT pk_uevntreg PRIMARY KEY (user_id,app_name,operation_name,action_name) ,CONSTRAINT fk_uevntreg_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:UMEASURE TYPE:TABLE CHANGE:CREATE
CREATE TABLE UMEASURE(
  UNIT_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  UNIT_NAME  VARCHAR2(100) NOT NULL,
  UNIT_ABBREV  VARCHAR2(16) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_umeasure PRIMARY KEY (unit_id))
/

--METADATA NAME:UPKLIST TYPE:TABLE CHANGE:CREATE
CREATE TABLE UPKLIST(
  SESSION_ID  INTEGER NOT NULL,
  CONTEXT_ID  INTEGER NULL,
  PK_ID  INTEGER NOT NULL,
  PK2_ID  INTEGER NULL
 ,CONSTRAINT fk_upklist_usession FOREIGN KEY (session_id)
REFERENCES USESSION (session_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:USERCOL TYPE:TABLE CHANGE:CREATE
CREATE TABLE USERCOL(
  USER_COL_ID  INTEGER NOT NULL,
  TABLE_NAME  VARCHAR2(16) NOT NULL,
  LOGICAL_DATA_TYPE  VARCHAR2(20) NOT NULL,
  USER_COL_NAME  VARCHAR2(32) NOT NULL,
  USER_COL_LABEL  VARCHAR2(40) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_usercol PRIMARY KEY (user_col_id))
/

--METADATA NAME:USERDATA TYPE:TABLE CHANGE:CREATE
CREATE TABLE USERDATA(
  USER_DATA_ID  INTEGER NOT NULL,
  USER_ID  INTEGER NOT NULL,
  TOPIC_NAME  VARCHAR2(20) NOT NULL,
  USER_DATA  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_userdata PRIMARY KEY (user_data_id) ,CONSTRAINT fk_userdata_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:USERENG TYPE:TABLE CHANGE:CREATE
CREATE TABLE USERENG(
  USER_ENG_ID  INTEGER NOT NULL,
  USER_ID  INTEGER NOT NULL,
  DB_ENGINE_TYPE  VARCHAR2(20) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_usereng PRIMARY KEY (user_eng_id) ,CONSTRAINT fk_usereng_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:USEROBS TYPE:TABLE CHANGE:CREATE
CREATE TABLE USEROBS(
  USER_ID  INTEGER NOT NULL,
  OBS_ID  INTEGER NOT NULL,
  PROF_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_userobs PRIMARY KEY (user_id,obs_id) ,CONSTRAINT fk_userobs_obs FOREIGN KEY (obs_id)
REFERENCES OBS (obs_id) 
 ,CONSTRAINT fk_userobs_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
 ,CONSTRAINT fk_userobs_profile FOREIGN KEY (prof_id)
REFERENCES PROFILE (prof_id) 
)
/

--METADATA NAME:USEROPEN TYPE:TABLE CHANGE:CREATE
CREATE TABLE USEROPEN(
  USER_OPEN_ID  INTEGER NOT NULL,
  USER_OPEN_NAME  VARCHAR2(255) NOT NULL,
  USER_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_useropen PRIMARY KEY (user_open_id) ,CONSTRAINT fk_useropen_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:USERS TYPE:TABLE CHANGE:CREATE
CREATE TABLE USERS(
  USER_ID  INTEGER NOT NULL,
  GLOBAL_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  EMAIL_TYPE  VARCHAR2(16) DEFAULT 'ET_Internet' NOT NULL,
  USER_NAME  VARCHAR2(255) NOT NULL,
  PROF_ID  INTEGER NULL,
  CURR_ID  INTEGER DEFAULT 1 NOT NULL,
  ALL_RSRC_ACCESS_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  REPORT_USER_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  GUID  VARCHAR2(22) NULL,
  EMAIL_SRV_USER_NAME  VARCHAR2(32) NULL,
  OFFICE_PHONE  VARCHAR2(32) NULL,
  ACTUAL_NAME  VARCHAR2(255) NULL,
  EMAIL_SEND_SERVER  VARCHAR2(120) NULL,
  EMAIL_ADDR  VARCHAR2(120) NULL,
  EMAIL_SRV_PASSWD  VARCHAR2(255) NULL,
  PASSWD  VARCHAR2(255) NULL,
  NOTIFY_PREFS  VARCHAR2(255) NULL,
  NAVI_VIEW_ID  INTEGER NULL,
  OVERRIDE_NAVIVIEW_FLAG  VARCHAR2(1) NULL,
  UI_VIEW_PREF_ID  INTEGER NULL,
  CR_EXTERNAL_KEY  VARCHAR2(4000) NULL,
  CR_USER_NAME  VARCHAR2(255) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL,
  FAILED_LOGIN_ATTEMPTS_CNT  INTEGER DEFAULT 0 NULL
,CONSTRAINT pk_users PRIMARY KEY (user_id) ,CONSTRAINT fk_users_currtype FOREIGN KEY (curr_id)
REFERENCES CURRTYPE (curr_id) 
 ,CONSTRAINT fk_users_profile FOREIGN KEY (prof_id)
REFERENCES PROFILE (prof_id) 
)
/

--METADATA NAME:USERSET TYPE:TABLE CHANGE:CREATE
CREATE TABLE USERSET(
  NAMESPACE  VARCHAR2(255) NOT NULL,
  SETTING_NAME  VARCHAR2(255) NOT NULL,
  SETTING_VALUE  VARCHAR2(4000) NULL,
  USER_ID  INTEGER NOT NULL,
  USERSET_BLOB  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_userset PRIMARY KEY (namespace,setting_name,user_id) ,CONSTRAINT fk_userset_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:USERWKSP TYPE:TABLE CHANGE:CREATE
CREATE TABLE USERWKSP(
  USER_ID  INTEGER NOT NULL,
  WORKSPACE_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_userwksp PRIMARY KEY (user_id,workspace_id) ,CONSTRAINT fk_userwksp_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
 ,CONSTRAINT fk_userwksp_workspace FOREIGN KEY (workspace_id)
REFERENCES WORKSPACE (workspace_id) 
 ,CONSTRAINT fk_userwksp_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
)
/

--METADATA NAME:USER_ACCEPTANCE_CONSENT TYPE:TABLE CHANGE:CREATE
CREATE TABLE USER_ACCEPTANCE_CONSENT(
  USER_ID  INTEGER NOT NULL,
  STATUS  INTEGER NULL,
  MODIFIED_DATE  DATETIME DEFAULT sysdate NULL,
  CONSENT_TYPE  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_user_acceptance_consent PRIMARY KEY (user_id,consent_type) ,CONSTRAINT fk_user_acpt_consent_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:USESSAUD TYPE:TABLE CHANGE:CREATE
CREATE TABLE USESSAUD(
  SESSION_ID  INTEGER NULL,
  LOGIN_DATE  DATETIME NULL,
  LOGOUT_DATE  DATETIME NULL,
  LAST_ACTIVE_TIME  DATETIME NULL,
  USER_NAME  VARCHAR2(255) NULL,
  USER_ID  INTEGER NULL,
  HOST_NAME  VARCHAR2(50) NULL,
  APP_NAME  VARCHAR2(25) NULL,
  HARD_DRIVE_CODE  VARCHAR2(40) NULL,
  DB_ENGINE_TYPE  VARCHAR2(20) NULL,
  OS_USER_NAME  VARCHAR2(255) NULL
)
/

--METADATA NAME:USESSION TYPE:TABLE CHANGE:CREATE
CREATE TABLE USESSION(
  SESSION_ID  INTEGER NOT NULL,
  LOGIN_TIME  DATETIME NOT NULL,
  LAST_ACTIVE_TIME  DATETIME NOT NULL,
  HOST_NAME  VARCHAR2(50) NOT NULL,
  USER_ID  INTEGER NULL,
  PROCESS_NUM  INTEGER NULL,
  APP_NAME  VARCHAR2(25) NULL,
  HARD_DRIVE_CODE  VARCHAR2(40) NULL,
  DB_ENGINE_TYPE  VARCHAR2(20) NULL,
  OS_USER_NAME  VARCHAR2(255) NULL,
  VDB_INSTANCE_GUID  VARCHAR2(22) NULL,
  SPID  INTEGER NULL,
  OPERATION_NAME  VARCHAR2(255) NULL,
  OPERATION_START_DATE  DATETIME NULL,
  LONG_OPERATION_FLAG  VARCHAR2(1) DEFAULT 'N' NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_usession PRIMARY KEY (session_id) ,CONSTRAINT fk_usession_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:USROPNVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE USROPNVAL(
  USER_OPEN_ID  INTEGER NOT NULL,
  PK_ID  INTEGER NOT NULL,
  USROPN_TYPE  VARCHAR2(20) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_usropnval PRIMARY KEY (user_open_id,pk_id,usropn_type) ,CONSTRAINT fk_usropnval_useropen FOREIGN KEY (user_open_id)
REFERENCES USEROPEN (user_open_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:VIEWPREF TYPE:TABLE CHANGE:CREATE
CREATE TABLE VIEWPREF(
  VIEW_PREF_ID  INTEGER NOT NULL,
  VIEW_PREF_NAME  VARCHAR2(255) NOT NULL,
  VIEW_PREF_TYPE  VARCHAR2(20) NOT NULL,
  USER_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_viewpref PRIMARY KEY (view_pref_id) ,CONSTRAINT fk_viewpref_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:VIEWPROP TYPE:TABLE CHANGE:CREATE
CREATE TABLE VIEWPROP(
  VIEW_ID  INTEGER NOT NULL,
  VIEW_NAME  VARCHAR2(40) NOT NULL,
  USER_ID  INTEGER NULL,
  PROJ_ID  INTEGER NULL,
  VIEW_TYPE  VARCHAR2(20) NULL,
  VIEW_DATA  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_viewprop PRIMARY KEY (view_id) ,CONSTRAINT fk_viewprop_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
 ,CONSTRAINT fk_viewprop_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:VWPREFDASH TYPE:TABLE CHANGE:CREATE
CREATE TABLE VWPREFDASH(
  DASHBOARD_ID  INTEGER NOT NULL,
  VIEW_PREF_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_vwprefdash PRIMARY KEY (dashboard_id,view_pref_id) ,CONSTRAINT fk_vwprefdash_dashboard FOREIGN KEY (dashboard_id)
REFERENCES DASHBOARD (dashboard_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_vwprefdash_viewpref FOREIGN KEY (view_pref_id)
REFERENCES VIEWPREF (view_pref_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:VWPREFDATA TYPE:TABLE CHANGE:CREATE
CREATE TABLE VWPREFDATA(
  VIEW_PREF_ID  INTEGER NOT NULL,
  VIEW_PREF_KEY  VARCHAR2(255) NOT NULL,
  VIEW_PREF_VALUE  VARCHAR2(4000) NULL,
  VIEW_PREF_VALUE_BLOB  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_vwprefdata PRIMARY KEY (view_pref_id,view_pref_key) ,CONSTRAINT fk_vwprefdata_viewpref FOREIGN KEY (view_pref_id)
REFERENCES VIEWPREF (view_pref_id)  ON DELETE CASCADE 
)
/

--METADATA NAME:VWPREFUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE VWPREFUSER(
  VIEW_PREF_ID  INTEGER NOT NULL,
  USER_ID  INTEGER NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_vwprefuser PRIMARY KEY (view_pref_id,user_id) ,CONSTRAINT fk_vwprefuser_viewpref FOREIGN KEY (view_pref_id)
REFERENCES VIEWPREF (view_pref_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_vwprefuser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:WBRSCAT TYPE:TABLE CHANGE:CREATE
CREATE TABLE WBRSCAT(
  WBRS_CAT_ID  INTEGER NOT NULL,
  WBRS_CAT_NAME  VARCHAR2(36) NOT NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_wbrscat PRIMARY KEY (wbrs_cat_id))
/

--METADATA NAME:WBSBUDG TYPE:TABLE CHANGE:CREATE
CREATE TABLE WBSBUDG(
  WBS_BUDG_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  WBS_ID  INTEGER NOT NULL,
  START_DATE  DATETIME NOT NULL,
  SPEND_COST  REAL NULL,
  BENEFIT_COST  REAL NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_wbsbudg PRIMARY KEY (wbs_budg_id) ,CONSTRAINT fk_wbsbudg_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_wbsbudg_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
)
/

--METADATA NAME:WBSMEMO TYPE:TABLE CHANGE:CREATE
CREATE TABLE WBSMEMO(
  WBS_MEMO_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  WBS_ID  INTEGER NOT NULL,
  MEMO_TYPE_ID  INTEGER NOT NULL,
  WBS_MEMO  BLOB NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_wbsmemo PRIMARY KEY (wbs_memo_id) ,CONSTRAINT fk_wbsmemo_memotype FOREIGN KEY (memo_type_id)
REFERENCES MEMOTYPE (memo_type_id) 
 ,CONSTRAINT fk_wbsmemo_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_wbsmemo_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
)
/

--METADATA NAME:WBSRSRC TYPE:TABLE CHANGE:CREATE
CREATE TABLE WBSRSRC(
  WBSRSRC_ID  INTEGER NOT NULL,
  WBS_ID  INTEGER NOT NULL,
  RSRC_ID  INTEGER NULL,
  PROJ_ID  INTEGER NOT NULL,
  COMMITTED_FLAG  VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  START_DATE  DATETIME NULL,
  END_DATE  DATETIME NULL,
  AUTO_COMPUTE_DATES_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  ROLE_ID  INTEGER NULL,
  RSRC_REQUEST_DATA  VARCHAR2(4000) NULL,
  ALLOCATION_PCT  REAL NULL,
  WBRS_CAT_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_wbsrsrc PRIMARY KEY (wbsrsrc_id) ,CONSTRAINT fk_wbsrsrc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_wbsrsrc_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_wbsrsrc_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
 ,CONSTRAINT fk_wbsrsrc_role FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
 ,CONSTRAINT fk_wbsrsrc_wbrscat FOREIGN KEY (wbrs_cat_id)
REFERENCES WBRSCAT (wbrs_cat_id) 
)
/

--METADATA NAME:WBSRSRC_QTY TYPE:TABLE CHANGE:CREATE
CREATE TABLE WBSRSRC_QTY(
  WBSRSRC_ID  INTEGER NOT NULL,
  WEEK_START  DATETIME NOT NULL,
  MONTH_START  DATETIME NOT NULL,
  QTY  REAL NOT NULL,
  FIN_DATES_ID1  INTEGER NULL,
  FIN_QTY1  REAL NULL,
  FIN_DATES_ID2  INTEGER NULL,
  FIN_QTY2  REAL NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_wbsrsrc_qty PRIMARY KEY (wbsrsrc_id,week_start,month_start) ,CONSTRAINT fk_wbsrsrc_qty_wbsrsrc FOREIGN KEY (wbsrsrc_id)
REFERENCES WBSRSRC (wbsrsrc_id)  ON DELETE CASCADE 
 ,CONSTRAINT fk_wbsrsrc_qty_findates1 FOREIGN KEY (fin_dates_id1)
REFERENCES FINDATES (fin_dates_id) 
 ,CONSTRAINT fk_wbsrsrc_qty_findates2 FOREIGN KEY (fin_dates_id2)
REFERENCES FINDATES (fin_dates_id) 
)
/

--METADATA NAME:WBSSTEP TYPE:TABLE CHANGE:CREATE
CREATE TABLE WBSSTEP(
  WBS_STEP_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  WBS_ID  INTEGER NOT NULL,
  SEQ_NUM  INTEGER NOT NULL,
  COMPLETE_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  STEP_NAME  VARCHAR2(120) NOT NULL,
  STEP_WT  REAL NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_wbsstep PRIMARY KEY (wbs_step_id) ,CONSTRAINT fk_wbsstep_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_wbsstep_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
)
/

--METADATA NAME:WKFLTMPL TYPE:TABLE CHANGE:CREATE
CREATE TABLE WKFLTMPL(
  WKFL_TMPL_ID  INTEGER NOT NULL,
  TEMPLATE_NAME  VARCHAR2(255) NOT NULL,
  PROJECT_FLAG  VARCHAR2(1) NOT NULL,
  WK_EXTERNAL_KEY  VARCHAR2(255) NULL,
  TMPLCATG_CATG_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_wkfltmpl PRIMARY KEY (wkfl_tmpl_id) ,CONSTRAINT fk_wkfltmpl_tmplcatg FOREIGN KEY (tmplcatg_catg_id)
REFERENCES TMPLCATG (tmplcatg_catg_id) 
)
/

--METADATA NAME:WKFLUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE WKFLUSER(
  WORK_FLOW_ID  INTEGER NOT NULL,
  USER_ID  INTEGER NOT NULL,
  STAGE_NUM  INTEGER NOT NULL,
  COMMENTS  VARCHAR2(4000) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_wkfluser PRIMARY KEY (work_flow_id,user_id,stage_num) ,CONSTRAINT fk_wkfluser_workflow FOREIGN KEY (work_flow_id)
REFERENCES WORKFLOW (work_flow_id) 
 ,CONSTRAINT ndx_wkfluser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
)
/

--METADATA NAME:WORKFLOW TYPE:TABLE CHANGE:CREATE
CREATE TABLE WORKFLOW(
  WORK_FLOW_ID  INTEGER NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  WORKFLOW_NAME  VARCHAR2(255) NOT NULL,
  EXTERNAL_KEY  VARCHAR2(512) NOT NULL,
  STAGE_NUM  INTEGER NOT NULL,
  STATUS  VARCHAR2(15) NOT NULL,
  EXISTING_PROJECT_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  STAGE_NAME  VARCHAR2(255) NOT NULL,
  STAGE_MODIFIED_FLAG  VARCHAR2(1) DEFAULT 'N' NOT NULL,
  INITIATED_DATE  DATETIME DEFAULT sysdate NOT NULL,
  WORKSPACE_ID  INTEGER NULL,
  USER_ID  INTEGER NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_workflow PRIMARY KEY (work_flow_id) ,CONSTRAINT fk_workflow_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ,CONSTRAINT fk_workflow_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
 ,CONSTRAINT fk_workflow_workspace FOREIGN KEY (workspace_id)
REFERENCES WORKSPACE (workspace_id) 
)
/

--METADATA NAME:WORKSPACE TYPE:TABLE CHANGE:CREATE
CREATE TABLE WORKSPACE(
  WORKSPACE_ID  INTEGER NOT NULL,
  WORKSPACE_TYPE  VARCHAR2(12) NOT NULL,
  PROJ_ID  INTEGER NOT NULL,
  WORKSPACE_NAME  VARCHAR2(255) NOT NULL,
  WORKSPACE_PREFS  BLOB NULL,
  CR_EXTERNAL_KEY  VARCHAR2(4000) NULL,
  UPDATE_DATE  DATETIME NULL,
  UPDATE_USER  VARCHAR2(255) NULL,
  CREATE_DATE  DATETIME NULL,
  CREATE_USER  VARCHAR2(255) NULL,
  DELETE_SESSION_ID  INTEGER NULL,
  DELETE_DATE  DATETIME NULL
,CONSTRAINT pk_workspace PRIMARY KEY (workspace_id) ,CONSTRAINT fk_workspace_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
)
/
