/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.ScriptRunner;

import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.ScriptRunner.ScriptStatement;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

public class ScriptFile {
    private static final String METADATA_TEXT = "--METADATA ";
    private static final String END_TEXT = "--END ";
    private BufferedReader reader;
    private int count = 0;
    private int statementId = 0;
    private boolean isWrapped = false;
    InputStreamFactory m_inputStreamFactory;

    public ScriptFile(InputStreamFactory factory) throws DatabaseToolException {
        this.m_inputStreamFactory = factory;
        this.parseFileInit();
    }

    public ScriptFile(URL url) throws DatabaseToolException {
        this.setUrl(url);
    }

    public ScriptFile(String filename) throws DatabaseToolException {
        try {
            this.setUrl(new File(filename).toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
    }

    public String getUrl() {
        return this.m_inputStreamFactory.getLocation();
    }

    public void setUrl(URL url) throws DatabaseToolException {
        this.m_inputStreamFactory = new UrlInputStreamFactory(url);
        this.parseFileInit();
    }

    private void parseFileInit() throws DatabaseToolException {
        try {
            String sline;
            this.open();
            this.count = 0;
            while ((sline = this.reader.readLine()) != null) {
                if (!sline.toUpperCase().startsWith(METADATA_TEXT)) continue;
                ++this.count;
            }
            this.close();
            this.open();
        }
        catch (IOException e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
    }

    private void open() throws IOException, DatabaseToolException {
        InputStream input = this.m_inputStreamFactory.createInputStream();
        if (input == null) {
            throw new DatabaseToolException("Unable to open the resource " + this.m_inputStreamFactory.getLocation());
        }
        this.reader = new BufferedReader(new InputStreamReader(input));
        this.statementId = 0;
    }

    private void close() throws DatabaseToolException {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
    }

    private boolean finishMark(String sline) {
        String check = sline.replace('\t', ' ').trim();
        if (check.compareToIgnoreCase("go") == 0) {
            return true;
        }
        return check.compareToIgnoreCase("/") == 0;
    }

    private boolean firstLine(String line) {
        String check = line.toUpperCase();
        if (check.startsWith("CREATE ") || check.startsWith("ALTER ") || check.startsWith("DROP ") || check.startsWith("SELECT ") || check.startsWith("GRANT ")) {
            this.isWrapped = check.contains("WRAPPED");
            return true;
        }
        return false;
    }

    private String stripComments(String str) {
        if (str == null) {
            return str;
        }
        int pos = str.indexOf("--");
        if (pos == -1) {
            return str + "\n";
        }
        return str.substring(0, pos) + "\n";
    }

    public ScriptStatement getNext() throws DatabaseToolException {
        ScriptStatement stmt;
        block10: {
            stmt = null;
            try {
                String sline;
                while ((sline = this.reader.readLine()) != null) {
                    if (!sline.toUpperCase().startsWith(METADATA_TEXT)) continue;
                    stmt = new ScriptStatement();
                    stmt.setMetadata(sline);
                    sline = this.stripComments(this.reader.readLine());
                    if (this.firstLine(sline) && sline.endsWith(";")) {
                        stmt.add(sline.substring(0, sline.length() - 1) + "\n");
                        break;
                    }
                    while (sline != null && !this.finishMark(sline)) {
                        String rawLine;
                        if (sline.trim().length() > 0) {
                            stmt.add(sline);
                        }
                        if ((rawLine = this.reader.readLine()) == null) {
                            if (!this.isWrapped) {
                                sline = null;
                                continue;
                            }
                            sline = "\n";
                            continue;
                        }
                        if (!rawLine.startsWith(END_TEXT)) {
                            if (!this.isWrapped) {
                                sline = this.stripComments(rawLine);
                                continue;
                            }
                            sline = rawLine;
                            continue;
                        }
                        break block10;
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw new DatabaseToolException(e.getMessage(), e);
            }
        }
        return stmt;
    }

    public int getCount() {
        return this.count;
    }

    public int getStatementId() {
        return this.statementId;
    }

    public static class UrlInputStreamFactory
    implements InputStreamFactory {
        private final URL m_url;

        public UrlInputStreamFactory(URL url) {
            this.m_url = url;
        }

        public UrlInputStreamFactory(String fileName) throws DatabaseToolException {
            this(new File(fileName));
        }

        public UrlInputStreamFactory(File file) throws DatabaseToolException {
            try {
                this.m_url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new DatabaseToolException(e.getMessage(), e);
            }
        }

        @Override
        public String getLocation() {
            return this.m_url.toString();
        }

        @Override
        public InputStream createInputStream() throws IOException {
            return this.m_url.openStream();
        }
    }

    public static interface InputStreamFactory {
        public InputStream createInputStream() throws IOException;

        public String getLocation();
    }
}

