/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common;

import com.primavera.database.common.ProductVersion;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaType;

public final class SchemaJarUtil {
    public static final String JAR_FILE_HEADER = "DBS";
    public static final String SCHEMA_WORKFLOW_FILE = "SchemaWorkflow.xml";
    public static final String SUITE_SPEC_FILE = "Suite.xml";

    private SchemaJarUtil() {
    }

    public static final String getSchemaSpecFilename(SchemaInfo schema) {
        return schema.getSchemaType().toString().toLowerCase() + "Schema.xml";
    }

    public static final String createJarFileName(SchemaType productType, ProductVersion version) {
        return "DBS_" + (Object)((Object)productType) + "_" + version.toString() + ".jar";
    }

    public static final String createDirectoryName(SchemaType productType, ProductVersion version) {
        return (Object)((Object)productType) + "_" + version.toString();
    }

    public static final String getResource(SchemaInfo schema, String dir, String fileName) {
        ProductVersion version = new ProductVersion(schema.getMajVersion(), schema.getMinVersion(), schema.getRelVersion());
        String scriptDir = dir;
        String versionDir = SchemaJarUtil.createDirectoryName(schema.getSchemaType(), version);
        if ("/".equals(dir)) {
            return fileName;
        }
        return scriptDir + "/" + versionDir + "/" + fileName;
    }

    public static final String getResourceForMigration(SchemaInfo schema, String dir, String fileName, String changeType) {
        if (changeType.equalsIgnoreCase("changeFilename")) {
            ProductVersion version = new ProductVersion(schema.getMajVersion(), schema.getMinVersion(), schema.getRelVersion());
            String scriptDir = dir;
            String versionDir = SchemaJarUtil.createDirectoryName(schema.getSchemaType(), version);
            if ("/".equals(dir)) {
                return fileName;
            }
            fileName = fileName.equalsIgnoreCase("pmSchema.xml") ? "ppmSchema.xml" : "pmSchema.xml";
            return scriptDir + "/" + versionDir + "/" + fileName;
        }
        if (changeType.equalsIgnoreCase("changeDir")) {
            ProductVersion version = new ProductVersion(schema.getMajVersion(), schema.getMinVersion(), schema.getRelVersion());
            String scriptDir = dir;
            String versionDir = SchemaJarUtil.createDirectoryName(schema.getSchemaType(), version);
            if ("/".equals(dir)) {
                return fileName;
            }
            if (versionDir.startsWith("PPM_")) {
                versionDir = versionDir.replace("PPM_", "PM_");
            } else if (versionDir.startsWith("PM_")) {
                versionDir = versionDir.replace("PM_", "PPM_");
            }
            return scriptDir + "/" + versionDir + "/" + fileName;
        }
        return null;
    }
}

