/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.workflow;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import java.util.ArrayList;
import java.util.List;

public class StepData {
    private final String m_nameKey;
    private final ConnectionClass m_connectionType;
    private String m_conditionKey = null;
    private String m_maxVersion = null;
    private final List<ParameterizedJobFactory> m_subJobs = new ArrayList<ParameterizedJobFactory>();

    public StepData(String connectionType, String nameKey) {
        this.m_nameKey = nameKey;
        ConnectionClass cc = null;
        try {
            cc = ConnectionClass.fromString(connectionType);
        }
        catch (Throwable e) {
            System.out.println(e.toString());
        }
        this.m_connectionType = cc;
    }

    public String getMaxVersion() {
        return this.m_maxVersion;
    }

    public void setMaxVersion(String version) {
        this.m_maxVersion = version;
    }

    public String getConditionKey() {
        return this.m_conditionKey;
    }

    public void setConditionKey(String conditionKey) {
        this.m_conditionKey = conditionKey;
    }

    public final String getName() {
        return StringLocalizer.get(this.m_nameKey);
    }

    public Iterable<ParameterizedJobFactory> getJobs() {
        return this.m_subJobs;
    }

    public void addJob(ParameterizedJobFactory job) {
        this.m_subJobs.add(job);
    }

    public int getJobCount() {
        return this.m_subJobs.size();
    }

    public final ConnectionClass getConnectionType() {
        return this.m_connectionType;
    }
}

