/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.util;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class DevelopmentStringLocalizer
extends StringLocalizer {
    private Properties m_stringProperties = new Properties();

    public DevelopmentStringLocalizer() {
        String baseStringLocation = "com/primavera/database/tools/dbmt/locale";
        String locale = this.getLocal();
        String stringFileName = "Strings.properties";
        String resourcePath = baseStringLocation + "/" + locale + "/" + stringFileName;
        try {
            InputStream resStream = ClassLoader.getSystemClassLoader().getResourceAsStream(resourcePath);
            try {
                this.m_stringProperties.load(resStream);
            }
            catch (Throwable th) {
                DBMTLogger.error(Channel.DEV, "Unable to process string properties from " + resourcePath);
            }
        }
        catch (Throwable th) {
            DBMTLogger.error(Channel.DEV, "Unable to find string properties at " + resourcePath);
        }
    }

    private String getLocal() {
        DBMTLogger.error(Channel.DEV, "Bypassing getLocal, returning en-US");
        return "en-US";
    }

    @Override
    public void importProperties(String propertiesFile) {
        Properties newProps = new Properties();
        InputStream resStream = ClassLoader.getSystemClassLoader().getResourceAsStream(propertiesFile);
        if (resStream == null) {
            DBMTLogger.error(Channel.DEV, "Unable to find string properties at " + propertiesFile);
            return;
        }
        try {
            newProps.load(resStream);
        }
        catch (IOException e) {
            DBMTLogger.error(Channel.DEV, "Unable to find string properties at " + propertiesFile);
            e.printStackTrace();
        }
        this.m_stringProperties.putAll((Map<?, ?>)newProps);
    }

    @Override
    public void setString(String key, String value) {
        this.m_stringProperties.setProperty(key, value);
    }

    @Override
    public String lookup(String key) throws StringLocalizer.LocalizedStringNotFound {
        String string = this.m_stringProperties.getProperty(key);
        if (string == null) {
            throw new StringLocalizer.LocalizedStringNotFound(this, key);
        }
        return string;
    }
}

