/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.util;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.DataChangedListener;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.gui.util.ComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.ValueChangedListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class ReadOnlyStringComponentBinding
extends ComponentBinding {
    JTextArea m_textArea = new JTextArea();

    public ReadOnlyStringComponentBinding(InteractorData data, String fieldId) {
        super(data, fieldId);
        this.m_textArea.setBackground(UIManager.getColor("Panel.background"));
        this.m_textArea.setEditable(false);
        this.m_textArea.setRows(1);
        this.m_textArea.setWrapStyleWord(true);
        this.m_textArea.setLineWrap(true);
        this.m_textArea.setFont(UIManager.getFont("Label.font"));
        this.m_textArea.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        data.addDataChangedListener(new DataChangedListener(){

            @Override
            public void onDataChanged(InteractorData data, String field) {
                if (ReadOnlyStringComponentBinding.this.getFieldId().equals(field)) {
                    try {
                        ReadOnlyStringComponentBinding.this.m_textArea.setText(data.getValue(ReadOnlyStringComponentBinding.this.getFieldId()));
                    }
                    catch (InteractorDataError e) {
                        DBMTLogger.error(Channel.USER, e.getLocalizedMessage());
                    }
                }
            }
        });
    }

    @Override
    public void addChangeListener(ValueChangedListener listener) {
    }

    @Override
    public String getComponentData() {
        return this.m_textArea.getText();
    }

    @Override
    public JComponent[] getComponents() {
        return new JComponent[]{this.m_textArea};
    }

    @Override
    public void setComponentData(String dataString) {
        this.m_textArea.setText(dataString);
    }
}

