/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.util;

import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.JobFailedEvent;
import com.primavera.database.common.job.JobFinishedEvent;
import com.primavera.database.common.job.JobListener;
import com.primavera.database.common.job.JobStartingEvent;
import com.primavera.database.tools.dbmt.actions.CommitPageDataDef;
import com.primavera.database.tools.dbmt.actions.JobTreeTypeDef;
import com.primavera.database.tools.dbmt.actions.TreeNode;
import com.primavera.database.tools.dbmt.actions.TreeNodeParent;
import com.primavera.database.tools.dbmt.gui.util.JobTreeRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JobTreeModel
implements TreeModel,
JobListener {
    private final JobTreeTypeDef m_jobTreeDef;
    private final Set<TreeModelListener> m_listeners = new HashSet<TreeModelListener>();
    private final Object m_root = new Object();
    private final Map<TreeNode<Job>, Object[]> m_pathMap = new HashMap<TreeNode<Job>, Object[]>();
    private final Map<TreeNode<Job>, CommitPageDataDef.JobStatus> m_statusMap = new HashMap<TreeNode<Job>, CommitPageDataDef.JobStatus>();

    public JobTreeModel(JobTreeTypeDef jobTreeDef) {
        this.m_jobTreeDef = jobTreeDef;
        this.m_pathMap.putAll(this.createPathMap(jobTreeDef));
        this.m_statusMap.putAll(this.createStatusMap(jobTreeDef));
    }

    private Map<TreeNode<Job>, CommitPageDataDef.JobStatus> createStatusMap(JobTreeTypeDef jobTreeDef) {
        HashMap<TreeNode<Job>, CommitPageDataDef.JobStatus> pathMap = new HashMap<TreeNode<Job>, CommitPageDataDef.JobStatus>();
        for (TreeNode<Job> treeNode : jobTreeDef.getTopLevel()) {
            this.recursiveAddToStatusMap(jobTreeDef, pathMap, treeNode);
        }
        return pathMap;
    }

    private void recursiveAddToStatusMap(JobTreeTypeDef jobTreeDef, Map<TreeNode<Job>, CommitPageDataDef.JobStatus> pathMap, TreeNode<Job> treeNode) {
        pathMap.put(treeNode, jobTreeDef.getStatus(treeNode.object()));
        for (TreeNode<Job> treeNode2 : treeNode.children()) {
            this.recursiveAddToStatusMap(jobTreeDef, pathMap, treeNode2);
        }
    }

    private Map<TreeNode<Job>, Object[]> createPathMap(JobTreeTypeDef jobTreeDef) {
        HashMap<TreeNode<Job>, Object[]> pathMap = new HashMap<TreeNode<Job>, Object[]>();
        for (TreeNode<Job> treeNode : jobTreeDef.getTopLevel()) {
            this.recursiveAddToJobMap(pathMap, new Object[]{this.m_root}, treeNode);
        }
        return pathMap;
    }

    private void recursiveAddToJobMap(Map<TreeNode<Job>, Object[]> pathMap, Object[] nodes, TreeNode<Job> treeNode) {
        Object[] pathToObject = new Object[nodes.length + 1];
        for (int i = 0; i < nodes.length; ++i) {
            pathToObject[i] = nodes[i];
        }
        pathToObject[nodes.length] = treeNode;
        pathMap.put(treeNode, pathToObject);
        for (TreeNode<Job> treeNode2 : treeNode.children()) {
            this.recursiveAddToJobMap(pathMap, pathToObject, treeNode2);
        }
    }

    @Override
    public synchronized void addTreeModelListener(TreeModelListener arg0) {
        this.m_listeners.add(arg0);
    }

    @Override
    public Object getChild(Object arg0, int arg1) {
        if (arg0 == this.m_root) {
            return this.m_jobTreeDef.getTopLevel().get(arg1);
        }
        if (arg0 instanceof TreeNodeParent) {
            TreeNodeParent nodeParent = (TreeNodeParent)arg0;
            return nodeParent.children().get(arg1);
        }
        return null;
    }

    @Override
    public int getChildCount(Object arg0) {
        if (arg0 == this.m_root) {
            return this.m_jobTreeDef.getTopLevel().size();
        }
        if (arg0 instanceof TreeNodeParent) {
            TreeNodeParent nodeParent = (TreeNodeParent)arg0;
            return nodeParent.children().size();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object arg0, Object arg1) {
        List<Object> children = new ArrayList();
        if (arg0 == this.m_root) {
            children = this.m_jobTreeDef.getTopLevel();
        } else if (arg0 instanceof TreeNodeParent) {
            TreeNodeParent nodeParent = (TreeNodeParent)arg0;
            children = nodeParent.children();
        }
        if (children == null) {
            return -1;
        }
        if (arg0 instanceof TreeNodeParent) {
            for (int i = 0; i < children.size(); ++i) {
                if (!arg1.equals(children.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.m_root;
    }

    @Override
    public boolean isLeaf(Object arg0) {
        if (arg0 == this.m_root) {
            return false;
        }
        if (arg0 instanceof TreeNode) {
            TreeNode job = (TreeNode)arg0;
            return job.children().isEmpty();
        }
        return true;
    }

    @Override
    public synchronized void removeTreeModelListener(TreeModelListener arg0) {
        this.m_listeners.remove(arg0);
    }

    @Override
    public void valueForPathChanged(TreePath arg0, Object arg1) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void jobFailed(JobFailedEvent evt) {
        Job job = evt.getJob();
        JobTreeTypeDef.JobNode jobNode = new JobTreeTypeDef.JobNode(job);
        Map<TreeNode<Job>, CommitPageDataDef.JobStatus> map = this.m_statusMap;
        synchronized (map) {
            this.m_statusMap.put(jobNode, CommitPageDataDef.JobStatus.FAILED);
        }
        ArrayList<TreeNode<Job>> notStartedJobs = new ArrayList<TreeNode<Job>>();
        Map<TreeNode<Job>, CommitPageDataDef.JobStatus> map2 = this.m_statusMap;
        synchronized (map2) {
            for (Map.Entry<TreeNode<Job>, CommitPageDataDef.JobStatus> entry : this.m_statusMap.entrySet()) {
                if (entry.getValue() != CommitPageDataDef.JobStatus.NOTSTART) continue;
                notStartedJobs.add(entry.getKey());
            }
            for (TreeNode treeNode : notStartedJobs) {
                this.m_statusMap.put(treeNode, CommitPageDataDef.JobStatus.ABORTED);
            }
        }
        this.refreshEntireTreeStatus();
    }

    @Override
    public void jobProgressed(int processedStatements, int totalStatements) {
        this.refreshEntireTreeStatus();
    }

    private void refreshEntireTreeStatus() {
        this.recursiveRefresh(new TreePath(new Object[]{this.getRoot()}));
    }

    private synchronized void recursiveRefresh(TreePath path) {
        int i;
        Object currentNode = path.getLastPathComponent();
        int count = this.getChildCount(currentNode);
        Object[] subPathArray = new Object[path.getPath().length + 1];
        for (i = 0; i < path.getPathCount(); ++i) {
            subPathArray[i] = path.getPath()[i];
        }
        for (i = 0; i < count; ++i) {
            subPathArray[path.getPath().length] = this.getChild(currentNode, i);
            TreePath subPath = new TreePath(subPathArray);
            for (TreeModelListener listener : this.m_listeners) {
                listener.treeNodesChanged(new TreeModelEvent((Object)this, subPath));
                this.recursiveRefresh(subPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void jobFinished(JobFinishedEvent evt) {
        Job job = evt.getJob();
        JobTreeTypeDef.JobNode jobNode = new JobTreeTypeDef.JobNode(job);
        Map<TreeNode<Job>, CommitPageDataDef.JobStatus> map = this.m_statusMap;
        synchronized (map) {
            this.m_statusMap.put(jobNode, CommitPageDataDef.JobStatus.FINISHED);
        }
        this.refreshEntireTreeStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void jobStarting(JobStartingEvent evt, boolean isIndeterminate) {
        Job job = evt.getJob();
        JobTreeTypeDef.JobNode jobNode = new JobTreeTypeDef.JobNode(job);
        Map<TreeNode<Job>, CommitPageDataDef.JobStatus> map = this.m_statusMap;
        synchronized (map) {
            this.m_statusMap.put(jobNode, CommitPageDataDef.JobStatus.RUNNING);
        }
        this.refreshEntireTreeStatus();
    }

    public TreeCellRenderer getRenderer() {
        return new JobTreeRenderer(this.m_statusMap);
    }
}

