/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.renderers;

import com.primavera.database.common.ApplicationProperties;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.DBMTPropertySets;
import com.primavera.database.tools.dbmt.gui.TypeToImageMap;
import com.primavera.database.tools.dbmt.gui.renderers.DefaultTreeNodeFormatter;
import com.primavera.database.tools.dbmt.gui.renderers.ObjectToTreeNodeLabelStringFormatter;
import com.primavera.database.tools.dbmt.util.DynamicClassFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;

public class DefaultTreeRenderer
implements TreeCellRenderer {
    private static final int SELECTION_BORDER_WIDTH = 1;
    private static final Border UNSELECTED_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private static final Border SELECTED_BORDER = BorderFactory.createLineBorder(DefaultTreeRenderer.getSelectedBorderColor(), 1);
    private static final Map<Class<?>, ObjectToTreeNodeLabelStringFormatter> s_formatterMap = new HashMap();

    private static Color getSelectedBorderColor() {
        Color titlebarColor = UIManager.getColor("InternalFrame.activeTitleBackground");
        if (titlebarColor != null) {
            return titlebarColor;
        }
        Color bgColor = UIManager.getColor("TextArea.background");
        return new Color(bgColor.getRed() - 40, bgColor.getGreen() - 40, bgColor.getBlue() - 40);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout());
        Icon icon = TypeToImageMap.getIconForObject(value);
        String label = this.getFormatter(value.getClass()).format(value);
        JLabel iconLabel = new JLabel(icon);
        JLabel textLabel = new JLabel(label);
        this.configureIconLabel(iconLabel, selected);
        this.configureTextLabel(textLabel, selected);
        panel.add((Component)iconLabel, "West");
        panel.add((Component)textLabel, "Center");
        return panel;
    }

    protected void configureIconLabel(JLabel label, boolean selected) {
    }

    protected void configureTextLabel(JLabel label, boolean selected) {
        label.setBackground(UIManager.getColor("TextArea.background"));
        label.setBorder(this.createLabelBorder(selected ? SELECTED_BORDER : UNSELECTED_BORDER));
    }

    private Border createLabelBorder(Border selectionBorder) {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 5, 1, 5), BorderFactory.createCompoundBorder(selectionBorder, BorderFactory.createEmptyBorder(2, 5, 2, 5)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ObjectToTreeNodeLabelStringFormatter getFormatter(Class<?> cls) {
        Map<Class<?>, ObjectToTreeNodeLabelStringFormatter> map = s_formatterMap;
        synchronized (map) {
            for (Class<?> next = cls; next != null; next = next.getSuperclass()) {
                if (!s_formatterMap.containsKey(cls)) continue;
                return s_formatterMap.get(cls);
            }
            s_formatterMap.put(cls, DefaultTreeRenderer.getDefaultFormatter());
            return s_formatterMap.get(cls);
        }
    }

    public static ObjectToTreeNodeLabelStringFormatter getDefaultFormatter() {
        String formatterProperty = ApplicationProperties.get(DBMTPropertySets.UI.getProps(), "dbmt.gui.tree.renderer.formatter");
        if (formatterProperty == null) {
            System.err.println("Could find property dbmt.gui.tree.renderer.formatter");
            return new DefaultTreeNodeFormatter();
        }
        String formatterClassName = formatterProperty.toString();
        Object newFormatter = null;
        try {
            newFormatter = new DynamicClassFactory().createClassFromName(formatterClassName);
        }
        catch (Throwable e) {
            System.err.println("Could not load class " + formatterClassName);
            return new DefaultTreeNodeFormatter();
        }
        if (newFormatter instanceof ObjectToTreeNodeLabelStringFormatter) {
            return (ObjectToTreeNodeLabelStringFormatter)newFormatter;
        }
        DBMTLogger.error("Specified Node Formatter Class (" + newFormatter.getClass().getName() + ") is not an instance of (" + ObjectToTreeNodeLabelStringFormatter.class.getName());
        return new DefaultTreeNodeFormatter();
    }
}

