/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.cmd;

import com.primavera.database.common.RegQuery;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.common.logging.Log;
import com.primavera.database.tools.dbmt.ActionContext;
import com.primavera.database.tools.dbmt.ActionFailed;
import com.primavera.database.tools.dbmt.ActionLogicManagerImpl;
import com.primavera.database.tools.dbmt.ActionOperation;
import com.primavera.database.tools.dbmt.Application;
import com.primavera.database.tools.dbmt.ApplicationRunner;
import com.primavera.database.tools.dbmt.InvalidDBMTCommandLine;
import com.primavera.database.tools.dbmt.actions.BaseWizardRunner;
import com.primavera.database.tools.dbmt.actions.DialogRunnerFactory;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.PasswordTypeDef;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import com.primavera.database.tools.dbmt.actions.WizardRunnerFactory;
import com.primavera.database.tools.dbmt.cmd.InitializationException;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;
import com.primavera.database.tools.dbmt.xml.util.LogFileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class CACmdLineApplicationRunner
implements ApplicationRunner {
    private final String m_actionPath = "application/installsuite";
    private Map<String, Map<String, String>> m_dataMap = new HashMap<String, Map<String, String>>();

    private void setCommandLineDefaults() {
        this.updatePageMappings("pm_install_options", "sample", "FALSE");
    }

    @Override
    public void initialize(Application app) throws InitializationException {
    }

    private void processConnectString(String connectStr) {
        String SS_ROOT_KEY = "HKLM\\SOFTWARE\\Microsoft\\Microsoft SQL Server\\";
        String SS_PORT_KEY = "MSSQLServer\\SuperSocketNetLib\\Tcp";
        String[] tokensEntireString = connectStr.split(":");
        if (tokensEntireString.length != 4 && tokensEntireString.length == 5) {
            if (tokensEntireString[1].equalsIgnoreCase("DB")) {
                String instance;
                this.updatePageMappings("operation_pm", "servertype", tokensEntireString[2]);
                String[] tokensSubString = tokensEntireString[3].split("/");
                this.updatePageMappings("connect_install_ss", "username", tokensSubString[0]);
                this.updatePageMappings("connect_upgrade_ss", "username", tokensSubString[0]);
                tokensSubString = tokensSubString[1].split("@");
                this.updatePageMappings("connect_install_ss", "password", tokensSubString[0]);
                this.updatePageMappings("connect_upgrade_ss", "password", tokensSubString[0]);
                if (tokensSubString[1].contains("\\")) {
                    tokensSubString = tokensSubString[1].split("\\\\\\\\");
                    this.updatePageMappings("connect_install_ss", "host", tokensSubString[0]);
                    this.updatePageMappings("connect_upgrade_ss", "host", tokensSubString[0]);
                    instance = tokensSubString[1];
                } else {
                    this.updatePageMappings("connect_install_ss", "host", tokensSubString[1]);
                    this.updatePageMappings("connect_upgrade_ss", "host", tokensSubString[1]);
                    instance = tokensSubString[1];
                }
                this.updatePageMappings("config_ss_db", "dbname", tokensEntireString[4]);
                this.updatePageMappings("connect_upgrade_ss", "database", tokensEntireString[4]);
                if (tokensEntireString[2].equalsIgnoreCase("ss")) {
                    String keyValue = RegQuery.getKeyValue("HKLM\\SOFTWARE\\Microsoft\\Microsoft SQL Server\\" + instance + "\\" + "MSSQLServer\\SuperSocketNetLib\\Tcp", "TcpPort");
                    this.updatePageMappings("connect_install_ss", "port", keyValue);
                    this.updatePageMappings("connect_upgrade_ss", "port", keyValue);
                } else if (tokensEntireString[2].equalsIgnoreCase("asa")) {
                    this.updatePageMappings("connect_install_ss", "port", "2638");
                }
            } else if (tokensEntireString[1].equalsIgnoreCase("FILE") || tokensEntireString[1].equalsIgnoreCase("JDBC")) {
                // empty if block
            }
        }
    }

    private String getSchema(String dbtype) {
        if ("PMDB".equalsIgnoreCase(dbtype)) {
            return "pm";
        }
        if ("MMDB".equalsIgnoreCase(dbtype)) {
            return "mm";
        }
        return null;
    }

    private void updatePageMappings(String pageId, String fieldId, String value) {
        Map<String, String> pageMap = this.m_dataMap.get(pageId);
        DBMTLogger.info(Channel.DEV, "Update Page Mapping: pageId=" + pageId + " fieldId=" + fieldId + " value=" + value);
        if (pageMap == null) {
            pageMap = new HashMap<String, String>();
            this.m_dataMap.put(pageId, pageMap);
        }
        pageMap.put(fieldId, value);
    }

    private void mapArgsToPageValues(String arg) {
        String[] tokens = arg.split(":", 2);
        String command = tokens[0];
        if ("CREATE".equalsIgnoreCase(command)) {
            this.updatePageMappings("operation_pm", "operation", "INSTALL");
        } else if ("UPGRADE".equalsIgnoreCase(command)) {
            this.updatePageMappings("operation_pm", "operation", "UPGRADE");
            this.updatePageMappings("pm_upgrade_confirm", "proceed", "YES");
        } else if ("/dbtype".equalsIgnoreCase(command)) {
            this.updatePageMappings("pm_install", "schema", this.getSchema(tokens[1]));
            this.updatePageMappings("pm_upgrade", "schema", this.getSchema(tokens[1]));
        } else if ("/sourcestring".equalsIgnoreCase(command)) {
            this.processConnectString(arg);
        } else if ("/targetstring".equalsIgnoreCase(command)) {
            this.processConnectString(arg);
        } else if (!"/logfile".equalsIgnoreCase(command) && !"/verbose".equalsIgnoreCase(command)) {
            if ("/productkey".equalsIgnoreCase(command)) {
                this.updatePageMappings("operation_pm", "key", tokens[1]);
            } else if ("/sampledata".equalsIgnoreCase(command)) {
                this.updatePageMappings("pm_install_options", "sample", "TRUE");
            } else if ("/license".equalsIgnoreCase(command)) {
                this.updatePageMappings("pm_install_options", "loadlic", "true");
                this.updatePageMappings("pm_install_options", "licfile", tokens[1]);
            } else if (!"application/installsuite".equalsIgnoreCase(command)) {
                DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.ca.cmdline.invalidparameter", new String[]{command}));
                System.exit(1);
            }
        }
    }

    public static String updateDependentData(String page, String key, String currentValue, WizardInteractorData data) {
        try {
            if ("dbname".equalsIgnoreCase(key)) {
                data.getPageData("config_ss_db").setValue("logfile", SqlServerLogic.setLogFileDirectory(data.getPageData("config_ss_db").getValue("dbname"), data.getPageData("config_ss_db").getValue("logfile")));
                data.getPageData("config_ss_db").setValue("datafile", SqlServerLogic.setDataFileDirectory(data.getPageData("config_ss_db").getValue("dbname"), data.getPageData("config_ss_db").getValue("datafile")));
            }
        }
        catch (InteractorDataError e) {
            Log.info("ERROR: " + e.toString());
            e.printStackTrace();
        }
        return currentValue;
    }

    @Override
    public DialogRunnerFactory createDialogRunnerFactory() {
        return null;
    }

    @Override
    public WizardRunnerFactory createWizardRunnerFactory() {
        return new WizardRunnerFactory(){

            @Override
            public WizardRunner createWizardRunner(WizardInteractorData data, String actionPath) {
                return new CACmdLineWizardRunner(data, actionPath);
            }
        };
    }

    private static DBMTLogger.LogLevel getDevLogLevel() {
        String devLogLevelEnvValue = System.getenv("DBMT_DEV_LOG_LEVEL");
        if (devLogLevelEnvValue == null) {
            return DBMTLogger.LogLevel.WARN;
        }
        try {
            return DBMTLogger.LogLevel.valueOf(devLogLevelEnvValue.toUpperCase());
        }
        catch (Throwable e) {
            return DBMTLogger.LogLevel.WARN;
        }
    }

    @Override
    public void initializeLogging() {
        DBMTLogger.LogLevel devLogLevel = CACmdLineApplicationRunner.getDevLogLevel();
        DBMTLogger.addAppender(DBMTLogger.LOG4J_APPENDER);
        DBMTLogger.addAppender(DBMTLogger.CONSOLE_APPENDER);
        DBMTLogger.addChannel(Channel.DEV);
        DBMTLogger.addChannel(Channel.USER);
        DBMTLogger.setLogLevel(Channel.DEV, DBMTLogger.LOG4J_APPENDER, DBMTLogger.LogLevel.ERROR);
        DBMTLogger.setLogLevel(Channel.USER, DBMTLogger.LOG4J_APPENDER, DBMTLogger.LogLevel.INFO);
        DBMTLogger.setLogLevel(Channel.DEV, DBMTLogger.CONSOLE_APPENDER, devLogLevel);
        String userHome = System.getProperty("user.home");
        Log.setLogFileName(userHome + File.separatorChar + LogFileUtil.getLogFileName());
    }

    @Override
    public void processCmdLineParameters(String[] args) throws InvalidDBMTCommandLine {
        int i;
        if (args.length == 0) {
            throw new InvalidDBMTCommandLine();
        }
        String cmdline = "";
        for (i = 0; i < args.length; ++i) {
            cmdline = cmdline + args[i] + " ";
        }
        DBMTLogger.info(Channel.DEV, "Command line=" + cmdline);
        this.setCommandLineDefaults();
        for (i = 0; i < args.length; ++i) {
            this.mapArgsToPageValues(args[i]);
        }
    }

    @Override
    public void start(Application app) {
        ActionOperation actionOp = ActionLogicManagerImpl.inst().findAction("application/installsuite");
        DBMTLogger.info("Action Operation is " + actionOp.getClass().getSimpleName());
        actionOp.contextLogic().resetFromContext(new ActionContext(app));
        try {
            actionOp.perform();
        }
        catch (ActionFailed e) {
            e.printStackTrace();
        }
    }

    private class CACmdLineWizardRunner
    extends BaseWizardRunner {
        public CACmdLineWizardRunner(WizardInteractorData wizardData, String actionPath) {
            super(wizardData, actionPath);
            DBMTLogger.info("Starting to run wizard in commandline mode");
        }

        @Override
        public boolean commitAsync() {
            return false;
        }

        @Override
        protected boolean performWizardAction() {
            JobProperties jobProps = new JobProperties();
            try {
                Log.info("Calling Perform Action");
                String pageId = this.getData().getStart();
                DBMTLogger.info("Start Page = " + pageId);
                while (!this.getData().canFinish(pageId)) {
                    String error;
                    this.pushPage(pageId);
                    this.getAction().preparePage(this, this.getData(), jobProps, pageId);
                    Map parameterMap = (Map)CACmdLineApplicationRunner.this.m_dataMap.get(pageId);
                    InteractorData data = this.getData().getPageData(pageId);
                    if (parameterMap != null) {
                        for (Map.Entry entry : parameterMap.entrySet()) {
                            String value = (String)entry.getValue();
                            if (data.getDef().getTypeDef((String)entry.getKey()).getValueClass() == PasswordTypeDef.inst().getValueClass()) {
                                value = "*********";
                            }
                            DBMTLogger.info("Setting Value for " + (String)entry.getKey() + " to " + value);
                            data.setValue((String)entry.getKey(), (String)entry.getValue());
                            CACmdLineApplicationRunner.updateDependentData(pageId, (String)entry.getKey(), (String)entry.getValue(), this.getData());
                        }
                    }
                    String prevPageId = pageId;
                    String procError = this.getAction().postProcess(this, this.getData(), jobProps, pageId);
                    if (procError != null) {
                        Log.info(procError);
                        throw new RuntimeException("Leave Page Failed: " + procError);
                    }
                    pageId = this.getData().getNextPage(pageId);
                    Log.info("Next Page = " + pageId);
                    if (pageId == null && (error = this.getAction().tryToFinish(this, this.getData(), jobProps, prevPageId)) != null) {
                        System.err.println(error);
                        throw new RuntimeException("Finish Wizard Failed: " + error);
                    }
                    error = this.getAction().tryToLeavePage(this, this.getData(), jobProps, prevPageId, pageId);
                    if (error == null) continue;
                    Log.info(error);
                    throw new RuntimeException("Leave Page Failed: " + error);
                }
                return true;
            }
            catch (Exception e) {
                Log.info("ERROR: " + e.toString());
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public void displayMessage(String message) {
            System.err.println(message);
        }
    }
}

