/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.EnumDataEntry;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SelectTypeDef;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SetSSPrivPubuserSelectOption
implements TransitionMap.PageInitializer {
    @Override
    public String initializePage(JobProperties jobProps, WizardInteractorData data, String page) throws Exception {
        String connectionSting = jobProps.getConnection(ConnectionClass.SYSADMIN);
        ArrayList<String> usersList = new ArrayList<String>();
        usersList.addAll(this.getUserList(connectionSting));
        SelectTypeDef typeDefPriv = (SelectTypeDef)data.getPageData(page).getDef().getTypeDef("existingPriv");
        SelectTypeDef typeDefPub = (SelectTypeDef)data.getPageData(page).getDef().getTypeDef("existingPub");
        typeDefPriv.reset();
        typeDefPub.reset();
        for (String username : usersList) {
            typeDefPriv.addValue(new EnumDataEntry(username, username, username, ""));
            typeDefPub.addValue(new EnumDataEntry(username, username, username, ""));
        }
        if (typeDefPriv.getValues().size() > 0) {
            data.getPageData(page).setValue("existingPriv", typeDefPriv.getValues().get(0).getId());
            data.getPageData(page).setValue("existingPub", typeDefPub.getValues().get(0).getId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getUserList(String connectionSting) throws SQLException {
        DatabaseConnection connection = null;
        try {
            connection = new DatabaseConnection(connectionSting);
            List<String> rawList = SqlServerLogic.getDatabaseUsers(connection);
            List<String> list = this.processRawList(rawList);
            return list;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
    }

    private List<String> processRawList(List<String> rawList) {
        return rawList;
    }
}

