/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.PageInitializerHelper;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import com.primavera.database.tools.dbmt.util.TablespaceUtil;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PopulateTablespacesForCreateTransOp
implements TransitionMap.PageInitializer {
    private final ConnectionClass m_connectionStringName;
    private final TablespaceFieldMap m_map;

    public PopulateTablespacesForCreateTransOp(ConnectionClass connectionStringName, TablespaceFieldMap map) {
        this.m_connectionStringName = connectionStringName;
        this.m_map = map;
    }

    @Override
    public String initializePage(JobProperties jobProps, WizardInteractorData data, String page) throws InteractorDataError {
        String connectString;
        if (!PageInitializerHelper.isOracle(jobProps, data)) {
            return null;
        }
        HashMap<String, String> oracleTablespaceMap = new HashMap<String, String>();
        try {
            connectString = jobProps.getConnection(this.m_connectionStringName);
        }
        catch (ConnectionNotFoundException e) {
            return e.getLocalizedMessage();
        }
        oracleTablespaceMap.putAll(TablespaceUtil.getAvailableTablespaces(connectString));
        String defaultDatafileLocation = this.getDefaultDatafileLocation(connectString);
        for (Map.Entry<String, String> entry : this.m_map.getEntrySet()) {
            String tablespace = data.getValue(this.m_map.getFromPage(), entry.getKey());
            String file = (String)oracleTablespaceMap.get(tablespace.toUpperCase());
            String tbspfileLoc = PopulateTablespacesForCreateTransOp.getTablespaceFileLocation(tablespace, file, defaultDatafileLocation);
            data.getPageData(this.m_map.getToPage()).setValue(entry.getValue(), tbspfileLoc);
        }
        return null;
    }

    private static String getTablespaceFileLocation(String tableSpaceName, String tableSpaceLocation, String defaultDatafileLocation) {
        if (tableSpaceLocation == null || tableSpaceLocation.isEmpty()) {
            return defaultDatafileLocation + tableSpaceName + ".DBF";
        }
        return tableSpaceLocation;
    }

    private String getDefaultDatafileLocation(String connectString) {
        DatabaseConnection connection = null;
        try {
            connection = new DatabaseConnection(connectString);
            String string = OracleLogic.getDefaultDirectory(connection);
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getClass().getSimpleName() + ": " + e.getLocalizedMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
    }

    public static class TablespaceFieldMap {
        private final String m_fromPage;
        private final String m_toPage;
        private final Map<String, String> m_pageFieldMap = new HashMap<String, String>();

        public TablespaceFieldMap(String fromPage, String toPage) {
            this.m_fromPage = fromPage;
            this.m_toPage = toPage;
        }

        public Set<Map.Entry<String, String>> getEntrySet() {
            return this.m_pageFieldMap.entrySet();
        }

        public String getFromPage() {
            return this.m_fromPage;
        }

        public String getToPage() {
            return this.m_toPage;
        }

        public void addFieldMap(String fromField, String toField) {
            this.m_pageFieldMap.put(fromField, toField);
        }

        public String findField(String fromField) {
            return this.m_pageFieldMap.get(fromField);
        }
    }
}

