/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.PhoenixException;
import com.primavera.common.util.EntryPoint;
import com.primavera.database.PrimaveraDatabaseException;
import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.ProductVersion;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaJarUtil;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.JobFailedEvent;
import com.primavera.database.common.job.JobListenerAdaptor;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.dbmt.ActionClass;
import com.primavera.database.tools.dbmt.ActionType;
import com.primavera.database.tools.dbmt.Application;
import com.primavera.database.tools.dbmt.ApplicationContextLogic;
import com.primavera.database.tools.dbmt.BaseServerInfo;
import com.primavera.database.tools.dbmt.DatabaseInfo;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.ProductInfo;
import com.primavera.database.tools.dbmt.ServerInfo;
import com.primavera.database.tools.dbmt.ServerLogic;
import com.primavera.database.tools.dbmt.ServerOperationHelper;
import com.primavera.database.tools.dbmt.actions.BaseWizardProgressor;
import com.primavera.database.tools.dbmt.actions.CommitPageProgressor;
import com.primavera.database.tools.dbmt.actions.ConditionalGenericScriptParameterSetter;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.EnumDataEntry;
import com.primavera.database.tools.dbmt.actions.FieldTable;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InstallSuitePropertyAction;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.InvalidDialogField;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.MigrateDatabasePages;
import com.primavera.database.tools.dbmt.actions.NavigationalWizardAction;
import com.primavera.database.tools.dbmt.actions.NoProductAvailable;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import com.primavera.database.tools.dbmt.actions.SSDatabasePrivPubPxrptUsersValid;
import com.primavera.database.tools.dbmt.actions.SelectTypeDef;
import com.primavera.database.tools.dbmt.actions.UpgradeSchemaIsSameAsCurrentSchema;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import com.primavera.database.tools.dbmt.dbservers.mssql.MSSqlServerInfo;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleServerInfo;
import com.primavera.database.tools.dbmt.util.TablespaceUtil;
import com.primavera.database.tools.dbmt.workflow.DatapumpJob;
import com.primavera.database.tools.dbmt.workflow.GrantRevokeJob;
import com.primavera.database.tools.dbmt.workflow.SqlScriptJob;
import com.primavera.database.tools.dbmt.workflow.ValidateJob;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class MigrateDatabaseWizardAction
extends NavigationalWizardAction<ApplicationContextLogic>
implements MigrateDatabasePages {
    public static final String DEFAULT_DATA_TABLESPACE_NAME = "_DAT";
    public static final String DEFAULT_INDEX_TABLESPACE_NAME = "_NDX";
    public static final String DEFAULT_LOB_TABLESPACE_NAME = "_LOB";
    public static final String DEFAULT_PX_TABLESPACE_NAME = "_PX_DAT";
    private static final String PARAM_NAME_SS_DATABASE_NAME = ".ss.database_name";
    private static final String PARAM_NAME_SS_DATA_PATH = ".ss.data_path";
    private static final String PARAM_NAME_SS_LOG_PATH = ".ss.log_path";
    private static final String PARAM_NAME_SS_CODEPAGE = ".ss.codepage";
    private static final String PARAM_NAME_OR_DATA_TABLESPACE = ".data_tablespace";
    private static final String PARAM_NAME_OR_DATA_PATH = ".or.data_path";
    private static final String PARAM_NAME_OR_INDEX_TABLESPACE = ".index_tablespace";
    private static final String PARAM_NAME_OR_INDEX_PATH = ".or.index_path";
    private static final String PARAM_NAME_OR_LOB_TABLESPACE = ".lob_tablespace";
    private static final String PARAM_NAME_OR_LOB_PATH = ".or.lob_path";
    private static final String PARAM_NAME_OR_PX_TABLESPACE = ".px_tablespace";
    private static final String PARAM_NAME_OR_PX_PATH = ".or.px_path";
    private static final String PARAM_NAME_OR_DATA_TABLESPACE_SIZE = ".or.data_size";
    private static final String PARAM_NAME_OR_INDEX_TABLESPACE_SIZE = ".or.index_size";
    private static final String PARAM_NAME_OR_LOB_TABLESPACE_SIZE = ".or.lob_size";
    private static final String PARAM_NAME_OR_PX_TABLESPACE_SIZE = ".or.px_size";
    private static String m_installedSchemaVersion = "";
    private static final String m_jobProperty = "";
    public static final ProductVersion m_minimumPmVersionRequiringWorkflow = new ProductVersion(6, 0, 2);
    private ProductInfo m_product;
    private ServerType m_targetServerType;
    private ServerInfo m_sourceServerInfo;
    private ServerInfo m_targetServerInfo;
    private List<SchemaInfo> m_selectedSchemas;
    private Set<DatabaseInfo> m_existingMsSqlDatabases;
    private Set<String> m_existingOracleUsers;
    private final Map<String, String> m_oracleTablespaceMap = new TreeMap<String, String>();

    public MigrateDatabaseWizardAction(ApplicationContextLogic contextLogic) {
        super(contextLogic);
        this.addPage(new SelectMigrateTypePage(this, "select_migration_type"));
        this.addPage(new SelectSourceTypePage(this, "select_pump_source"));
        this.addPage(new SelectTargetTypePage(this, "select_pump_target"));
        this.addPage(new CreateMSSqlServerConnectionPageForSource(this, "connect_source_ss"));
        this.addPage(new CreateMSSqlServerConnectionPageForTarget(this, "connect_target_ss"));
        this.addPage(new CreateOracleServerConnectionPageForSource(this, "connect_source_or"));
        this.addPage(new CreateOracleServerConnectionPageForTarget(this, "connect_target_or"));
        this.addPage(new CreateMSSqlDatabasePage(this, "config_ss_db"));
        this.addPage(new OracleTablespaceConfigurationPage(this, "config_or_tblsp"));
        this.addPage(new OracleTablespaceLocationConfigurationPage(this, "config_or_tblsp_loc"));
        this.addPage(new CommitPageProgressor<MigrateDatabaseWizardAction>(this, "create_or_database"));
        this.addPage(new OracleUsersConfigurationPage(this, "configure_or_users"));
        this.addPage(new MSSqlUsersConfigurationPage(this, "config_ss_users"));
        this.addPage(new AddMigrateDatabaseJobsPage(this, "migrate_options"));
        this.addPage(new CommitPageProgressor<MigrateDatabaseWizardAction>(this, "run_migrate_jobs"));
        this.addPage(new FinishPage(this, "finish"));
    }

    public String prepareProductInfo(WizardInteractorData data) {
        try {
            this.m_product = this.getProductInfo(((ApplicationContextLogic)this.contextLogic()).getApp());
            this.m_selectedSchemas = MigrateDatabaseWizardAction.getSelectedSchemas(this.m_product.getAllSchemas());
        }
        catch (NoProductAvailable e) {
            return e.getLocalizedMessage();
        }
        return null;
    }

    private ProductInfo getProductInfo(Application app) throws NoProductAvailable {
        ProductSuiteType productType = ProductSuiteType.PM;
        List<ProductInfo> suiteVersions = app.getSuiteInfo(productType);
        if (suiteVersions.isEmpty()) {
            throw new NoProductAvailable(productType);
        }
        return suiteVersions.get(suiteVersions.size() - 1);
    }

    private static List<SchemaInfo> getSelectedSchemas(Set<SchemaInfo> allAvailableSchemas) {
        ArrayList<SchemaType> selectedSchemaTypes = new ArrayList<SchemaType>();
        HashMap<SchemaType, SchemaInfo> schemaMap = new HashMap<SchemaType, SchemaInfo>();
        for (SchemaInfo schema : allAvailableSchemas) {
            schemaMap.put(schema.getSchemaType(), schema);
        }
        selectedSchemaTypes.add(SchemaType.PM);
        ArrayList<SchemaInfo> selectedSchemas = new ArrayList<SchemaInfo>();
        for (SchemaType schemaType : selectedSchemaTypes) {
            selectedSchemas.add((SchemaInfo)schemaMap.get((Object)schemaType));
        }
        return selectedSchemas;
    }

    private static String encryptAndEscapePassword(String value) throws PhoenixException {
        String encryptedPass = EntryPoint.b((String)value);
        StringBuffer sbuf = new StringBuffer();
        for (char ch : encryptedPass.toCharArray()) {
            sbuf.append(ch);
            if (ch != '\'') continue;
            sbuf.append('\'');
        }
        return sbuf.toString();
    }

    @Override
    public void performWizardAction(WizardInteractorData data) {
    }

    private Set<DatabaseInfo> getDatabaseInfoSet(ServerInfo serverInfo) {
        HashSet<DatabaseInfo> databases = new HashSet<DatabaseInfo>();
        ServerLogic logic = ServerOperationHelper.getServerLogic(serverInfo.getType());
        Set<DatabaseInfo> currentDatabaseSet = logic.getDatabases(serverInfo);
        for (DatabaseInfo dbInfo : currentDatabaseSet) {
            databases.add(dbInfo);
        }
        return databases;
    }

    private Properties getCreateSSDBScriptProperties(WizardInteractorData data, String pageId, String schema) throws InteractorDataError {
        schema = schema.toLowerCase();
        Properties props = new Properties();
        props.put(schema + PARAM_NAME_SS_DATABASE_NAME, data.getValue(pageId, "dbname"));
        props.put(schema + PARAM_NAME_SS_DATA_PATH, data.getValue(pageId, "datafile"));
        props.put(schema + PARAM_NAME_SS_LOG_PATH, data.getValue(pageId, "logfile"));
        props.put(schema + PARAM_NAME_SS_CODEPAGE, data.getValue(pageId, "dbcodepage").equalsIgnoreCase("DATABASE_DEFAULT") ? m_jobProperty : data.getValue(pageId, "dbcodepage"));
        if ("expadm".equals(schema)) {
            props.put("pm.ss.database_name", data.getValue(pageId, "dbname"));
            props.put("pm.ss.data_path", data.getValue(pageId, "datafile"));
            props.put("pm.ss.log_path", data.getValue(pageId, "logfile"));
            props.put("pm.ss.codepage", data.getValue(pageId, "dbcodepage").equalsIgnoreCase("DATABASE_DEFAULT") ? m_jobProperty : data.getValue(pageId, "dbcodepage"));
        }
        return props;
    }

    public String getDataTablespace(WizardInteractorData data, String page) throws InteractorDataError {
        boolean usingExisting = this.getUsingExistingTablespaces(data, page);
        if (usingExisting) {
            return data.getValue(page, "existingDatTbsp");
        }
        return data.getValue(page, "datafile");
    }

    public String getDataTablespacePath(WizardInteractorData data, String page) throws InteractorDataError {
        return data.getValue(page, "dataloc");
    }

    public String getIndexTablespacePath(WizardInteractorData data, String page) throws InteractorDataError {
        return data.getValue(page, "ndxloc");
    }

    public String getLobTablespacePath(WizardInteractorData data, String page) throws InteractorDataError {
        return data.getValue(page, "lobloc");
    }

    public String getPxTablespacePath(WizardInteractorData data, String page) throws InteractorDataError {
        return data.getValue(page, "pxloc");
    }

    public String getPxTablespace(WizardInteractorData data, String page) throws InteractorDataError {
        boolean usingExisting = this.getUsingExistingTablespaces(data, page);
        if (usingExisting) {
            return data.getValue(page, "existingPxTbsp");
        }
        return data.getValue(page, "pxfile");
    }

    public String getDataTablespaceSize(WizardInteractorData data, String page) throws InteractorDataError {
        return data.getValue(page, "datasize") + "M";
    }

    public String getIndexTablespaceSize(WizardInteractorData data, String page) throws InteractorDataError {
        return data.getValue(page, "ndxsize") + "M";
    }

    public String getLobTablespaceSize(WizardInteractorData data, String page) throws InteractorDataError {
        return data.getValue(page, "lobsize") + "M";
    }

    public String getPxTablespaceSize(WizardInteractorData data, String page) throws InteractorDataError {
        return data.getValue(page, "pxsize") + "M";
    }

    public String getLobTablespace(WizardInteractorData data, String page) throws InteractorDataError {
        boolean usingExisting = this.getUsingExistingTablespaces(data, page);
        if (usingExisting) {
            return data.getValue(page, "existingLobTbsp");
        }
        return data.getValue(page, "lobfile");
    }

    private boolean getUsingExistingTablespaces(WizardInteractorData data, String page) throws InteractorDataError {
        return data.getValue(page, "useexisting").toUpperCase().equals(Boolean.TRUE.toString().toUpperCase());
    }

    public String getIndexTablespace(WizardInteractorData data, String page) throws InteractorDataError {
        boolean usingExisting = this.getUsingExistingTablespaces(data, page);
        if (usingExisting) {
            return data.getValue(page, "existingNdxTbsp");
        }
        return data.getValue(page, "ndxfile");
    }

    private String getTablespaceLocation(String tableSpaceName, String tableSpaceLocation, DatabaseConnection dbconn) {
        if (tableSpaceLocation == null || tableSpaceLocation.isEmpty()) {
            return OracleLogic.getDefaultDirectory(dbconn) + tableSpaceName + ".DBF";
        }
        return tableSpaceLocation;
    }

    private void resetOracleTablespacesMap() {
        this.m_oracleTablespaceMap.clear();
        this.m_oracleTablespaceMap.putAll(OracleLogic.getTablespaceMap(this.m_targetServerInfo.getConnection()));
        for (String tablespaceName : this.m_oracleTablespaceMap.keySet()) {
            StringLocalizer.setAsOwnTranslation(tablespaceName);
        }
    }

    private static String getDefaultOracleUserName(Set<String> existingOracleUsers, String defaultName) {
        String normalizedName = defaultName.toLowerCase();
        if (!existingOracleUsers.contains(normalizedName)) {
            return normalizedName;
        }
        int firstTerminalDigit = normalizedName.length();
        while (Character.isDigit(normalizedName.charAt(firstTerminalDigit - 1))) {
            --firstTerminalDigit;
        }
        if (firstTerminalDigit < normalizedName.length()) {
            normalizedName = normalizedName.substring(0, firstTerminalDigit);
        }
        int appendedNumber = 1;
        String constructedName;
        while (existingOracleUsers.contains(constructedName = normalizedName + appendedNumber)) {
            ++appendedNumber;
        }
        return constructedName;
    }

    public static Object getPropertyFromJobProperties(Object key, JobProperties jobProps) {
        Object prop = null;
        try {
            prop = jobProps.getJobProperty(key);
        }
        catch (JobPropertyNotFound e) {
            DBMTLogger.warn(e.getLocalizedMessage());
        }
        return prop;
    }

    private static String getToBeInstalledVersion(SchemaInfo schema) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath currentVersionPath = factory.newXPath();
            XPathExpression currentVersionExpr = currentVersionPath.compile("/PrimaveraDatabaseSchema");
            Node currentVersionResult = (Node)currentVersionExpr.evaluate(MigrateDatabaseWizardAction.getSchemaXMLInputSource(schema), XPathConstants.NODE);
            return currentVersionResult.getAttributes().getNamedItem("VERSION").getNodeValue();
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }

    private static InputSource getSchemaXMLInputSource(SchemaInfo schema) {
        String resource = SchemaJarUtil.getResource(schema, "install", SchemaJarUtil.getSchemaSpecFilename(schema));
        InputSource in = new InputSource(new InputStreamReader(ClassLoader.getSystemResourceAsStream(resource)));
        return in;
    }

    private static class SelectTargetTypePage
    extends BaseWizardProgressor<MigrateDatabaseWizardAction> {
        public SelectTargetTypePage(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            try {
                ServerType targetServerType = this.getServerType(data);
                try {
                    if (((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo != null) {
                        ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.disconnect();
                        ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo = null;
                    }
                }
                catch (Throwable e) {
                    return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
                }
                ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerType = targetServerType;
                String migrationType = data.getValue("select_migration_type", "migrationtype");
                String sourceType = data.getValue("select_pump_source", "sourcetype");
                String targetType = data.getValue("select_pump_target", "targettype");
                if (migrationType.equals("P6") && !sourceType.equals(targetType)) {
                    throw new Exception("Database schema migration is not available for different RDBMS types. You cannot migrate between Oracle and Microsoft SQL Server. ");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                return e.getLocalizedMessage();
            }
            return null;
        }

        private ServerType getServerType(WizardInteractorData data) throws InteractorDataError {
            String serverTypeId = data.getValue("select_pump_target", "targettype");
            if (serverTypeId == null) {
                return null;
            }
            if ("OR".equals(serverTypeId)) {
                return ServerType.ORACLE;
            }
            if ("SS".equals(serverTypeId)) {
                return ServerType.SQLSERVER;
            }
            if ("ASA".equals(serverTypeId)) {
                return ServerType.SYBASE;
            }
            return null;
        }

        @Override
        public void undo(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
        }
    }

    private static class SelectSourceTypePage
    extends BaseWizardProgressor<MigrateDatabaseWizardAction> {
        public SelectSourceTypePage(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            String result = ((MigrateDatabaseWizardAction)this.getAction()).prepareProductInfo(data);
            if (result != null) {
                return result;
            }
            try {
                try {
                    if (((MigrateDatabaseWizardAction)this.getAction()).m_sourceServerInfo != null) {
                        ((MigrateDatabaseWizardAction)this.getAction()).m_sourceServerInfo.disconnect();
                        ((MigrateDatabaseWizardAction)this.getAction()).m_sourceServerInfo = null;
                    }
                }
                catch (Throwable e) {
                    return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
            }
            return null;
        }

        @Override
        public void undo(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
        }
    }

    private static class SelectMigrateTypePage
    extends BaseWizardProgressor<MigrateDatabaseWizardAction> {
        public SelectMigrateTypePage(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            return null;
        }

        @Override
        public void undo(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
        }
    }

    private static class OracleUsersConfigurationPage
    extends OracleUsersConfigurationBasePage {
        public OracleUsersConfigurationPage(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        @Override
        public void prepare(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) throws InteractorDataError {
            super.prepare(runner, data, jobProps);
            for (String fieldId : new String[]{"adm", "priv", "pub", "bgjob", "pxrpt"}) {
                String usernameField = fieldId + "user";
                data.getPageData(this.getPage()).setValue(usernameField, MigrateDatabaseWizardAction.getDefaultOracleUserName(((MigrateDatabaseWizardAction)this.getAction()).m_existingOracleUsers, data.getValue(this.getPage(), usernameField)));
            }
        }

        @Override
        protected String getSelectedDataTablespace(WizardInteractorData data) throws InteractorDataError {
            boolean useExisting = data.getValue("config_or_tblsp", "useexisting").toString().toUpperCase().equals(Boolean.TRUE.toString().toUpperCase());
            if (useExisting) {
                return data.getValue("config_or_tblsp", "existingDatTbsp");
            }
            return data.getValue("config_or_tblsp", "datafile");
        }

        protected Properties getScriptProperties(ServerType type, WizardInteractorData data, String schema) throws InteractorDataError, PhoenixException {
            Properties props = new Properties();
            schema = schema.toLowerCase();
            String page = this.getPage();
            if (type == ServerType.SQLSERVER) {
                String encryptedPrivuserPassword = MigrateDatabaseWizardAction.encryptAndEscapePassword("privuser");
                props.put(schema + ".ss.public_user", "pubuser");
                props.put(schema + ".ss.privileged_user", "privuser");
                props.put(schema + ".ss.privileged_password_encrypted", encryptedPrivuserPassword);
            } else {
                props.put(schema + ".or.administrative_user", data.getValue(page, "admuser"));
                props.put(schema + ".or.administrative_password", data.getValue(page, "admpass"));
                props.put("cr.or.user", data.getValue(page, "admuser"));
                props.put("cr.or.password", data.getValue(page, "admpass"));
                props.put(schema + ".or.privileged_user", data.getValue(page, "privuser"));
                props.put(schema + ".or.privileged_password", data.getValue(page, "privpass"));
                props.put(schema + ".or.public_user", data.getValue(page, "pubuser"));
                props.put(schema + ".or.public_password", data.getValue(page, "pubpass"));
                String encryptedPrivuserPassword = MigrateDatabaseWizardAction.encryptAndEscapePassword(data.getValue(page, "privpass"));
                props.put(schema + ".or.privileged_password_encrypted", encryptedPrivuserPassword);
                props.put(schema + ".or.bgjob_user", data.getValue(page, "bgjobuser"));
                props.put(schema + ".or.bgjob_password", data.getValue(page, "bgjobpass"));
                props.put(schema + ".or.odsplus_user", data.getValue(page, "pxrptuser"));
                props.put(schema + ".or.odsplus_password", data.getValue(page, "pxrptpass"));
            }
            return props;
        }

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            ArrayList<String> duplicateUserNames = new ArrayList<String>();
            try {
                for (String fieldId : new String[]{"admuser", "privuser", "pubuser", "bgjobuser", "pxrptuser"}) {
                    String fieldValue = data.getValue(this.getPage(), fieldId).toLowerCase();
                    if (!((MigrateDatabaseWizardAction)this.getAction()).m_existingOracleUsers.contains(fieldValue)) continue;
                    duplicateUserNames.add(fieldValue);
                }
                if (!duplicateUserNames.isEmpty()) {
                    StringBuffer sbuf = new StringBuffer((String)duplicateUserNames.get(0));
                    for (int i = 1; i < duplicateUserNames.size(); ++i) {
                        sbuf.append(", " + (String)duplicateUserNames.get(i));
                    }
                    return StringLocalizer.get("dbmt.error.install.oracle.usersexist", new String[]{((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getDatabase(), sbuf.toString()});
                }
                ServerType type = ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getType();
                jobProps.getScriptProperties().putAll((Map<?, ?>)this.getScriptProperties(type, data, "pm"));
            }
            catch (Throwable e) {
                return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
            }
            return null;
        }

        @Override
        public void undo(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
        }
    }

    private static class MSSqlUsersConfigurationPage
    extends BaseWizardProgressor<MigrateDatabaseWizardAction> {
        public MSSqlUsersConfigurationPage(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        @Override
        public void prepare(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) throws InteractorDataError {
            super.prepare(runner, data, jobProps);
            try {
                this.prepareDropdowns(data, jobProps);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.prepareSuggestedValues(data, jobProps);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void prepareSuggestedValues(WizardInteractorData data, JobProperties jobProps) throws Exception {
            HashSet<String> existingSSUsers = new HashSet<String>();
            String connectionString = null;
            try {
                connectionString = jobProps.getConnection(ConnectionClass.SYSADMIN);
            }
            catch (ConnectionNotFoundException e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
            existingSSUsers.addAll(MSSqlUsersConfigurationPage.getExistingUsers(connectionString));
            for (String[] fieldIds : new String[][]{{"privuser", "privpass"}, {"pubuser", "pubpass"}, {"pxrptuser", "pxrptpass"}}) {
                if (fieldIds == null || fieldIds.length == 0) continue;
                String value = SqlServerLogic.getDefaultSSUserName(existingSSUsers, data.getValue(this.getPage(), fieldIds[0]));
                data.getPageData(this.getPage()).setValue(fieldIds[0], value);
            }
        }

        public static List<String> getExistingUsers(String connectionString) {
            DatabaseConnection conn = null;
            try {
                conn = new DatabaseConnection(connectionString);
                List<String> list = SqlServerLogic.getDatabaseUsers(conn);
                return list;
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                    }
                }
            }
        }

        private void prepareDropdowns(WizardInteractorData data, JobProperties jobProps) throws Exception {
            String connectionSting = jobProps.getConnection(ConnectionClass.SYSADMIN);
            ArrayList<String> usersList = new ArrayList<String>();
            usersList.addAll(this.getUserList(connectionSting));
            SelectTypeDef typeDefPriv = (SelectTypeDef)data.getPageData(this.getPage()).getDef().getTypeDef("existingPriv");
            SelectTypeDef typeDefPub = (SelectTypeDef)data.getPageData(this.getPage()).getDef().getTypeDef("existingPub");
            SelectTypeDef typeDefPxrpt = (SelectTypeDef)data.getPageData(this.getPage()).getDef().getTypeDef("existingPxrpt");
            typeDefPriv.reset();
            typeDefPub.reset();
            typeDefPxrpt.reset();
            for (String username : usersList) {
                typeDefPriv.addValue(new EnumDataEntry(username, username, username, MigrateDatabaseWizardAction.m_jobProperty));
                typeDefPub.addValue(new EnumDataEntry(username, username, username, MigrateDatabaseWizardAction.m_jobProperty));
                typeDefPxrpt.addValue(new EnumDataEntry(username, username, username, MigrateDatabaseWizardAction.m_jobProperty));
            }
            if (typeDefPriv.getValues().size() > 0) {
                data.getPageData(this.getPage()).setValue("existingPriv", typeDefPriv.getValues().get(0).getId());
                data.getPageData(this.getPage()).setValue("existingPub", typeDefPub.getValues().get(0).getId());
                data.getPageData(this.getPage()).setValue("existingPxrpt", typeDefPxrpt.getValues().get(0).getId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> getUserList(String connectionSting) throws SQLException {
            DatabaseConnection connection = null;
            try {
                connection = new DatabaseConnection(connectionSting);
                List<String> rawList = SqlServerLogic.getDatabaseUsers(connection);
                List<String> list = this.processRawList(rawList);
                return list;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                    }
                }
            }
        }

        private List<String> processRawList(List<String> rawList) {
            return rawList;
        }

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            FieldTable privuserNew = this.createPrivuserNew();
            FieldTable privuserExist = this.createPrivuserExist();
            FieldTable pubuserNew = this.createPubuserNew();
            FieldTable pubuserExist = this.createPubuserExist();
            FieldTable pxrptNew = this.createPxrptuserNew();
            FieldTable pxrptExist = this.createPxrptuserExist();
            SSDatabasePrivPubPxrptUsersValid validator = new SSDatabasePrivPubPxrptUsersValid(ConnectionClass.SYSADMIN);
            ConditionalGenericScriptParameterSetter privOperation = new ConditionalGenericScriptParameterSetter("useexistingpriv", privuserExist, privuserNew);
            ConditionalGenericScriptParameterSetter pubOperation = new ConditionalGenericScriptParameterSetter("useexistingpub", pubuserExist, pubuserNew);
            ConditionalGenericScriptParameterSetter pxrptOperation = new ConditionalGenericScriptParameterSetter("useexistingpxrptuser", pxrptExist, pxrptNew);
            try {
                String errorMsg = validator.validate(data, jobProps, this.getPage());
                if (errorMsg != null) {
                    return errorMsg;
                }
                errorMsg = privOperation.process(runner, data, this.getPage(), jobProps);
                if (errorMsg != null) {
                    return errorMsg;
                }
                errorMsg = pubOperation.process(runner, data, this.getPage(), jobProps);
                if (errorMsg != null) {
                    return errorMsg;
                }
                errorMsg = pxrptOperation.process(runner, data, this.getPage(), jobProps);
                if (errorMsg != null) {
                    return errorMsg;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.toString();
            }
            return null;
        }

        private FieldTable createPrivuserNew() {
            FieldTable map = new FieldTable();
            InstallSuitePropertyAction.EncryptAndEscapeValueProc encryptAndEscape = new InstallSuitePropertyAction.EncryptAndEscapeValueProc();
            map.addParam("pm.ss.privileged_password", "privpass");
            map.addParam("pm.ss.privileged_password_encrypted", "privpass", encryptAndEscape);
            map.addParam("pm.ss.privileged_user", "privuser");
            return map;
        }

        private FieldTable createPrivuserExist() {
            FieldTable map = new FieldTable();
            InstallSuitePropertyAction.EncryptAndEscapeValueProc encryptAndEscape = new InstallSuitePropertyAction.EncryptAndEscapeValueProc();
            map.addParam("pm.ss.privileged_user", "existingPriv");
            map.addParam("pm.ss.privileged_password", "privpasslist");
            map.addParam("pm.ss.privileged_password_encrypted", "privpasslist", encryptAndEscape);
            return map;
        }

        private FieldTable createPubuserNew() {
            FieldTable map = new FieldTable();
            InstallSuitePropertyAction.EncryptAndEscapeValueProc encryptAndEscape = new InstallSuitePropertyAction.EncryptAndEscapeValueProc();
            map.addParam("pm.ss.public_password", "pubpass");
            map.addParam("pm.ss.public_password_encrypted", "pubpass", encryptAndEscape);
            map.addParam("pm.ss.public_user", "pubuser");
            return map;
        }

        private FieldTable createPubuserExist() {
            FieldTable map = new FieldTable();
            map.addParam("pm.ss.public_user", "existingPub");
            return map;
        }

        private FieldTable createPxrptuserNew() {
            FieldTable map = new FieldTable();
            map.addParam("pm.ss.odsplus_user", "pxrptuser");
            map.addParam("pm.ss.odsplus_password", "pxrptpass");
            return map;
        }

        private FieldTable createPxrptuserExist() {
            FieldTable map = new FieldTable();
            map.addParam("pm.ss.odsplus_user", "existingPxrpt");
            map.addParam("pm.ss.odsplus_password", "pxrptpass");
            return map;
        }

        @Override
        public void undo(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
        }
    }

    private static abstract class OracleUsersConfigurationBasePage
    extends BaseWizardProgressor<MigrateDatabaseWizardAction> {
        public OracleUsersConfigurationBasePage(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        @Override
        public void prepare(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) throws InteractorDataError {
            HashSet<String> temporaryTableSpaces = new HashSet<String>();
            temporaryTableSpaces.addAll(OracleLogic.getTemporaryTablespaces(((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getConnection()));
            ((MigrateDatabaseWizardAction)this.getAction()).resetOracleTablespacesMap();
            ((MigrateDatabaseWizardAction)this.getAction()).m_existingOracleUsers = OracleLogic.getExistingUsers(((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getConnection());
        }

        protected abstract String getSelectedDataTablespace(WizardInteractorData var1) throws InteractorDataError;

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            return null;
        }

        @Override
        public void undo(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
        }
    }

    private static class OracleTablespaceLocationConfigurationPage
    extends OracleTablespaceLocationConfigurationBasePage {
        public OracleTablespaceLocationConfigurationPage(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        @Override
        public void prepare(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) throws InteractorDataError {
            String datafile = ((MigrateDatabaseWizardAction)this.getAction()).getDataTablespace(data, "config_or_tblsp");
            String ndxfile = ((MigrateDatabaseWizardAction)this.getAction()).getIndexTablespace(data, "config_or_tblsp");
            String lobfile = ((MigrateDatabaseWizardAction)this.getAction()).getLobTablespace(data, "config_or_tblsp");
            String pxfile = ((MigrateDatabaseWizardAction)this.getAction()).getPxTablespace(data, "config_or_tblsp");
            String tablespaceFile = (String)((MigrateDatabaseWizardAction)this.getAction()).m_oracleTablespaceMap.get(datafile.toUpperCase());
            data.getPageData(this.getPage()).setValue("dataloc", ((MigrateDatabaseWizardAction)this.getAction()).getTablespaceLocation(datafile, tablespaceFile, ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getConnection()));
            tablespaceFile = (String)((MigrateDatabaseWizardAction)this.getAction()).m_oracleTablespaceMap.get(ndxfile.toUpperCase());
            data.getPageData(this.getPage()).setValue("ndxloc", ((MigrateDatabaseWizardAction)this.getAction()).getTablespaceLocation(ndxfile, tablespaceFile, ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getConnection()));
            tablespaceFile = (String)((MigrateDatabaseWizardAction)this.getAction()).m_oracleTablespaceMap.get(lobfile.toUpperCase());
            data.getPageData(this.getPage()).setValue("lobloc", ((MigrateDatabaseWizardAction)this.getAction()).getTablespaceLocation(lobfile, tablespaceFile, ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getConnection()));
            tablespaceFile = (String)((MigrateDatabaseWizardAction)this.getAction()).m_oracleTablespaceMap.get(pxfile.toUpperCase());
            data.getPageData(this.getPage()).setValue("pxloc", ((MigrateDatabaseWizardAction)this.getAction()).getTablespaceLocation(pxfile, tablespaceFile, ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getConnection()));
        }

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            return super.proceed(runner, data, jobProps);
        }

        @Override
        protected Properties getScriptProperties(MigrateDatabaseWizardAction action, WizardInteractorData data, String schema) throws InteractorDataError {
            Properties props = new Properties();
            schema = schema.toLowerCase();
            props.put(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_DATA_PATH, data.getValue(this.getPage(), "dataloc"));
            props.put(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_DATA_TABLESPACE, data.getValue("config_or_tblsp", "datafile"));
            props.put(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_DATA_TABLESPACE_SIZE, data.getValue("config_or_tblsp", "datasize") + "M");
            props.put(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_INDEX_PATH, data.getValue(this.getPage(), "ndxloc"));
            props.put(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_INDEX_TABLESPACE, data.getValue("config_or_tblsp", "ndxfile"));
            props.put(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_INDEX_TABLESPACE_SIZE, data.getValue("config_or_tblsp", "ndxsize") + "M");
            props.put(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_LOB_PATH, data.getValue(this.getPage(), "lobloc"));
            props.put(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_LOB_TABLESPACE, data.getValue("config_or_tblsp", "lobfile"));
            props.put(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_LOB_TABLESPACE_SIZE, data.getValue("config_or_tblsp", "lobsize") + "M");
            props.put(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_PX_PATH, data.getValue(this.getPage(), "pxloc"));
            props.put(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_PX_TABLESPACE, data.getValue("config_or_tblsp", "pxfile"));
            props.put(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_PX_TABLESPACE_SIZE, data.getValue("config_or_tblsp", "pxsize") + "M");
            props.put("temporary_tablespace", data.getValue("config_or_tblsp", "temptblsp"));
            String mainDataTablespacePath = ((MigrateDatabaseWizardAction)this.getAction()).getDataTablespacePath(data, this.getPage());
            props.put("jr.or.data_path", mainDataTablespacePath);
            props.put("jbpm.or.data_path", mainDataTablespacePath);
            String mainDataTablespaceSize = ((MigrateDatabaseWizardAction)this.getAction()).getDataTablespaceSize(data, "config_or_tblsp");
            props.put("jr.or.data_size", mainDataTablespaceSize);
            props.put("jbpm.or.data_size", mainDataTablespaceSize);
            return props;
        }

        @Override
        public void undo(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
        }
    }

    private static abstract class OracleTablespaceLocationConfigurationBasePage
    extends BaseWizardProgressor<MigrateDatabaseWizardAction> {
        public OracleTablespaceLocationConfigurationBasePage(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        @Override
        public void prepare(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) throws InteractorDataError {
        }

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            try {
                ProductInfo productInfo = ((MigrateDatabaseWizardAction)this.getAction()).m_product;
                ((MigrateDatabaseWizardAction)this.getAction()).m_selectedSchemas = MigrateDatabaseWizardAction.getSelectedSchemas(productInfo.getAllSchemas());
                jobProps.getScriptProperties().putAll((Map<?, ?>)this.getScriptProperties((MigrateDatabaseWizardAction)this.getAction(), data, "pm"));
                for (SchemaInfo info : ((MigrateDatabaseWizardAction)this.getAction()).m_selectedSchemas) {
                    ActionClass createDbActionClass = new ActionClass(ActionType.DBCREATE, ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getType());
                    ArrayList jobFactories = new ArrayList();
                    jobFactories.addAll(((ApplicationContextLogic)((MigrateDatabaseWizardAction)this.getAction()).contextLogic()).getApp().getSchemaSteps(info, createDbActionClass));
                    jobProps.setConnection(ConnectionClass.SYSADMIN, ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.createConnectString(data.getValue("connect_target_or", "password"), data.getValue("connect_target_or", "instance")));
                    for (ParameterizedJobFactory parameterizedJobFactory : jobFactories) {
                        try {
                            runner.addJob(this.getPage(), (Job)parameterizedJobFactory.createJob(jobProps));
                        }
                        catch (ValueNotFound error) {
                            return error.getLocalizedMessage();
                        }
                    }
                }
                OracleServerInfo oracleServerInfo = new OracleServerInfo("temp", data.getValue("connect_target_or", "host"), data.getValue("connect_target_or", "instance"));
                oracleServerInfo.setPort(Integer.parseInt(data.getValue("connect_target_or", "port")));
                oracleServerInfo.setUsername(data.getValue("connect_target_or", "username"));
                oracleServerInfo.setPassword(data.getValue("connect_target_or", "password"));
                oracleServerInfo.setDatabase(data.getValue("connect_target_or", "instance"));
                oracleServerInfo.setService("SERVICE".equalsIgnoreCase(data.getValue("connect_target_or", "ctype")));
                oracleServerInfo.connect(data.getValue("connect_target_or", "password"), data.getValue("connect_target_or", "instance"));
                ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo = oracleServerInfo;
            }
            catch (Throwable error) {
                return error.toString();
            }
            return null;
        }

        protected abstract Properties getScriptProperties(MigrateDatabaseWizardAction var1, WizardInteractorData var2, String var3) throws InteractorDataError;

        @Override
        public void undo(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
        }
    }

    private static class OracleTablespaceConfigurationPage
    extends BaseWizardProgressor<MigrateDatabaseWizardAction> {
        private final Map<String, String> m_fieldTablespaceMapMigrate = new HashMap<String, String>();

        public OracleTablespaceConfigurationPage(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
            this.createPMDBTablespaceMap();
        }

        private void createPMDBTablespaceMap() {
            this.m_fieldTablespaceMapMigrate.put("datafile", "DAT");
            this.m_fieldTablespaceMapMigrate.put("ndxfile", "NDX");
            this.m_fieldTablespaceMapMigrate.put("lobfile", "LOB");
            this.m_fieldTablespaceMapMigrate.put("pxfile", "PX_DAT");
        }

        @Override
        public void prepare(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) throws InteractorDataError {
            String[] tblsps = null;
            ((MigrateDatabaseWizardAction)this.getAction()).resetOracleTablespacesMap();
            HashMap<String, String> defaultTablespaceMap = new HashMap();
            if (this.getPage().equalsIgnoreCase(this.getPage())) {
                String connectString;
                String[] sPrefix = "PMDB";
                ServerType type = ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getType();
                try {
                    connectString = this.getConnectionString((MigrateDatabaseWizardAction)this.getAction(), jobProps, type);
                }
                catch (SQLException e) {
                    throw new InvalidDialogField("DB Connection");
                }
                defaultTablespaceMap = OracleTablespaceConfigurationPage.getTablespaceMigrate(connectString);
                for (Map.Entry<String, String> entry : this.m_fieldTablespaceMapMigrate.entrySet()) {
                    String targetdat1 = OracleTablespaceConfigurationPage.findTablespaceNameMigrate(defaultTablespaceMap, entry.getValue());
                    if (entry.getKey().equals("datafile")) {
                        data.getPageData(this.getPage()).setValue("datafile", targetdat1);
                        continue;
                    }
                    if (entry.getKey().equals("ndxfile")) {
                        data.getPageData(this.getPage()).setValue("ndxfile", targetdat1);
                        continue;
                    }
                    if (entry.getKey().equals("lobfile")) {
                        data.getPageData(this.getPage()).setValue("lobfile", targetdat1);
                        continue;
                    }
                    data.getPageData(this.getPage()).setValue("pxfile", targetdat1);
                }
            }
            for (String field : tblsps = new String[]{"existingDatTbsp", "existingNdxTbsp", "existingLobTbsp", "existingPxTbsp"}) {
                SelectTypeDef typeDef = (SelectTypeDef)data.getPageData(this.getPage()).getDef().getTypeDef(field);
                typeDef.reset();
                for (String tablespaceName : ((MigrateDatabaseWizardAction)this.getAction()).m_oracleTablespaceMap.keySet()) {
                    typeDef.addValue(new EnumDataEntry(tablespaceName, tablespaceName, tablespaceName, MigrateDatabaseWizardAction.m_jobProperty));
                }
                if (typeDef.getValues().size() <= 0) continue;
                String defaultTablespaceName = (String)defaultTablespaceMap.get(field);
                if (defaultTablespaceName == null) {
                    data.getPageData(this.getPage()).setValue(field, typeDef.getValues().get(0).getId());
                    continue;
                }
                boolean foundTablespace = false;
                String desiredTablespaceName = defaultTablespaceName;
                for (EnumDataEntry entry : typeDef.getValues()) {
                    if (!entry.getId().equalsIgnoreCase(desiredTablespaceName)) continue;
                    foundTablespace = true;
                    break;
                }
                if (foundTablespace) {
                    data.getPageData(this.getPage()).setValue(field, desiredTablespaceName);
                    continue;
                }
                if (typeDef.getValues().size() <= 0) continue;
                data.getPageData(this.getPage()).setValue(field, typeDef.getValues().get(0).getId());
            }
            SelectTypeDef typeDef = (SelectTypeDef)data.getPageData(this.getPage()).getDef().getTypeDef("temptblsp");
            typeDef.reset();
            HashSet<String> temporaryTableSpaces = new HashSet<String>();
            temporaryTableSpaces.addAll(TablespaceUtil.getTemporaryTablespaces(((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getConnection().getConnectionString()));
            for (String tablespaceName : temporaryTableSpaces) {
                typeDef.addValue(new EnumDataEntry(tablespaceName, tablespaceName, tablespaceName, MigrateDatabaseWizardAction.m_jobProperty));
            }
            if (typeDef.getValues().size() > 0) {
                data.getPageData(this.getPage()).setValue("temptblsp", typeDef.getValues().get(0).getId());
            }
        }

        private String getConnectionString(MigrateDatabaseWizardAction action, JobProperties jobProps, ServerType type) throws SQLException {
            if (type == ServerType.SQLSERVER) {
                return action.m_targetServerInfo.createConnectString(action.m_targetServerInfo.getPassword(), action.m_targetServerInfo.getDatabase());
            }
            OracleServerInfo serverInfo = new OracleServerInfo("temp", action.m_targetServerInfo.getHost(), action.m_targetServerInfo.getDatabase());
            serverInfo.setUsername(action.m_targetServerInfo.getUsername());
            serverInfo.setPort(action.m_targetServerInfo.getPort());
            serverInfo.setService(action.m_targetServerInfo.getService());
            return serverInfo.createConnectString(action.m_targetServerInfo.getPassword(), action.m_targetServerInfo.getDatabase());
        }

        public static Map<String, String> getTablespaceMigrate(String connectString) {
            HashMap<String, String> oracleTablespaceMapMigrate = new HashMap<String, String>();
            DatabaseConnection connection = null;
            try {
                connection = new DatabaseConnection(connectString);
                oracleTablespaceMapMigrate.putAll(OracleLogic.getTablespaceMap(connection));
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getClass().getSimpleName() + ": " + e.getLocalizedMessage());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable e) {
                        DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                    }
                }
            }
            return oracleTablespaceMapMigrate;
        }

        private static String findTablespaceNameMigrate(Map<String, String> defaultTablespaceMap, String string) {
            int numericSuffix = 1;
            String sPrefix = "PMDB";
            String targetdat = sPrefix + "_" + string + numericSuffix;
            while (defaultTablespaceMap.containsKey(targetdat)) {
                targetdat = sPrefix + "_" + string + ++numericSuffix;
            }
            return targetdat;
        }

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            String schema = "pm";
            try {
                jobProps.setJobProperty(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_DATA_TABLESPACE, data.getValue(this.getPage(), "existingDatTbsp"));
                jobProps.setJobProperty(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_INDEX_TABLESPACE, data.getValue(this.getPage(), "existingNdxTbsp"));
                jobProps.setJobProperty(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_LOB_TABLESPACE, data.getValue(this.getPage(), "existingLobTbsp"));
                jobProps.setJobProperty(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_PX_TABLESPACE, data.getValue(this.getPage(), "existingPxTbsp"));
                jobProps.setJobProperty("temporary_tablespace", data.getValue(this.getPage(), "temptblsp"));
                jobProps.getScriptProperties().put(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_DATA_TABLESPACE, data.getValue(this.getPage(), "existingDatTbsp"));
                jobProps.getScriptProperties().put(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_INDEX_TABLESPACE, data.getValue(this.getPage(), "existingNdxTbsp"));
                jobProps.getScriptProperties().put(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_LOB_TABLESPACE, data.getValue(this.getPage(), "existingLobTbsp"));
                jobProps.getScriptProperties().put(schema + MigrateDatabaseWizardAction.PARAM_NAME_OR_PX_TABLESPACE, data.getValue(this.getPage(), "existingPxTbsp"));
                jobProps.getScriptProperties().put("temporary_tablespace", data.getValue(this.getPage(), "temptblsp"));
            }
            catch (Throwable e) {
                DBMTLogger.error(Channel.USER, e.getLocalizedMessage(), e);
                return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage() + " (" + e.getMessage() + ")";
            }
            return null;
        }

        @Override
        public void undo(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
        }
    }

    private static class FinishPage
    extends BaseWizardProgressor<MigrateDatabaseWizardAction> {
        public FinishPage(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        @Override
        public void prepare(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) throws InteractorDataError {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add("description");
            data.getPageData(this.getPage()).setText(ids, jobProps);
        }

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            try {
                FinishPage.resetWizardData(data);
            }
            catch (InteractorDataError e) {
                return e.getLocalizedMessage();
            }
            return null;
        }

        @Override
        public void undo(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
        }

        private static void resetWizardData(WizardInteractorData data) throws InteractorDataError {
            data.getPageData("config_ss_db").setValue("dbname", null);
        }
    }

    private static class CreateOracleServerConnectionPageForTarget
    extends CreateServerConnectionPage {
        public CreateOracleServerConnectionPageForTarget(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        @Override
        protected ServerInfo createServer(WizardInteractorData data) throws InteractorDataError, NumberFormatException, SQLException {
            OracleServerInfo oracleServerInfo = new OracleServerInfo("temp", data.getValue(this.getPage(), "host"), data.getValue(this.getPage(), "instance"));
            oracleServerInfo.setPort(Integer.parseInt(data.getValue(this.getPage(), "port")));
            oracleServerInfo.setUsername(data.getValue(this.getPage(), "username"));
            oracleServerInfo.setPassword(data.getValue(this.getPage(), "password"));
            oracleServerInfo.setDatabase(data.getValue(this.getPage(), "instance"));
            oracleServerInfo.setService("SERVICE".equalsIgnoreCase(data.getValue(this.getPage(), "ctype")));
            oracleServerInfo.connect(data.getValue(this.getPage(), "password"), data.getValue(this.getPage(), "instance"));
            ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo = oracleServerInfo;
            return oracleServerInfo;
        }

        @Override
        protected void doPostConnectionLogic(JobProperties jobProps) throws Exception {
            ((MigrateDatabaseWizardAction)this.getAction()).m_existingOracleUsers = OracleLogic.getExistingUsers(((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getConnection());
            jobProps.setConnection(ConnectionClass.SYSADMIN, ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getConnection().getConnectionString());
        }
    }

    private static class CreateOracleServerConnectionPageForSource
    extends CreateServerConnectionPage {
        public CreateOracleServerConnectionPageForSource(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            return super.proceed(runner, data, jobProps);
        }

        protected Properties getScriptProperties() {
            Properties props = new Properties();
            props.put("pm.ss.privileged_user", "privuser");
            return props;
        }

        protected String getConnectionString(MigrateDatabaseWizardAction action, WizardInteractorData data) throws InteractorDataError, SQLException {
            String serverType = data.getValue("select_pump_source", "servertype");
            if (serverType.toUpperCase().equals("SS")) {
                return action.m_sourceServerInfo.createConnectString(action.m_sourceServerInfo.getPassword(), data.getValue("select_pump_source", "database"));
            }
            OracleServerInfo serverInfo = new OracleServerInfo("temp", action.m_sourceServerInfo.getHost(), data.getValue("select_pump_source", "database"));
            serverInfo.setUsername(data.getValue("configure_or_users", "admuser"));
            serverInfo.setService(action.m_sourceServerInfo.getService());
            return serverInfo.createConnectString(data.getValue("configure_or_users", "admuser"), data.getValue("select_pump_source", "database"));
        }

        @Override
        protected ServerInfo createServer(WizardInteractorData data) throws InteractorDataError, NumberFormatException, SQLException {
            OracleServerInfo oracleServerInfo = new OracleServerInfo("temp", data.getValue(this.getPage(), "host"), data.getValue(this.getPage(), "instance"));
            oracleServerInfo.setPort(Integer.parseInt(data.getValue(this.getPage(), "port")));
            oracleServerInfo.setUsername(data.getValue(this.getPage(), "username"));
            oracleServerInfo.setPassword(data.getValue(this.getPage(), "password"));
            oracleServerInfo.setDatabase(data.getValue(this.getPage(), "instance"));
            oracleServerInfo.setService("SERVICE".equalsIgnoreCase(data.getValue(this.getPage(), "ctype")));
            oracleServerInfo.connect(data.getValue(this.getPage(), "password"), data.getValue(this.getPage(), "instance"));
            ((MigrateDatabaseWizardAction)this.getAction()).m_sourceServerInfo = oracleServerInfo;
            return oracleServerInfo;
        }

        @Override
        protected void doPostConnectionLogic(JobProperties jobProps) throws Exception {
        }

        @Override
        public void prepare(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) throws InteractorDataError {
            data.getPageData("connect_source_or").setValue("instance", "PMDB");
            try {
                data.getPageData("connect_source_or").setValue("host", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                DBMTLogger.warn(Channel.DEV, "Unable to retrive localhost host name", e);
            }
        }
    }

    private static class CreateMSSqlServerConnectionPageForTarget
    extends CreateServerConnectionPage {
        public CreateMSSqlServerConnectionPageForTarget(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        @Override
        protected ServerInfo createServer(WizardInteractorData data) throws InteractorDataError, NumberFormatException, SQLException {
            MSSqlServerInfo sqlServerInfo = new MSSqlServerInfo("temp", data.getValue(this.getPage(), "host"));
            sqlServerInfo.setPort(Integer.parseInt(data.getValue(this.getPage(), "port")));
            sqlServerInfo.setUsername(data.getValue(this.getPage(), "username"));
            sqlServerInfo.setPassword(data.getValue(this.getPage(), "password"));
            sqlServerInfo.connect(data.getValue(this.getPage(), "password"));
            ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo = sqlServerInfo;
            return sqlServerInfo;
        }

        @Override
        protected void doPostConnectionLogic(JobProperties jobProps) throws Exception {
            ((MigrateDatabaseWizardAction)this.getAction()).m_existingMsSqlDatabases = ((MigrateDatabaseWizardAction)this.getAction()).getDatabaseInfoSet(((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo);
            jobProps.setConnection(ConnectionClass.SYSADMIN, ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getConnection().getConnectionString());
        }

        @Override
        public void prepare(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) throws InteractorDataError {
            try {
                data.getPageData("connect_target_ss").setValue("host", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                DBMTLogger.warn(Channel.DEV, "Could not get localhost host name");
            }
        }
    }

    private static class CreateMSSqlServerConnectionPageForSource
    extends CreateServerConnectionPage {
        public CreateMSSqlServerConnectionPageForSource(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            String result = super.proceed(runner, data, jobProps);
            if (result != null) {
                return result;
            }
            jobProps.setJobProperty("datasource", ((MigrateDatabaseWizardAction)this.getAction()).m_sourceServerInfo.getConnection().getConnectionString());
            return null;
        }

        protected Properties getScriptProperties() {
            Properties props = new Properties();
            props.put("pm.ss.privileged_user", "privuser");
            return props;
        }

        protected String getConnectionString(MigrateDatabaseWizardAction action, WizardInteractorData data) throws InteractorDataError, SQLException {
            String serverType = data.getValue("select_pump_source", "servertype");
            if (serverType.toUpperCase().equals("SS")) {
                return action.m_sourceServerInfo.createConnectString(action.m_sourceServerInfo.getPassword(), data.getValue("select_pump_source", "database"));
            }
            OracleServerInfo serverInfo = new OracleServerInfo("temp", action.m_sourceServerInfo.getHost(), data.getValue("select_pump_source", "database"));
            serverInfo.setService(action.m_sourceServerInfo.getService());
            serverInfo.setUsername(data.getValue("configure_or_users", "admuser"));
            return serverInfo.createConnectString(data.getValue("configure_or_users", "admuser"), data.getValue("select_pump_source", "database"));
        }

        @Override
        protected ServerInfo createServer(WizardInteractorData data) throws InteractorDataError, NumberFormatException, SQLException {
            MSSqlServerInfo sqlServerInfo = new MSSqlServerInfo("temp", data.getValue(this.getPage(), "host"));
            sqlServerInfo.setPort(Integer.parseInt(data.getValue(this.getPage(), "port")));
            sqlServerInfo.setUsername(data.getValue(this.getPage(), "username"));
            sqlServerInfo.setPassword(data.getValue(this.getPage(), "password"));
            sqlServerInfo.setDatabase(data.getValue(this.getPage(), "database"));
            sqlServerInfo.connect(data.getValue(this.getPage(), "password"));
            ((MigrateDatabaseWizardAction)this.getAction()).m_sourceServerInfo = sqlServerInfo;
            return sqlServerInfo;
        }

        @Override
        protected void doPostConnectionLogic(JobProperties jobProps) throws Exception {
            ((MigrateDatabaseWizardAction)this.getAction()).m_existingMsSqlDatabases = ((MigrateDatabaseWizardAction)this.getAction()).getDatabaseInfoSet(((MigrateDatabaseWizardAction)this.getAction()).m_sourceServerInfo);
        }
    }

    private static class CreateMSSqlDatabasePage
    extends BaseWizardProgressor<MigrateDatabaseWizardAction> {
        public CreateMSSqlDatabasePage(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        @Override
        public void prepare(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) throws InteractorDataError {
            String defaultDbName;
            String defaultDataFile = MigrateDatabaseWizardAction.m_jobProperty;
            String defaultLogFile = MigrateDatabaseWizardAction.m_jobProperty;
            SchemaType type = SchemaType.PM;
            String defaultDBNameValue = type.toString() + "DB";
            String currentDBNameValue = data.getValue("config_ss_db", "dbname");
            if (currentDBNameValue != null && MigrateDatabaseWizardAction.m_jobProperty.equals(currentDBNameValue)) {
                currentDBNameValue = defaultDBNameValue;
            }
            if ((currentDBNameValue == null || currentDBNameValue.equals(defaultDBNameValue)) && (defaultDbName = this.getDefaultDbName(type, defaultDBNameValue, data, ((MigrateDatabaseWizardAction)this.getAction()).m_existingMsSqlDatabases)) != null) {
                data.getPageData("config_ss_db").setValue("dbname", defaultDbName);
            }
            String defaultDFDir = MigrateDatabaseWizardAction.m_jobProperty;
            defaultDFDir = SqlServerLogic.getMasterFileDirectory(((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getConnection());
            defaultDataFile = defaultDFDir + "\\" + data.getPageData("config_ss_db").getValue("dbname") + "_DAT.MDF";
            defaultLogFile = defaultDFDir + "\\" + data.getPageData("config_ss_db").getValue("dbname") + "_LOG.LDF";
            data.getPageData("config_ss_db").setValue("datafile", defaultDataFile);
            data.getPageData("config_ss_db").setValue("logfile", defaultLogFile);
        }

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            try {
                String databaseName = data.getValue("config_ss_db", "dbname");
                String masterDbConnectString = ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.createConnectString(((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getPassword());
                String dbDbConnectString = ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.createConnectString(((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getPassword(), databaseName);
                for (DatabaseInfo dbInfo : ((MigrateDatabaseWizardAction)this.getAction()).m_existingMsSqlDatabases) {
                    if (!dbInfo.getName().equalsIgnoreCase(databaseName)) continue;
                    return StringLocalizer.get("dbmt.error.install.databaseexists", new String[]{databaseName});
                }
                for (SchemaInfo info : ((MigrateDatabaseWizardAction)this.getAction()).m_selectedSchemas) {
                    ActionClass createDbActionClass = new ActionClass(ActionType.DBCREATE, ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getType());
                    List<ParameterizedJobFactory<?>> createFactories = ((ApplicationContextLogic)((MigrateDatabaseWizardAction)this.getAction()).contextLogic()).getApp().getSchemaSteps(info, createDbActionClass);
                    ActionClass usersDbActionClass = new ActionClass(ActionType.DBUSERS, ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getType());
                    List<ParameterizedJobFactory<?>> userFactories = ((ApplicationContextLogic)((MigrateDatabaseWizardAction)this.getAction()).contextLogic()).getApp().getSchemaSteps(info, usersDbActionClass);
                    jobProps.getScriptProperties().putAll((Map<?, ?>)((MigrateDatabaseWizardAction)this.getAction()).getCreateSSDBScriptProperties(data, "config_ss_db", "pm"));
                    ArrayList<Job> jobs = new ArrayList<Job>();
                    jobProps.setConnection(ConnectionClass.SYSADMIN, masterDbConnectString);
                    for (ParameterizedJobFactory<?> factory : createFactories) {
                        jobs.add((Job)factory.createJob(jobProps));
                    }
                    jobProps.setConnection(ConnectionClass.SYSUSER, dbDbConnectString);
                    for (ParameterizedJobFactory<?> factory : userFactories) {
                        jobs.add((Job)factory.createJob(jobProps));
                    }
                    JobListenerAdaptor exceptionPropogator = new JobListenerAdaptor(){

                        @Override
                        public void jobFailed(JobFailedEvent evt) {
                            throw new RuntimeException(evt.toString());
                        }
                    };
                    runner.commit(exceptionPropogator, jobs, new JobWatcher());
                }
                MSSqlServerInfo sqlServerInfo = new MSSqlServerInfo("temp", ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getHost());
                sqlServerInfo.setPort(((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getPort());
                sqlServerInfo.setUsername(((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getUsername());
                sqlServerInfo.setPassword(((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getPassword());
                sqlServerInfo.setDatabase(databaseName);
                sqlServerInfo.connect(((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getPassword());
                ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo = sqlServerInfo;
            }
            catch (Throwable error) {
                return error.toString();
            }
            return null;
        }

        public String getDefaultDbName(SchemaType type, String defaultName, WizardInteractorData data, Set<DatabaseInfo> existingDatabases) {
            HashSet<String> dbNameSet = new HashSet<String>();
            for (DatabaseInfo dbInfo : existingDatabases) {
                dbNameSet.add(dbInfo.getName().toUpperCase());
            }
            if (!dbNameSet.contains(defaultName)) {
                return defaultName;
            }
            int i = 1;
            String dbNameCanidate;
            while (dbNameSet.contains(dbNameCanidate = defaultName + i)) {
                ++i;
            }
            return dbNameCanidate;
        }

        @Override
        public void undo(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
        }
    }

    private static abstract class CreateServerConnectionPage
    extends BaseWizardProgressor<MigrateDatabaseWizardAction> {
        public CreateServerConnectionPage(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        @Override
        public void prepare(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) throws InteractorDataError {
            String currentHostValue = data.getValue(this.getPage(), "host");
            if (currentHostValue != null) {
                return;
            }
            try {
                InetAddress localMachine = InetAddress.getLocalHost();
                data.getPageData(this.getPage()).setValue("host", localMachine.getHostName());
            }
            catch (UnknownHostException e) {
                DBMTLogger.warn(Channel.DEV, "Unable to get hostname?  " + e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            try {
                ServerInfo createServer = this.createServer(data);
                this.doPostConnectionLogic(jobProps);
                String migrationType = data.getValue("select_migration_type", "migrationtype");
                String currpage = this.getPage();
                if (migrationType.equals("P6") && !currpage.equals("connect_target_or") && !currpage.equals("connect_target_ss")) {
                    DatabaseConnection connection = null;
                    if (!createServer.isConnected()) {
                        createServer.createConnectString(data.getValue(this.getPage(), "password"), data.getValue(this.getPage(), "password"));
                    }
                    connection = createServer.getConnection();
                    SchemaInfo productSchema = InstallSuitePropertyAction.getProductSchema(((MigrateDatabaseWizardAction)this.getAction()).m_selectedSchemas, SchemaType.PM);
                    String versionQuery = productSchema.getVersionQuery(this.getServerType());
                    if ("SS".equalsIgnoreCase(data.getValue("select_pump_source", "sourcetype"))) {
                        versionQuery = productSchema.getVersionQuery(ServerType.SQLSERVER);
                    }
                    String currentInstalledVersion = this.getInstalledVersion(versionQuery, connection);
                    jobProps.setJobProperty(InstallSuiteOptionKeys.PRODUCT_INSTALLED_VERSION_KEY, currentInstalledVersion);
                    m_installedSchemaVersion = (String)MigrateDatabaseWizardAction.getPropertyFromJobProperties(InstallSuiteOptionKeys.PRODUCT_INSTALLED_VERSION_KEY, jobProps);
                    String toBeInstalledVersion = MigrateDatabaseWizardAction.getToBeInstalledVersion(productSchema);
                    if (!m_installedSchemaVersion.equals(toBeInstalledVersion)) {
                        throw new Exception("The version of the existing database schema is not compatible with this version of the database installer. The existing database schema version and the database installer version must be the same");
                    }
                } else if (migrationType.equals("RDBMS") && !currpage.equals("connect_target_or") && !currpage.equals("connect_target_ss")) {
                    String currentInstalledDB;
                    DatabaseConnection connection = null;
                    if (!createServer.isConnected()) {
                        createServer.createConnectString(data.getValue(this.getPage(), "password"), data.getValue(this.getPage(), "password"));
                    }
                    if ((currentInstalledDB = this.getInstalledDB(connection = createServer.getConnection())).startsWith("PPM")) {
                        throw new Exception("Please run PPM Migrate files, as the Database is PPM DB");
                    }
                }
            }
            catch (Throwable e) {
                return e.getLocalizedMessage();
            }
            return null;
        }

        private SchemaInfo getSchema(JobProperties jobProps) {
            SchemaInfo schemaInfo = null;
            SchemaType schemaType = (SchemaType)((Object)MigrateDatabaseWizardAction.getPropertyFromJobProperties(InstallSuiteOptionKeys.EXP_SCHEMA_NAME_STRING_KEY, jobProps));
            List schemas = (List)MigrateDatabaseWizardAction.getPropertyFromJobProperties(InstallSuiteOptionKeys.SCHEMA_INFO_LIST_KEY, jobProps);
            for (SchemaInfo schema : schemas) {
                if (schema == null || schema.getSchemaType() != schemaType) continue;
                schemaInfo = schema;
                break;
            }
            return schemaInfo;
        }

        private String getInstalledVersion(String versionQuery, DatabaseConnection connection) throws InteractorDataError, SQLException, PrimaveraDatabaseException {
            try (PreparedStatement stmt = null;){
                stmt = connection.getConnection().prepareStatement(versionQuery);
                stmt.execute();
                ResultSet resultSet = stmt.getResultSet();
                if (resultSet.next()) {
                    String string = resultSet.getString("VERSION");
                    return string;
                }
                throw new DatabaseToolException("Version string Not found");
            }
        }

        private String getInstalledDB(DatabaseConnection connection) throws InteractorDataError, SQLException, PrimaveraDatabaseException {
            String query = "select database_version DB from prefer";
            try (PreparedStatement stmt = null;){
                stmt = connection.getConnection().prepareStatement(query);
                stmt.execute();
                ResultSet resultSet = stmt.getResultSet();
                if (resultSet.next()) {
                    String string = resultSet.getString("DB");
                    return string;
                }
                throw new DatabaseToolException("DB string Not found");
            }
        }

        protected ServerType getServerType() {
            return ServerType.ORACLE;
        }

        protected abstract void doPostConnectionLogic(JobProperties var1) throws Exception;

        protected abstract ServerInfo createServer(WizardInteractorData var1) throws InteractorDataError, NumberFormatException, SQLException;

        @Override
        public final void undo(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
        }
    }

    private static class AddMigrateDatabaseJobsPage
    extends AddCurrentJobsPage {
        public AddMigrateDatabaseJobsPage(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        @Override
        protected Properties getJobProperties(WizardInteractorData data) throws Exception {
            Properties props = new Properties();
            props.put("sourcestring", ((MigrateDatabaseWizardAction)this.getAction()).m_sourceServerInfo.createConnectString(((MigrateDatabaseWizardAction)this.getAction()).m_sourceServerInfo.getPassword()));
            return props;
        }

        @Override
        public void prepare(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) throws InteractorDataError {
        }

        @Override
        public void addJobs(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) throws Exception {
            Properties jobNameProperties = this.getJobProperties(data);
            ServerType type = ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getType();
            String migrationType = data.getValue("select_migration_type", "migrationtype");
            String sourceType = data.getValue("select_pump_source", "sourcetype");
            if (type == ServerType.ORACLE) {
                this.addOracleUsers(jobProps.getScriptProperties(), jobNameProperties, (MigrateDatabaseWizardAction)this.getAction(), data, runner, type);
            }
            String connectString = this.getConnectionString((MigrateDatabaseWizardAction)this.getAction(), jobProps, type);
            this.addSchemaJobsToRunner(runner, data, ((MigrateDatabaseWizardAction)this.getAction()).m_selectedSchemas, this.getPage(), jobProps.getScriptProperties(), jobNameProperties, connectString, new ActionClass(ActionType.PRE_MIGRATE, ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerType), jobProps);
            this.addDatapumpJob(runner, jobProps.getScriptProperties(), jobNameProperties, connectString);
            this.addSchemaJobsToRunner(runner, data, ((MigrateDatabaseWizardAction)this.getAction()).m_selectedSchemas, this.getPage(), jobProps.getScriptProperties(), jobNameProperties, connectString, new ActionClass(ActionType.POST_MIGRATE, ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerType), jobProps);
            if (migrationType.equals("P6")) {
                if ("SS".equalsIgnoreCase(sourceType)) {
                    this.addSchemaJobsToRunner(runner, data, ((MigrateDatabaseWizardAction)this.getAction()).m_selectedSchemas, this.getPage(), jobProps.getScriptProperties(), jobNameProperties, connectString, new ActionClass(ActionType.SCHEMA_MIGRATE, ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerType), jobProps);
                    this.addGrantSsJob(runner, data, ((MigrateDatabaseWizardAction)this.getAction()).m_selectedSchemas, jobProps.getScriptProperties(), connectString);
                    this.addPrivUserJob(runner, data, ((MigrateDatabaseWizardAction)this.getAction()).m_selectedSchemas, jobProps.getScriptProperties(), connectString);
                    runner.addJob(this.getPage(), new GrantRevokeJob(jobProps, "ss_drop_pxrpt"));
                } else {
                    runner.addJob(this.getPage(), new GrantRevokeJob(jobProps, "grant"));
                    this.addSchemaJobsToRunner(runner, data, ((MigrateDatabaseWizardAction)this.getAction()).m_selectedSchemas, this.getPage(), jobProps.getScriptProperties(), jobNameProperties, connectString, new ActionClass(ActionType.SCHEMA_MIGRATE, ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerType), jobProps);
                    runner.addJob(this.getPage(), new GrantRevokeJob(jobProps, "revoke_and_drop_pxrpt"));
                }
                this.addValidateJob(runner, connectString, data, ProductSuiteType.PM);
            }
        }

        private void addGrantSsJob(WizardRunner runner, WizardInteractorData data, List<SchemaInfo> schemas, Properties scriptProps, String connectString) {
            SchemaInfo schema = null;
            for (SchemaInfo info : schemas) {
                if (!info.getSchemaType().equals((Object)SchemaType.PM)) continue;
                schema = info;
                break;
            }
            ServerType targetType = ServerType.SQLSERVER;
            String file = "ssppm_grants.sql";
            runner.addJob(this.getPage(), new SqlScriptJob(new ActionClass(ActionType.SCHEMA_MIGRATE, targetType), schema, file, null, connectString, scriptProps){

                @Override
                public String toString() {
                    return "Privuser Grant Privileges";
                }
            });
        }

        private void addPrivUserJob(WizardRunner runner, WizardInteractorData data, List<SchemaInfo> schemas, Properties scriptProps, String connectString) {
            SchemaInfo schema = null;
            for (SchemaInfo info : schemas) {
                if (!info.getSchemaType().equals((Object)SchemaType.PM)) continue;
                schema = info;
                break;
            }
            ServerType targetType = ServerType.SQLSERVER;
            String file = "ssppm_synonyms.sql";
            runner.addJob(this.getPage(), new SqlScriptJob(new ActionClass(ActionType.SCHEMA_MIGRATE, targetType), schema, file, null, connectString, scriptProps){

                @Override
                public String toString() {
                    return "Privuser Extra Views and Synonyms";
                }
            });
        }

        private void addDatapumpJob(WizardRunner runner, Properties migrateJobProps, Properties jobNameProperties, String connectString) {
            int commitRows = 1000;
            try {
                commitRows = Integer.parseInt(jobNameProperties.getProperty("dataloader.commit.rows"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            runner.addJob(this.getPage(), new DatapumpJob(jobNameProperties.getProperty("sourcestring"), connectString, commitRows));
        }

        private void addValidateJob(WizardRunner runner, String connectString, WizardInteractorData data, ProductSuiteType productType) {
            String privuser = MigrateDatabaseWizardAction.m_jobProperty;
            String pubuser = MigrateDatabaseWizardAction.m_jobProperty;
            String pxrptuser = MigrateDatabaseWizardAction.m_jobProperty;
            try {
                if (data.getValue("select_pump_target", "targettype").equals("OR")) {
                    privuser = data.getValue("configure_or_users", "privuser");
                    pubuser = data.getValue("configure_or_users", "pubuser");
                    pxrptuser = data.getValue("configure_or_users", "pxrptuser");
                } else {
                    privuser = data.getValue("config_ss_users", "privuser");
                    pubuser = data.getValue("config_ss_users", "pubuser");
                    pxrptuser = data.getValue("config_ss_users", "pxrptuser");
                }
            }
            catch (InteractorDataError interactorDataError) {
                // empty catch block
            }
            runner.addJob(this.getPage(), new ValidateJob(connectString, privuser, pubuser, pxrptuser, productType));
        }

        @Override
        protected void addOracleUsers(Properties scriptProperties, Properties jobNameProperties, MigrateDatabaseWizardAction action, WizardInteractorData data, WizardRunner runner, ServerType type) throws Exception {
            ArrayList userFactories = new ArrayList();
            for (SchemaInfo info : action.m_selectedSchemas) {
                ActionClass actionClass = new ActionClass(ActionType.DBUSERS, ((MigrateDatabaseWizardAction)this.getAction()).m_targetServerInfo.getType());
                userFactories.addAll(((ApplicationContextLogic)((MigrateDatabaseWizardAction)this.getAction()).contextLogic()).getApp().getSchemaSteps(info, actionClass));
            }
            JobProperties jobProps = new JobProperties();
            jobProps.getScriptProperties().putAll((Map<?, ?>)scriptProperties);
            jobProps.setJobProperties(jobNameProperties);
            jobProps.setConnection(ConnectionClass.SYSADMIN, this.getOracleSystemConnectionString((MigrateDatabaseWizardAction)this.getAction()));
            jobProps.setConnection(ConnectionClass.SYSUSER, this.getOracleSystemConnectionString((MigrateDatabaseWizardAction)this.getAction()));
            jobProps.setConnection(ConnectionClass.ADMINISTRATIVE, this.getOracleSystemConnectionString((MigrateDatabaseWizardAction)this.getAction()));
            jobProps.setConnection(ConnectionClass.UTILITY, this.getOracleBGJOBConnectionString((MigrateDatabaseWizardAction)this.getAction(), data));
            jobProps.setConnection(ConnectionClass.PRIVILEGED, this.getOraclePrivuserConnectionString((MigrateDatabaseWizardAction)this.getAction(), data));
            jobProps.setConnection(ConnectionClass.PUBUSER, this.getOraclePubuserConnectionString((MigrateDatabaseWizardAction)this.getAction(), data));
            for (ParameterizedJobFactory parameterizedJobFactory : userFactories) {
                runner.addJob(this.getPage(), (Job)parameterizedJobFactory.createJob(jobProps));
            }
        }

        private String getOracleBGJOBConnectionString(MigrateDatabaseWizardAction action, WizardInteractorData data) throws Exception {
            String connectionString = action.m_targetServerInfo.getConnection().getConnectionString();
            connectionString = connectionString.substring(connectionString.lastIndexOf("@"));
            connectionString = data.getValue("configure_or_users", "bgjobuser") + "/" + data.getValue("configure_or_users", "bgjobpass") + connectionString;
            return connectionString;
        }

        private String getOraclePubuserConnectionString(MigrateDatabaseWizardAction action, WizardInteractorData data) throws Exception {
            String connectionString = action.m_targetServerInfo.getConnection().getConnectionString();
            connectionString = connectionString.substring(connectionString.lastIndexOf("@"));
            connectionString = data.getValue("configure_or_users", "pubuser") + "/" + data.getValue("configure_or_users", "pubpass") + connectionString;
            return connectionString;
        }

        private String getOraclePrivuserConnectionString(MigrateDatabaseWizardAction action, WizardInteractorData data) throws Exception {
            String connectionString = action.m_targetServerInfo.getConnection().getConnectionString();
            connectionString = connectionString.substring(connectionString.lastIndexOf("@"));
            connectionString = data.getValue("configure_or_users", "privuser") + "/" + data.getValue("configure_or_users", "privpass") + connectionString;
            return connectionString;
        }

        private String getOracleSystemConnectionString(MigrateDatabaseWizardAction action) throws Exception {
            return action.m_targetServerInfo.createConnectString(action.m_targetServerInfo.getPassword(), action.m_targetServerInfo.getDatabase());
        }

        @Override
        protected void getScriptProperties(ServerType type, WizardInteractorData data, String schema) throws InteractorDataError, PhoenixException {
        }

        @Override
        protected String getConnectionString(MigrateDatabaseWizardAction action, JobProperties jobProps, ServerType type) throws InteractorDataError, SQLException {
            if (type == ServerType.SQLSERVER) {
                return action.m_targetServerInfo.createConnectString(action.m_targetServerInfo.getPassword(), action.m_targetServerInfo.getDatabase());
            }
            OracleServerInfo serverInfo = new OracleServerInfo("temp", action.m_targetServerInfo.getHost(), action.m_targetServerInfo.getDatabase());
            serverInfo.setUsername(jobProps.getScriptProperties().getProperty("pm.or.administrative_user"));
            serverInfo.setPort(action.m_targetServerInfo.getPort());
            serverInfo.setService(action.m_targetServerInfo.getService());
            return serverInfo.createConnectString(jobProps.getScriptProperties().getProperty("pm.or.administrative_password"), action.m_targetServerInfo.getDatabase());
        }

        private String createConnectionFromExistingConnectionForNewUser(String existingConnection, String userName, String password) throws ConnectionNotFoundException {
            ConnectStringParse parsedConnection = new ConnectStringParse(existingConnection);
            String host = parsedConnection.getServer();
            String port = parsedConnection.getPort();
            String instance = parsedConnection.getDatabase();
            BaseServerInfo info = null;
            if (parsedConnection.getDbtype() == ServerType.ORACLE) {
                info = new OracleServerInfo(MigrateDatabaseWizardAction.m_jobProperty, MigrateDatabaseWizardAction.m_jobProperty, MigrateDatabaseWizardAction.m_jobProperty);
            }
            if (parsedConnection.getDbtype() == ServerType.SQLSERVER) {
                info = new MSSqlServerInfo(MigrateDatabaseWizardAction.m_jobProperty, MigrateDatabaseWizardAction.m_jobProperty);
            }
            info.setHost(host);
            info.setPort(Integer.parseInt(port));
            info.setDatabase(instance);
            info.setUsername(userName);
            info.setService(parsedConnection.isOracleService());
            String connectionString = info.createConnectString(password);
            return connectionString;
        }

        void addSchemaJobsToRunner(WizardRunner runner, WizardInteractorData data, List<SchemaInfo> schemas, String pageId, Properties scriptProps, Properties jobNameProps, String connectString, ActionClass actionClass, JobProperties jobProperties) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException {
            JobProperties jobProps = new JobProperties();
            String sysuserConnectionString = jobProperties.getConnection(ConnectionClass.SYSADMIN);
            if (sysuserConnectionString != null) {
                jobProps.setConnection(ConnectionClass.SYSUSER, sysuserConnectionString);
            }
            jobProps.setConnection(ConnectionClass.SYSADMIN, connectString);
            jobProps.setConnection(ConnectionClass.ADMINISTRATIVE, connectString);
            jobProps.setConnection(ConnectionClass.PRIVILEGED, connectString);
            jobProps.setConnection(ConnectionClass.PUBUSER, connectString);
            boolean isOracle = actionClass.getServerType() == ServerType.ORACLE;
            String pxrptUserName = null;
            String pxrptPassword = null;
            if (isOracle) {
                pxrptUserName = scriptProps.getProperty("pm.or.odsplus_user");
                pxrptPassword = scriptProps.getProperty("pm.or.odsplus_password");
            } else {
                pxrptUserName = scriptProps.getProperty("pm.ss.odsplus_user");
                pxrptPassword = scriptProps.getProperty("pm.ss.odsplus_password");
            }
            String pxrptConnectString = this.createConnectionFromExistingConnectionForNewUser(connectString, pxrptUserName, pxrptPassword);
            jobProps.setConnection(ConnectionClass.REPORTING, pxrptConnectString);
            String bgjobConnectionString = connectString.substring(connectString.lastIndexOf("@"));
            bgjobConnectionString = data.getValue("configure_or_users", "bgjobuser") + "/" + data.getValue("configure_or_users", "bgjobpass") + bgjobConnectionString;
            jobProps.setConnection(ConnectionClass.UTILITY, bgjobConnectionString);
            String pubuserConnectionString = connectString.substring(connectString.lastIndexOf("@"));
            pubuserConnectionString = data.getValue("configure_or_users", "pubuser") + "/" + data.getValue("configure_or_users", "pubpass") + pubuserConnectionString;
            jobProps.setConnection(ConnectionClass.PUBUSER, pubuserConnectionString);
            String privuserConnectionString = connectString.substring(connectString.lastIndexOf("@"));
            privuserConnectionString = data.getValue("configure_or_users", "privuser") + "/" + data.getValue("configure_or_users", "privpass") + privuserConnectionString;
            jobProps.setConnection(ConnectionClass.PRIVILEGED, privuserConnectionString);
            jobProps.setJobProperties(jobNameProps);
            jobProps.getScriptProperties().putAll((Map<?, ?>)scriptProps);
            jobProps.setJobProperty("dataloader.commit.rows", data.getValue("migrate_options", "commitpoint"));
            jobNameProps.setProperty("dataloader.commit.rows", data.getValue("migrate_options", "commitpoint"));
            for (SchemaInfo info : schemas) {
                ArrayList jobFactories = new ArrayList();
                jobFactories.addAll(((ApplicationContextLogic)((MigrateDatabaseWizardAction)this.getAction()).contextLogic()).getApp().getSchemaSteps(info, actionClass));
                for (ParameterizedJobFactory parameterizedJobFactory : jobFactories) {
                    runner.addJob(pageId, (Job)parameterizedJobFactory.createJob(jobProps));
                }
            }
        }
    }

    private static abstract class AddCurrentJobsPage
    extends BaseWizardProgressor<MigrateDatabaseWizardAction> {
        public AddCurrentJobsPage(MigrateDatabaseWizardAction action, String page) {
            super(action, page);
        }

        protected abstract String getConnectionString(MigrateDatabaseWizardAction var1, JobProperties var2, ServerType var3) throws InteractorDataError, SQLException;

        @Override
        public final String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            try {
                this.addJobs(runner, data, jobProps);
            }
            catch (SQLException e) {
                return e.getLocalizedMessage();
            }
            catch (InteractorDataError e) {
                return e.getLocalizedMessage();
            }
            catch (ValueNotFound error) {
                return error.getLocalizedMessage();
            }
            catch (UpgradeSchemaIsSameAsCurrentSchema error) {
                return error.getLocalizedMessage();
            }
            catch (Throwable e) {
                e.printStackTrace();
                return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
            }
            return null;
        }

        protected void addOracleUsers(Properties scriptProperties, Properties jobNameProperties, MigrateDatabaseWizardAction action, WizardInteractorData data, WizardRunner runner, ServerType type) throws Exception {
        }

        protected abstract void addJobs(WizardRunner var1, WizardInteractorData var2, JobProperties var3) throws Exception;

        protected abstract Properties getJobProperties(WizardInteractorData var1) throws Exception;

        protected abstract void getScriptProperties(ServerType var1, WizardInteractorData var2, String var3) throws InteractorDataError, PhoenixException;

        @Override
        public void undo(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            runner.removePageJobs(this.getPage());
        }
    }
}

