/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.FieldTester;
import com.primavera.database.tools.dbmt.actions.InteractorPageDef;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TextDefinition;
import com.primavera.database.tools.dbmt.actions.TypeDef;
import com.primavera.database.tools.dbmt.actions.ValueDef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InteractorDataDef
implements InteractorPageDef {
    private Map<String, ValueDef> m_valueDefs = new HashMap<String, ValueDef>();
    private final Map<String, Collection<FieldTester>> m_validatorMap = new HashMap<String, Collection<FieldTester>>();
    private final Map<String, Collection<String>> m_dependencyMap = new HashMap<String, Collection<String>>();
    private Collection<FieldTester> m_finishValidators = new ArrayList<FieldTester>();
    private final Set<String> m_finishDependencies = new HashSet<String>();
    private final String m_dataPath;
    private boolean m_cancel = true;
    private final Map<String, TextDefinition> m_textFields = new HashMap<String, TextDefinition>();

    public InteractorDataDef(String dataPath) {
        this.m_dataPath = dataPath;
    }

    public void addValueDef(String valueId, ValueDef valueDef) {
        this.m_valueDefs.put(valueId, valueDef);
    }

    @Override
    public final ValueDef get(String valueId) {
        return this.m_valueDefs.get(valueId);
    }

    public final ValueDef put(String valueId, ValueDef def) {
        return this.m_valueDefs.put(valueId, def);
    }

    @Override
    public final String getDescKey() {
        return this.m_dataPath + ".desc";
    }

    @Override
    public final String getNameKey() {
        return this.m_dataPath + ".name";
    }

    @Override
    public final String getDataPath() {
        return this.m_dataPath;
    }

    public Iterable<Map.Entry<String, ValueDef>> getEntries() {
        return this.m_valueDefs.entrySet();
    }

    @Override
    public Iterable<String> getKeys() {
        return this.m_valueDefs.keySet();
    }

    @Override
    public int getSize() {
        return this.m_valueDefs.size();
    }

    @Override
    public final Map<String, Collection<FieldTester>> getValidatorMap() {
        return this.m_validatorMap;
    }

    @Override
    public final TypeDef getTypeDef(String fieldId) {
        ValueDef def = this.m_valueDefs.get(fieldId);
        if (def == null) {
            return null;
        }
        return def.getTypeDef();
    }

    @Override
    public Map<String, Collection<String>> getDependencyMap() {
        return this.m_dependencyMap;
    }

    public void addFinishValidator(FieldTester test) {
        ArrayList<FieldTester> tests = new ArrayList<FieldTester>();
        tests.add(test);
        this.addFinishValidators(tests);
    }

    public void addFinishValidators(Collection<FieldTester> testers) {
        if (testers == null) {
            return;
        }
        if (this.m_finishValidators == null) {
            this.m_finishValidators = new HashSet<FieldTester>();
        }
        this.m_finishValidators.addAll(testers);
    }

    public Collection<FieldTester> getFinishValidators() {
        return this.m_finishValidators;
    }

    public void addFinishDependency(String fieldId) {
        this.m_finishDependencies.add(fieldId);
    }

    public Set<String> getFinishDependencies() {
        return this.m_finishDependencies;
    }

    @Override
    public boolean doesFieldExit(String fieldId) {
        return this.m_valueDefs.get(fieldId) != null;
    }

    public void setCancel(boolean b) {
        this.m_cancel = b;
    }

    @Override
    public final boolean isCancel() {
        return this.m_cancel;
    }

    public void addText(String id, TextDefinition definition) {
        this.m_textFields.put(id, definition);
    }

    @Override
    public final String getText(String id, JobProperties props) {
        TextDefinition text = this.m_textFields.get(id);
        if (text == null) {
            DBMTLogger.error(Channel.DEV, "No text found for id " + id);
            return "";
        }
        return text.getInterpolatedString(props);
    }

    public String toString() {
        return "InteractorDataDef[dataPath=" + this.m_dataPath + "]";
    }
}

