/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaType;
import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.JobListener;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionType;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.RollbackJob;
import com.primavera.database.tools.dbmt.actions.SetActionTypeTransOp;
import com.primavera.database.tools.dbmt.actions.WizardActionOperation;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import com.primavera.database.tools.dbmt.gui.dialogs.CustomErrorDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;

public abstract class BaseWizardRunner
implements WizardRunner {
    private final Map<String, List<Job>> m_jobMap = new HashMap<String, List<Job>>();
    private final WizardInteractorData m_wizardData;
    private final String m_actionPath;
    private WizardActionOperation m_action = null;
    private List<String> m_pageStack = new ArrayList<String>();
    protected JobProperties m_jobProps = new JobProperties();
    protected String m_rollbackFilePrefix;
    protected static boolean m_ROLLBACK_ASKED = false;
    private Job m_runningJob;
    protected boolean m_isCompleteRollback = false;

    public BaseWizardRunner(WizardInteractorData wizardData, String actionPath) {
        this.m_wizardData = wizardData;
        this.m_actionPath = actionPath;
    }

    @Override
    public boolean commitAsync() {
        return true;
    }

    @Override
    public boolean inializePages() {
        return true;
    }

    public final String getActionPath() {
        return this.m_actionPath;
    }

    public final WizardInteractorData getData() {
        return this.m_wizardData;
    }

    public final WizardActionOperation getAction() {
        return this.m_action;
    }

    @Override
    public final boolean runWizard(WizardActionOperation action) {
        if (!this.getData().hasStart()) {
            DBMTLogger.error(Channel.DEV, "The Wizard Data " + this.getData().getName() + " does not have a start");
            return false;
        }
        this.m_action = action;
        return this.performWizardAction();
    }

    protected abstract boolean performWizardAction();

    @Override
    public void addJob(String pageId, Job job) {
        if (job == null) {
            return;
        }
        List<Job> pageJobs = this.m_jobMap.get(pageId);
        if (pageJobs == null) {
            pageJobs = new ArrayList<Job>();
            this.m_jobMap.put(pageId, pageJobs);
        }
        pageJobs.add(job);
    }

    @Override
    public void clearAllJobs() {
        this.m_jobMap.clear();
    }

    @Override
    public Iterable<Job> currentJobs(Iterable<String> pages) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (String page : pages) {
            List<Job> pageJobs = this.m_jobMap.get(page);
            if (pageJobs == null) continue;
            jobs.addAll(pageJobs);
        }
        return jobs;
    }

    @Override
    public void removePageJobs(String pageId) {
        List<Job> currentJobs = this.m_jobMap.get(pageId);
        if (currentJobs == null) {
            currentJobs = new ArrayList<Job>();
        }
        DBMTLogger.info(Channel.DEV, "Removing " + currentJobs.size() + " jobs from page " + pageId + ": " + this.createPrintableJobList(currentJobs));
        this.m_jobMap.put(pageId, new ArrayList());
    }

    private String createPrintableJobList(List<Job> jobs) {
        if (jobs.isEmpty()) {
            return "";
        }
        StringBuffer sbuf = new StringBuffer(jobs.get(0).toString());
        for (int i = 1; i < jobs.size(); ++i) {
            sbuf.append(", " + jobs.get(i).toString());
        }
        return sbuf.toString();
    }

    protected void pushPage(String pageId) {
        this.m_pageStack.add(pageId);
    }

    protected void popPage() {
        this.m_pageStack.remove(this.m_pageStack.size() - 1);
    }

    protected String topPage() {
        if (this.m_pageStack.isEmpty()) {
            return null;
        }
        return this.m_pageStack.get(this.m_pageStack.size() - 1);
    }

    protected boolean firstPage() {
        return this.m_pageStack.size() == 1;
    }

    @Override
    public List<String> stack() {
        return this.m_pageStack;
    }

    @Override
    public void displayLocalizedMessage(String message) {
        this.displayMessage(StringLocalizer.get(message));
    }

    protected boolean runJob(Job job, JobListener jobListener, JobWatcher watcher) {
        return job.execute(jobListener, watcher);
    }

    @Override
    public void commit(JobListener listener, List<Job> jobs, JobWatcher watcher) {
        Iterator<Job> iterator = jobs.iterator();
        while (iterator.hasNext()) {
            Job job;
            this.m_runningJob = job = iterator.next();
            if (this.runJob(job, listener, watcher)) continue;
            this.confirmAndRollBack(job);
            return;
        }
        jobs.clear();
    }

    private void confirmAndRollBack(Job job) {
        try {
            boolean rollbackSelected = false;
            if (this.m_jobProps.getJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY) != SchemaType.PM || this.m_jobProps.getJobProperty(SetActionTypeTransOp.ACTION_TYPE_KEY) != ActionType.UPGRADE) {
                return;
            }
            if (!m_ROLLBACK_ASKED) {
                m_ROLLBACK_ASKED = true;
                RollbackJob rollbackJob = new RollbackJob(this.m_jobProps, this.m_rollbackFilePrefix);
                JFrame frame = new JFrame();
                frame.setAlwaysOnTop(true);
                String confirmationMessage = StringLocalizer.get(this.getRollbackMessage(), new String[]{rollbackJob.getInstalledSchemaVersion(), rollbackJob.getToBeInstalledSchemaVersion()});
                rollbackSelected = CustomErrorDialog.showDialog(confirmationMessage, job.getFailureReason());
                if (rollbackSelected) {
                    rollbackJob.doRollBack(frame, this.m_isCompleteRollback);
                }
            }
        }
        catch (JobPropertyNotFound e) {
            DBMTLogger.warn(e.getLocalizedMessage());
        }
    }

    private String getRollbackMessage() {
        return "dbmt.rollback.confirmation.message.full";
    }

    @Override
    public Job getRunningJob() {
        return this.m_runningJob;
    }
}

