/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.ActionClass;
import com.primavera.database.tools.dbmt.ActionType;
import com.primavera.database.tools.dbmt.ApplicationContextLogic;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.AbstractJobAdder;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import java.util.ArrayList;
import java.util.List;

public class AddSSPMInstallJobs
extends AbstractJobAdder {
    private final ApplicationContextLogic m_context;

    public AddSSPMInstallJobs(String pageId, ApplicationContextLogic context) {
        super(pageId);
        this.m_context = context;
    }

    @Override
    protected void getJobsToAdd(WizardInteractorData data, JobProperties jobProps, List<Job> jobs) throws ValueNotFound, ConnectionNotFoundException, DBMTException {
        List<SchemaInfo> schemaList = AddSSPMInstallJobs.getSchemaInfo(jobProps);
        ActionClass actionClass = AddSSPMInstallJobs.getActionClass(ActionType.INSTALL, jobProps);
        for (SchemaInfo info : schemaList) {
            ArrayList jobFactories = new ArrayList();
            jobFactories.addAll(this.m_context.getApp().getSchemaSteps(info, actionClass));
            for (ParameterizedJobFactory parameterizedJobFactory : jobFactories) {
                jobs.add((Job)parameterizedJobFactory.createJob(jobProps));
            }
        }
    }
}

