/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.gui.MenuDefinition;
import com.primavera.database.tools.dbmt.xml.MenuActionMap;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.NodeLink;
import com.primavera.database.tools.dbmt.xml.util.SimpleHandler;
import com.primavera.database.tools.dbmt.xml.util.menu.nodes.MenuNode;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class MenuLoader {
    public MenuDefinition loadFromResource(String resourceName) {
        MenuDefinition menuDef = new MenuDefinition(MenuActionMap.inst());
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            InputStream input = ClassLoader.getSystemClassLoader().getResourceAsStream(resourceName);
            if (input == null) {
                DBMTLogger.error(Channel.DEV, "Unable to find the resource (" + resourceName + ") from property " + resourceName);
                return menuDef;
            }
            parser.parse(input, (DefaultHandler)new SimpleHandler(MenuLoader.getRootHandler(menuDef)));
        }
        catch (Throwable e) {
            DBMTLogger.error(Channel.USER, "Unable to load menu from " + resourceName + ": " + e);
            e.printStackTrace();
        }
        return menuDef;
    }

    private static NodeLink getRootHandler(final MenuDefinition menuDef) {
        return new NodeLink(){

            @Override
            public NodeHandler nextNode(String elemName, Attributes attr) {
                if ("menu".equals(elemName)) {
                    return new MenuNode(menuDef, attr);
                }
                return null;
            }

            @Override
            public String path() {
                return "";
            }
        };
    }
}

